/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.connectors.InheritedConfig;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.ListMap;

class InheritedConfigs {
    private final ListMap<String, InstanceField> inheritedFieldsByOptionNames = new ListMap();

    InheritedConfigs() {
    }

    public void collect(ConfigurationBase instance, Field field) {
        if (!field.isAnnotationPresent(InheritedConfig.class)) {
            return;
        }
        String optionName = field.getAnnotation(InheritedConfig.class).value();
        this.inheritedFieldsByOptionNames.add((Object)optionName, (Object)new InstanceField(instance, field));
    }

    public void addAll(InheritedConfigs other) {
        this.inheritedFieldsByOptionNames.addAll(other.inheritedFieldsByOptionNames);
    }

    public void injectInheritedConfigs(CodeScopeName codeScopeName, Set<ConfigOptionDescriptorBase> availableOptions) {
        ArrayList exceptions = new ArrayList();
        for (Map.Entry instanceFieldsByOptionName : this.inheritedFieldsByOptionNames) {
            String inheritedConfig = (String)instanceFieldsByOptionName.getKey();
            for (ConfigOptionDescriptorBase configuredOption : availableOptions) {
                if (!configuredOption.getName().equals(inheritedConfig)) continue;
                ((List)instanceFieldsByOptionName.getValue()).stream().map(instanceField -> instanceField.set(configuredOption.retrieveValue(codeScopeName))).filter(Optional::isPresent).map(Optional::get).forEach(exceptions::add);
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalArgumentException aggregatedException = new IllegalArgumentException("Failed to inject some inherited options (only using first exception as cause): \n" + exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n")), (Throwable)exceptions.getFirst());
            exceptions.forEach(aggregatedException::addSuppressed);
            throw aggregatedException;
        }
    }

    private record InstanceField(Object instance, Field field) {
        public Optional<Exception> set(Object value) throws IllegalArgumentException {
            try {
                this.field().setAccessible(true);
                this.field().set(this.instance(), value);
            }
            catch (Exception e) {
                return Optional.of(e);
            }
            return Optional.empty();
        }
    }
}

