/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.BooleanOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;

public class MetricDescriptor
extends ConfigurationItemBase {
    @JsonProperty(value="metricEnabled")
    private boolean metricEnabled;

    public MetricDescriptor(String name, String description) {
        this(name, description, true);
    }

    public MetricDescriptor(String name, String description, boolean enabled) {
        this(name, description, enabled, ConfigExposed.EConfigVisibility.DEFAULT);
    }

    public MetricDescriptor(String name, String description, boolean enabled, ConfigExposed.EConfigVisibility visibility) {
        super(name, description, visibility);
        this.metricEnabled = enabled;
    }

    public MetricDescriptor(MetricDescriptor other) {
        this(other.getName(), other.getDescription(), other.isMetricEnabled(), other.getVisibility());
    }

    @Override
    public boolean requiredToolPresent(Set<EAnalysisTool> tools) {
        return true;
    }

    public boolean isMetricEnabled() {
        return this.metricEnabled;
    }

    @Override
    public void setValue(String optionValue, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        this.metricEnabled = BooleanOptionDescriptor.parseBoolean(optionValue, this.getName());
    }

    @Override
    public boolean isActive() {
        return this.metricEnabled;
    }
}

