/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.CollectionOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class StringListOptionDescriptor
extends CollectionOptionDescriptorBase<List<String>> {
    private static final long serialVersionUID = 1L;

    public StringListOptionDescriptor(ConfigExposed annotation, Field field) {
        super(annotation, field, String.class.getSimpleName());
    }

    public StringListOptionDescriptor(String name, String description, boolean multilineText, IConfigOptionDescriptorBehaviour behaviour) {
        super(name, description, multilineText, behaviour, String.class.getSimpleName());
    }

    @JsonCreator
    public StringListOptionDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description) {
        super(name, description);
    }

    @Override
    protected Object parseValue(String optionValue) throws ProjectConfigurationException {
        return CollectionUtils.parseMultiValueStringToList((String)optionValue, (boolean)true);
    }

    @Override
    protected List<String> convertFromList(List<String> value) {
        return value;
    }

    @Override
    public String retrieveValueAsString(CodeScopeName codeScopeName) {
        Object value = this.retrieveValue(codeScopeName);
        if (value == null) {
            return null;
        }
        return StringUtils.stripPrefix((String)StringUtils.stripSuffix((String)String.valueOf(value), (String)"]"), (String)"[");
    }
}

