/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.teamscale.core.analysis.trigger.AnalysisStepContext;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.analysis.trigger.MultiThreadedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import java.util.Collections;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class PrivilegedTriggerBase
extends MultiThreadedTriggerBase {
    private static final int HIGH_PRIORITY_EXECUTION_ORDER = -1;
    protected static final int HIGHEST_PRIORITY_EXECUTION_ORDER = -2;
    protected IndexLayer indexLayer;
    protected JobDescriptor jobDescriptor;
    protected ILockProvider lockProvider;
    protected IMessageBroker messageBroker;
    protected InstanceConfiguration instanceConfiguration;
    private int retryCount;

    public final void init(JobDescriptor jobDescriptor, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration, AnalysisStepContext context) {
        this.init(jobDescriptor, indexLayer, lockProvider, instanceConfiguration, context, 0);
    }

    public final void init(JobDescriptor jobDescriptor, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration, AnalysisStepContext context, int retryCount) {
        super.init(context);
        this.jobDescriptor = jobDescriptor;
        this.indexLayer = indexLayer;
        this.lockProvider = lockProvider;
        this.messageBroker = indexLayer.getMessageBroker();
        this.instanceConfiguration = instanceConfiguration;
        this.retryCount = retryCount;
        this.postInitHook();
    }

    @VisibleForTesting
    public @Nullable CommitDescriptor getSchedulingCommit() {
        return this.jobDescriptor.getSchedulingCommitDescriptor();
    }

    @VisibleForTesting
    public String getDefaultBranchName() throws StorageException {
        return this.indexLayer.openNonHistorizedProjectIndex(MetaIndex.class, (IProjectId)this.jobDescriptor.getInternalProjectId()).getDefaultBranchName();
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.ISOLATED;
    }

    public int getExecutionOrderIndex() {
        return -1;
    }

    public boolean isPeriodic() {
        return false;
    }

    public Set<String> getReadStores() {
        return Collections.emptySet();
    }

    public Set<String> getReadOnlyPreviousStores() {
        return Collections.emptySet();
    }

    public Set<String> getWriteStores() {
        return Collections.emptySet();
    }

    public Set<String> getTransitiveWriteStores() {
        return Collections.emptySet();
    }

    public Set<String> getCrossCommitBlockingWriteStores() {
        return Collections.emptySet();
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.NORMAL;
    }

    protected void postInitHook() {
    }

    public boolean canCauseSchedulingConflicts() {
        return true;
    }

    public boolean preserveInCaseOfRollback() {
        return true;
    }

    public boolean isCancelable() {
        return true;
    }

    protected void setLoggingContextInformation(String contextInformation) {
        this.getContext().setLoggingContextInformation(contextInformation);
    }

    protected final void addPostTriggerAction(IPostTriggerAction.IPrivilegedPostTriggerAction action) {
        this.getContext().addPostTriggerAction(action);
    }

    protected CanonicalFile getTemporaryDirectory() {
        return this.getContext().getTempFileFactory().getTemporaryDirectory();
    }

    protected int getRetryCount() {
        return this.retryCount;
    }
}

