/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import jakarta.ws.rs.core.NewCookie;
import java.net.URI;
import java.time.Duration;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

class SessionCookie {
    private static final String SESSION_COOKIE_NAME = "teamscale-session";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private final String sessionCookieName;

    public SessionCookie(int port, String instanceName) {
        Object instanceNameSuffix = "";
        if (!StringUtils.isEmpty((String)instanceName)) {
            instanceNameSuffix = "-" + WHITESPACE_PATTERN.matcher(instanceName.toLowerCase()).replaceAll("");
        }
        this.sessionCookieName = "teamscale-session-" + port + (String)instanceNameSuffix;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public NewCookie createSessionCookie(URI baseUri, String token, Duration maxAge) {
        return this.createSessionCookie(baseUri, token, (int)maxAge.toSeconds());
    }

    public NewCookie createSessionCookie(URI baseUri, String token, int maxAge) {
        String path = StringUtils.ensureStartsWith((String)baseUri.getPath(), (String)"/");
        boolean secure = "https".equals(baseUri.getScheme()) && !Boolean.getBoolean("com.teamscale.ssl.disable-redirect");
        return ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(this.getSessionCookieName()).value(token)).path(path)).version(1)).maxAge(maxAge)).secure(secure)).httpOnly(false)).sameSite(secure ? NewCookie.SameSite.NONE : NewCookie.SameSite.LAX)).build();
    }

    public NewCookie createSessionRemovalCookie(URI baseUri) {
        return this.createSessionCookie(baseUri, "invalid", 0);
    }
}

