/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public abstract class AuthenticationToolProviderBase<ServerDescription extends ServerDescriptionBase>
implements IAuthenticationToolProvider {
    private final GlobalStorageSystem globalStorageSystem;
    private final IMessageBroker messageBroker;

    protected AuthenticationToolProviderBase(GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        this.globalStorageSystem = globalStorageSystem;
        this.messageBroker = messageBroker;
    }

    protected NamedServer<ServerDescription> getServer(String serverName) throws StorageException, AuthenticationToolException {
        NamedServer<ServerDescription> server = ServerDescriptionBase.getServer(this.openGlobalIndex(ServerOptionIndex.class), this.getAuthenticationTool(), this.getServerDescriptionClass(), serverName);
        if (server == null) {
            throw new AuthenticationToolClientException("Server does not exist: " + serverName);
        }
        return server;
    }

    @Override
    public List<String> getServerList() throws StorageException {
        return AuthenticationToolUtils.getServerNames(this.getAuthenticationTool(), this.openGlobalIndex(ServerOptionIndex.class));
    }

    protected final <T extends IGlobalIndex> T openGlobalIndex(Class<T> globalIndex) throws StorageException {
        return (T)this.globalStorageSystem.openGlobalIndex(globalIndex);
    }

    protected final IMessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    protected final IAuthenticationToolProvider getToolProvider(EAuthenticationTool tool) {
        return AuthenticationToolUtils.getProvider(tool, this.globalStorageSystem, this.messageBroker);
    }

    protected abstract Class<ServerDescription> getServerDescriptionClass();
}

