/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.GitHubOrganizationDescription;
import com.teamscale.core.authenticate.github.GitHubUtils;
import com.teamscale.core.authenticate.github.client.GitHubAuthClient;
import com.teamscale.core.authenticate.github.dto.Account;
import com.teamscale.core.authenticate.github.dto.GitHubOrganization;
import com.teamscale.core.authenticate.github.dto.GitHubTeam;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.core.authenticate.github.index.OAuthTokenIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class GitHubAuthenticationUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private static GitHubAuthClient createOrganizationClient(NamedServer<GitHubOrganizationDescription> organization) {
        return new GitHubAuthClient(GitHubUtils.getApiBaseUrl(organization.name()), organization.serverDescription().username, organization.serverDescription().password, LOGGER);
    }

    public static Optional<User> getOrCreateAuthenticatedUser(String accessToken, String serverUrl, GitHubApplicationDescription description, UserIndex userIndex, UserGroupIndex groupIndex, OAuthTokenIndex oAuthTokenIndex, IMessageBroker messageBroker) throws StorageException, AuthenticationToolException {
        GitHubUser user;
        GitHubAuthClient authClient = new GitHubAuthClient(GitHubUtils.getApiBaseUrl(serverUrl), null, accessToken, LOGGER);
        try {
            user = authClient.getUser();
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Failed to get authenticated GitHub user from " + serverUrl + ".", e);
        }
        if (!GitHubAuthenticationUtils.userIsInAllowedGitHubOrganizations(description, authClient)) {
            return Optional.empty();
        }
        User teamscaleUser = userIndex.getUser(user.getLogin());
        if (teamscaleUser == null) {
            if (!description.createUserOnFirstLogin) {
                return Optional.empty();
            }
            teamscaleUser = GitHubAuthenticationUtils.convertGitHubUser(user, null);
            UserGroupUtils.addUserToGroups(teamscaleUser, description.getGroups(), groupIndex);
        }
        if (description.syncTeamsOnLogin) {
            try {
                GitHubAuthenticationUtils.synchronizeUserTeamMemberships(authClient, teamscaleUser, user.getLogin(), description, groupIndex);
            }
            catch (AuthenticationToolException | StorageException e) {
                LOGGER.error("Error during synchronization of team memberships for {}", (Object)teamscaleUser, e);
            }
        }
        GitHubAuthenticationUtils.addEmailsToAliases(authClient, teamscaleUser, user);
        userIndex.setUser(teamscaleUser, messageBroker);
        oAuthTokenIndex.storeUserOAuthToken(teamscaleUser.getUsername(), new OAuthTokenIndex.OAuthToken(user.getLogin(), accessToken));
        return Optional.of(teamscaleUser);
    }

    private static boolean userIsInAllowedGitHubOrganizations(GitHubApplicationDescription description, GitHubAuthClient authClient) throws AuthenticationToolException {
        List<String> appAndUserOrganizations = GitHubAuthenticationUtils.getOrganizationsForAppAndUser(description, authClient).stream().map(Account::getLogin).toList();
        List<String> lowerCaseAllowedOrgs = description.getAllowedOrganizations().stream().map(String::toLowerCase).toList();
        return appAndUserOrganizations.stream().map(String::toLowerCase).anyMatch(lowerCaseAllowedOrgs::contains);
    }

    private static List<GitHubOrganization> getOrganizationsForAppAndUser(GitHubApplicationDescription description, GitHubAuthClient authClient) throws AuthenticationToolException {
        List<GitHubOrganization> organizations;
        try {
            organizations = authClient.getOrganizations();
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Could not retrieve organizations for Github application " + description.urlName, e);
        }
        return organizations;
    }

    private static void addEmailsToAliases(GitHubAuthClient client, User teamscaleUser, GitHubUser gitHubUser) throws AuthenticationToolException {
        ArrayList<String> emails;
        try {
            emails = new ArrayList<String>(client.getVerifiedUserEMails());
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Failed to get verified user email addresses from GitHub.", e);
        }
        if (!StringUtils.isEmpty((String)teamscaleUser.getEmailAddress())) {
            emails.remove(teamscaleUser.getEmailAddress());
        }
        teamscaleUser.addAliases(emails);
        teamscaleUser.addAliases(GitHubAuthenticationUtils.getGitHubNoReplyUserEmail(gitHubUser));
    }

    public static Optional<User> updateOrImportUser(String username, NamedServer<GitHubOrganizationDescription> organization, UserIndex userIndex, IMessageBroker messageBroker) throws StorageException, AuthenticationToolException {
        User user = GitHubAuthenticationUtils.findUser(username, organization);
        if (user == null) {
            return Optional.empty();
        }
        UserUtils.updateUserInIndex(userIndex, user, null, messageBroker);
        return Optional.of(user);
    }

    private static @Nullable User findUser(String username, NamedServer<GitHubOrganizationDescription> organization) throws AuthenticationToolException {
        GitHubAuthClient client = GitHubAuthenticationUtils.createOrganizationClient(organization);
        try {
            if (!client.isUserMemberOfOrganization(organization.serverDescription().organizationName, username)) {
                return null;
            }
            GitHubUser user = client.getUser(username);
            return GitHubAuthenticationUtils.convertGitHubUser(user, organization.name());
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Fetching user failed!", e);
        }
    }

    private static User convertGitHubUser(GitHubUser user, String organizationName) {
        Pair<String, String> fullName = GitHubUtils.parseFullName(user.getName());
        String authenticator = "GitHubOAuth";
        if (!StringUtils.isEmpty((String)organizationName)) {
            authenticator = AuthenticationToolUtils.buildAuthenticator(authenticator, organizationName);
        }
        String userEmail = StringUtils.emptyIfNull((String)user.getEmail());
        User teamscaleUser = new User(user.getLogin(), (String)fullName.getFirst(), (String)fullName.getSecond(), userEmail, authenticator);
        teamscaleUser.addAliases(GitHubAuthenticationUtils.getGitHubNoReplyUserEmail(user));
        return teamscaleUser;
    }

    private static String getGitHubNoReplyUserEmail(GitHubUser gitHubUser) {
        return gitHubUser.getId() + "+" + gitHubUser.getLogin() + "@users.noreply.github.com";
    }

    public static UserGroup findTeam(String teamName, NamedServer<GitHubOrganizationDescription> organization) throws AuthenticationToolException {
        Optional<GitHubTeam> team = GitHubAuthenticationUtils.getTeam(teamName, organization);
        if (team.isEmpty()) {
            throw new AuthenticationEntityNotFoundException("Group " + teamName + " was not found!");
        }
        return new UserGroup(team.get().name(), EAuthenticationTool.GITHUB, teamName, organization.name());
    }

    public static List<String> getUserNamesFromGroup(NamedServer<GitHubOrganizationDescription> organization, UserGroup group) throws AuthenticationToolException {
        Optional<GitHubTeam> team = GitHubAuthenticationUtils.getTeam(group.getName(), organization);
        if (team.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        GitHubAuthClient client = GitHubAuthenticationUtils.createOrganizationClient(organization);
        try {
            List<GitHubUser> users = client.getTeamMembers(organization.serverDescription().organizationName, team.get());
            return CollectionUtils.map(users, Account::getLogin);
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Fetching users from group '" + group.getName() + "' failed!", e);
        }
    }

    public static Set<String> getGroupsOfUser(NamedServer<GitHubOrganizationDescription> organization, User user) throws AuthenticationToolException {
        String organizationName = organization.serverDescription().organizationName;
        String username = user.getUsername();
        if (GitHubAuthenticationUtils.findUser(user.getUsername(), organization) == null) {
            throw new AuthenticationEntityNotFoundException("User '%s' is not part of the GitHub organization: %s".formatted(username, organizationName));
        }
        HashSet<String> result = new HashSet<String>();
        GitHubAuthClient client = GitHubAuthenticationUtils.createOrganizationClient(organization);
        try {
            List<GitHubTeam> teams = client.getOrganizationTeams(organization.serverDescription().organizationName);
            for (GitHubTeam team : teams) {
                if (!client.isUserMemberOfTeam(organizationName, team, username)) continue;
                result.add(team.name());
            }
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Fetching user groups failed!", e);
        }
        return result;
    }

    private static Optional<GitHubTeam> getTeam(String teamName, NamedServer<GitHubOrganizationDescription> organization) throws AuthenticationToolException {
        GitHubAuthClient client = GitHubAuthenticationUtils.createOrganizationClient(organization);
        try {
            List<GitHubTeam> teams = client.getOrganizationTeams(organization.serverDescription().organizationName);
            for (GitHubTeam team : teams) {
                if (!team.name().equals(teamName)) continue;
                return Optional.of(team);
            }
            return Optional.empty();
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Fetching group failed!", e);
        }
    }

    public static boolean teamExists(NamedServer<GitHubOrganizationDescription> organization, String teamName) throws AuthenticationToolException {
        return GitHubAuthenticationUtils.getTeam(teamName, organization).isPresent();
    }

    public static String requestAccessToken(String authenticationCode, GitHubApplicationDescription applicationDescription) throws ServiceCallException {
        GitHubAuthClient client = new GitHubAuthClient(applicationDescription.serverUrl, null, null, LOGGER);
        return client.requestUserAccessToken(applicationDescription.clientId, applicationDescription.clientSecret, authenticationCode);
    }

    private static void synchronizeUserTeamMemberships(GitHubAuthClient authClient, User teamscaleUser, String githubUsername, GitHubApplicationDescription application, UserGroupIndex groupIndex) throws StorageException, AuthenticationToolException {
        List<GitHubAuthClient.OrganizationTeam> userTeams;
        List<String> allowedOrganizations = application.getAllowedOrganizations();
        if (allowedOrganizations.isEmpty()) {
            LOGGER.debug("No allowed organizations configured for GitHub app {}, skipping team synchronization", (Object)application.urlName);
            return;
        }
        try {
            userTeams = authClient.getUserTeams(allowedOrganizations, githubUsername);
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Failed to fetch team memberships for user " + githubUsername + " from GitHub.", e);
        }
        HashSet<String> currentTeamGroupNames = new HashSet<String>();
        UnmodifiableList internalGroups = groupIndex.getAllUserGroups().getSecondList();
        List allTsGroupsForThisApp = (List)groupIndex.getAllUserGroups().getSecondList().stream().filter(group -> group.originatesFrom(EAuthenticationTool.GITHUB, allowedOrganizations)).collect(CollectionUtils.toArrayList());
        for (GitHubAuthClient.OrganizationTeam orgTeam : userTeams) {
            boolean needsToCreateTsGroup;
            boolean groupExistsButIsNotFromThisApp;
            String githubTeamName = orgTeam.team().name();
            String tsGroupName = application.teamGroupPrefix + githubTeamName;
            if (application.createTeamGroupsAutomatically && (groupExistsButIsNotFromThisApp = internalGroups.stream().anyMatch(group -> group.getName().equals(tsGroupName) && !group.originatesFrom(EAuthenticationTool.GITHUB, allowedOrganizations)))) {
                LOGGER.error("Skipping team '{}' because a manually created group with name '{}' already exists (createTeamGroupsAutomatically is enabled)", (Object)githubTeamName, (Object)tsGroupName);
                continue;
            }
            currentTeamGroupNames.add(tsGroupName);
            if (!application.createTeamGroupsAutomatically || !(needsToCreateTsGroup = allTsGroupsForThisApp.stream().noneMatch(group -> githubTeamName.equals(group.getRemoteGroup())))) continue;
            UserGroup newGroup = new UserGroup(tsGroupName, EAuthenticationTool.GITHUB, githubTeamName, orgTeam.organizationName());
            groupIndex.setGroup(newGroup);
            allTsGroupsForThisApp.add(newGroup);
            LOGGER.info("Created Teamscale group '{}' for GitHub team '{}' in organization '{}'", (Object)tsGroupName, (Object)githubTeamName, (Object)orgTeam.organizationName());
        }
        UserGroupCheckResult userMembershipCheck = GitHubAuthenticationUtils.checkGroupMembershipForSingleUser(teamscaleUser, currentTeamGroupNames, allTsGroupsForThisApp);
        UserGroupUtils.addUserToGroups(teamscaleUser, userMembershipCheck.groupsToAdd(), groupIndex);
        UserGroupUtils.removeUserFromGroups(teamscaleUser, userMembershipCheck.groupsToRemove(), groupIndex);
        LOGGER.debug("Synchronized team memberships for user {}: added to {} groups, removed from {} groups", (Object)githubUsername, (Object)userMembershipCheck.groupsToAdd().size(), (Object)userMembershipCheck.groupsToRemove().size());
    }

    private static UserGroupCheckResult checkGroupMembershipForSingleUser(User teamscaleUser, Set<String> currentTeamGroupNames, List<UserGroup> allTsGroupsForThisApp) {
        ArrayList<String> groupsToAdd = new ArrayList<String>();
        ArrayList<String> groupsToRemove = new ArrayList<String>();
        for (UserGroup group : allTsGroupsForThisApp) {
            String username = teamscaleUser.getUsername();
            boolean userInGroup = group.containsUser(username);
            boolean shouldBeInGroup = currentTeamGroupNames.contains(group.getName());
            if (userInGroup && !shouldBeInGroup) {
                groupsToRemove.add(group.getName());
                continue;
            }
            if (userInGroup || !shouldBeInGroup) continue;
            groupsToAdd.add(group.getName());
        }
        return new UserGroupCheckResult(groupsToAdd, groupsToRemove);
    }

    private GitHubAuthenticationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private record UserGroupCheckResult(List<String> groupsToAdd, List<String> groupsToRemove) {
    }
}

