/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ImportGroupsStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.GitHubOrganizationDescription;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.function.FunctionWithException;

class GitHubImportGroupsStrategy
extends ImportGroupsStrategyBase<GitHubOrganizationDescription> {
    public GitHubImportGroupsStrategy(NamedServer<GitHubOrganizationDescription> server, UserGroupIndex groupIndex, UserIndex userIndex, IMessageBroker messageBroker, FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException> toolProviderFactory) {
        super(server, groupIndex, userIndex, messageBroker, toolProviderFactory);
    }

    @Override
    protected UserGroup findGroup(String groupName) throws AuthenticationToolException {
        return GitHubAuthenticationUtils.findTeam(groupName, this.getServer());
    }

    @Override
    protected ListMap<NamedServer<GitHubOrganizationDescription>, String> getUsersInGroup(UserGroup group) throws AuthenticationToolException {
        ListMap users = new ListMap();
        List<String> gitHubUsers = GitHubAuthenticationUtils.getUserNamesFromGroup(this.getServer(), group);
        users.addAll(this.getServer(), gitHubUsers);
        return users;
    }
}

