/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.ImportUsersStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.GitHubOrganizationDescription;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class GitHubImportUsersStrategy
extends ImportUsersStrategyBase<GitHubOrganizationDescription> {
    private final UserIndex userIndex;
    private final IMessageBroker messageBroker;

    public GitHubImportUsersStrategy(NamedServer<GitHubOrganizationDescription> server, UserIndex userIndex, IMessageBroker messageBroker) {
        super(server);
        this.userIndex = userIndex;
        this.messageBroker = messageBroker;
    }

    @Override
    public List<User> importUser(String userName) throws StorageException, AuthenticationToolException {
        return CollectionUtils.emptyListIfEmpty(GitHubAuthenticationUtils.updateOrImportUser(userName, this.getServer(), this.userIndex, this.messageBroker));
    }
}

