/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolProviderBase;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.github.GitHubImportGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubImportUsersStrategy;
import com.teamscale.core.authenticate.github.GitHubOrganizationDescription;
import com.teamscale.core.authenticate.github.GitHubSynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubSynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.github.GitHubSynchronizeUsersStrategy;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;

public class GitHubProvider
extends AuthenticationToolProviderBase<GitHubOrganizationDescription> {
    public GitHubProvider(GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        super(globalStorageSystem, messageBroker);
    }

    @Override
    public IImportUsersStrategy createImportUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new GitHubImportUsersStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.getMessageBroker());
    }

    @Override
    public IImportGroupsStrategy createImportGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        GitHubProvider gitHubProvider = this;
        return new GitHubImportGroupsStrategy(this.getServer(serverName), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(UserIndex.class), this.getMessageBroker(), (FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException>)((FunctionWithException)x$0 -> gitHubProvider.getToolProvider((EAuthenticationTool)((Object)x$0))));
    }

    @Override
    public ISynchronizeUsersStrategy createSynchronizeUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new GitHubSynchronizeUsersStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.getMessageBroker());
    }

    @Override
    public ISynchronizeGroupsStrategy createSynchronizeGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new GitHubSynchronizeGroupsStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(UserGroupIndex.class), this.getMessageBroker(), this.createImportGroupsStrategy(serverName));
    }

    @Override
    public ISynchronizeUserGroupsStrategy createSynchronizeUserGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new GitHubSynchronizeUserGroupsStrategy(this.getServer(serverName), this.openGlobalIndex(UserGroupIndex.class));
    }

    @Override
    public IAutoCompletionStrategy createUserAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public IAutoCompletionStrategy createGroupAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.GITHUB;
    }

    @Override
    public Class<GitHubOrganizationDescription> getServerDescriptionClass() {
        return GitHubOrganizationDescription.class;
    }
}

