/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.SynchronizeUsersStrategyBase;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.GitHubOrganizationDescription;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.Optional;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class GitHubSynchronizeUsersStrategy
extends SynchronizeUsersStrategyBase<GitHubOrganizationDescription> {
    private final IMessageBroker messageBroker;

    public GitHubSynchronizeUsersStrategy(NamedServer<GitHubOrganizationDescription> server, UserIndex userIndex, IMessageBroker messageBroker) {
        super(server, userIndex);
        this.messageBroker = messageBroker;
    }

    @Override
    public Optional<String> synchronizeUser(User user) throws StorageException, AuthenticationToolException {
        return GitHubAuthenticationUtils.updateOrImportUser(user.getUsername(), this.getServer(), this.userIndex, this.messageBroker).map(User::getUsername);
    }

    @Override
    protected String getAuthenticatorIdentifier() {
        return "GitHubOAuth";
    }
}

