/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.client.GitHubClientBase;
import com.teamscale.core.authenticate.github.client.IGitHubAuthApi;
import com.teamscale.core.authenticate.github.dto.Email;
import com.teamscale.core.authenticate.github.dto.GitHubOrganization;
import com.teamscale.core.authenticate.github.dto.GitHubTeam;
import com.teamscale.core.authenticate.github.dto.GitHubTeamMembership;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class GitHubAuthClient
extends GitHubClientBase<IGitHubAuthApi> {
    public GitHubAuthClient(String apiBaseUrl, @Nullable String username, @Nullable String passwordOrAccessToken, @Nullable Logger interactionLogger) {
        super(apiBaseUrl, username, passwordOrAccessToken, interactionLogger, IGitHubAuthApi.class);
    }

    public GitHubUser getUser() throws ServiceCallException {
        return ((IGitHubAuthApi)this.gitHubApi).getUser();
    }

    public GitHubUser getUser(String username) throws ServiceCallException {
        return ((IGitHubAuthApi)this.gitHubApi).getUser(username);
    }

    public List<String> getVerifiedUserEMails() throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubAuthApi)this.gitHubApi).getUserEmails(100), ((IGitHubAuthApi)this.gitHubApi)::getUserEmailsFromNextPage).stream().filter(Email::isVerified).map(Email::getEmail).toList();
    }

    public List<GitHubOrganization> getOrganizations() throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubAuthApi)this.gitHubApi).getOrganizations(100), ((IGitHubAuthApi)this.gitHubApi)::getOrganizationsFromNextPage);
    }

    public boolean isUserMemberOfOrganization(String organizationName, String username) throws ServiceCallException {
        try {
            ((IGitHubAuthApi)this.gitHubApi).checkUserIsOrganizationMember(organizationName, username);
            return true;
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public List<GitHubTeam> getOrganizationTeams(String organizationName) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubAuthApi)this.gitHubApi).getOrganizationTeams(organizationName, 100), ((IGitHubAuthApi)this.gitHubApi)::getOrganizationTeamsFromNextPage);
    }

    public List<GitHubUser> getTeamMembers(String organizationName, GitHubTeam team) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubAuthApi)this.gitHubApi).getTeamMembers(organizationName, team.slug(), 100), ((IGitHubAuthApi)this.gitHubApi)::getTeamMembersFromNextPage);
    }

    public boolean isUserMemberOfTeam(String organizationName, GitHubTeam team, String username) throws ServiceCallException {
        try {
            GitHubTeamMembership membershipInfo = ((IGitHubAuthApi)this.gitHubApi).getTeamMembership(organizationName, team.slug(), username);
            return membershipInfo.state().equals("active");
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public List<OrganizationTeam> getUserTeams(List<String> organizationNames, String username) throws ServiceCallException {
        ArrayList<OrganizationTeam> userTeams = new ArrayList<OrganizationTeam>();
        for (String organizationName : organizationNames) {
            List<GitHubTeam> teams = this.getOrganizationTeams(organizationName);
            for (GitHubTeam team : teams) {
                if (!this.isUserMemberOfTeam(organizationName, team, username)) continue;
                userTeams.add(new OrganizationTeam(organizationName, team));
            }
        }
        return userTeams;
    }

    public String requestUserAccessToken(String clientId, String clientSecret, String authenticationCode) throws ServiceCallException {
        return ((IGitHubAuthApi)this.gitHubApi).requestUserAccessToken(clientId, clientSecret, authenticationCode).accessToken();
    }

    public record OrganizationTeam(String organizationName, GitHubTeam team) {
    }
}

