/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.index;

import com.google.common.base.Preconditions;
import org.conqat.lib.commons.string.StringUtils;

public record OrgOrUserInstallationsKey(String gitHubServerUrl, String organizationOrUser) {
    private static final String SEPARATOR = "#";

    public OrgOrUserInstallationsKey(String gitHubServerUrl, String organizationOrUser) {
        this.gitHubServerUrl = OrgOrUserInstallationsKey.getCanonicalServerUrl(gitHubServerUrl);
        this.organizationOrUser = organizationOrUser;
    }

    String asIndexKey() {
        return this.gitHubServerUrl() + SEPARATOR + this.organizationOrUser();
    }

    static OrgOrUserInstallationsKey fromIndexKey(String indexKey) {
        String[] splitKey = indexKey.split(SEPARATOR);
        Preconditions.checkArgument((splitKey.length == 2 ? 1 : 0) != 0, (String)"Key '%s' contains an unexpected amount of '%s' separators.", (Object)indexKey, (Object)SEPARATOR);
        return new OrgOrUserInstallationsKey(splitKey[0], splitKey[1]);
    }

    private static String getCanonicalServerUrl(String githubServerUrl) {
        return StringUtils.stripSuffix((String)githubServerUrl, (String)"/");
    }
}

