/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolProviderBase;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.ldap.LDAPGroupAutoCompletionStrategy;
import com.teamscale.core.authenticate.ldap.LDAPImportGroupsStrategy;
import com.teamscale.core.authenticate.ldap.LDAPImportUsersStrategy;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.authenticate.ldap.LDAPSynchronizeGroupsAsyncStrategy;
import com.teamscale.core.authenticate.ldap.LDAPSynchronizeUsersStrategy;
import com.teamscale.core.authenticate.ldap.LDAPUserAutoCompletionStrategy;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;

public class LDAPProvider
extends AuthenticationToolProviderBase<LDAPServerDescription> {
    public LDAPProvider(GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        super(globalStorageSystem, messageBroker);
    }

    @Override
    public IImportUsersStrategy createImportUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new LDAPImportUsersStrategy(this.getServer(serverName), this.openGlobalIndex(ServerOptionIndex.class), this.openGlobalIndex(UserIndex.class), this.getMessageBroker());
    }

    @Override
    public IImportGroupsStrategy createImportGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        LDAPProvider lDAPProvider = this;
        return new LDAPImportGroupsStrategy(this.getServer(serverName), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(ServerOptionIndex.class), this.getMessageBroker(), (FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException>)((FunctionWithException)x$0 -> lDAPProvider.getToolProvider((EAuthenticationTool)((Object)x$0))));
    }

    @Override
    public ISynchronizeUsersStrategy createSynchronizeUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new LDAPSynchronizeUsersStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(ServerOptionIndex.class), this.getMessageBroker());
    }

    @Override
    public ISynchronizeGroupsStrategy createSynchronizeGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new LDAPSynchronizeGroupsAsyncStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(GlobalAnalysisProgressIndex.class), this.openGlobalIndex(PermissionIndex.class), this.openGlobalIndex(ServerOptionIndex.class), this.createImportGroupsStrategy(serverName), this.getMessageBroker());
    }

    @Override
    public ISynchronizeUserGroupsStrategy createSynchronizeUserGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        throw new AuthenticationToolException("Not implemented");
    }

    @Override
    public IAutoCompletionStrategy createUserAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new LDAPUserAutoCompletionStrategy(this.getServer(serverName));
    }

    @Override
    public IAutoCompletionStrategy createGroupAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new LDAPGroupAutoCompletionStrategy(this.getServer(serverName));
    }

    @Override
    public Class<LDAPServerDescription> getServerDescriptionClass() {
        return LDAPServerDescription.class;
    }

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.LDAP;
    }
}

