/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.config;

import java.util.OptionalInt;
import org.conqat.engine.persistence.config.DatabaseConfiguration;

public class InstanceConfiguration {
    private final int httpPort;
    private final int httpsPort;
    private final String instanceName;
    private final String urlPrefix;
    private final DatabaseConfiguration databaseConfiguration;

    public InstanceConfiguration(int httpPort, int httpsPort, String instanceName, String urlPrefix, DatabaseConfiguration databaseConfiguration) {
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.instanceName = instanceName;
        this.urlPrefix = urlPrefix;
        this.databaseConfiguration = databaseConfiguration;
    }

    public OptionalInt getHttpPort() {
        return InstanceConfiguration.portIntToOptional(this.httpPort);
    }

    public OptionalInt getHttpsPort() {
        return InstanceConfiguration.portIntToOptional(this.httpsPort);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.databaseConfiguration;
    }

    private static OptionalInt portIntToOptional(int port) {
        if (port <= 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(port);
    }
}

