/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.ICommitDescriptorSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class CommitAssociationIndexBase<T extends CommitAssociatedObjectBase>
extends IndexBase
implements IRollbackableIndex {
    private static final byte[] OLDEST_TIMESTAMP_KEY = ByteArrayUtils.longToByteArray((long)-1L);
    private static final byte[] NEWEST_TIMESTAMP_KEY = ByteArrayUtils.longToByteArray((long)-2L);
    private static final ICommitDescriptorSerializer.TimestampBranch KEY_SERIALIZER = ICommitDescriptorSerializer.TimestampBranch.INSTANCE;

    protected CommitAssociationIndexBase(IStore store) {
        super(store);
    }

    public @Nullable T getEntry(CommitDescriptor commit) throws StorageException {
        return this.deserializeEntry(this.store.get(CommitAssociationIndexBase.createCommitKey(commit)));
    }

    protected byte[] serializeEntry(T entry) throws StorageException {
        try {
            return SerializationUtils.serializeToByteArray(entry);
        }
        catch (IOException e) {
            throw new StorageException("Serialization failed!", (Throwable)e);
        }
    }

    protected T deserializeEntry(byte[] bytes) throws StorageException {
        return (T)((CommitAssociatedObjectBase)StorageUtils.deserialize((byte[])bytes));
    }

    @VisibleForTesting
    public static byte[] createCommitKey(CommitDescriptor commit) {
        return KEY_SERIALIZER.serialize(commit);
    }

    private static CommitDescriptor deserializeCommitKey(byte[] key) {
        return KEY_SERIALIZER.deserialize(key);
    }

    public void setEntry(T entry) throws StorageException {
        this.setEntry(CommitAssociationIndexBase.createCommitKey(((CommitAssociatedObjectBase)entry).getCommit()), entry);
    }

    public List<T> getEntries(long startTimestamp, long endTimestamp) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        ISerializer<Long, byte[]> prefixSerializer = KEY_SERIALIZER.timestampOnlyPrefixSerializer();
        this.store.scan((byte[])prefixSerializer.serialize((Object)startTimestamp), (byte[])prefixSerializer.serialize((Object)endTimestamp), (IKeyValueCallback)callback);
        List result = callback.getResultOrThrowException();
        Collections.sort(result);
        return result;
    }

    public @NonNull List<@Nullable T> getEntries(List<CommitDescriptor> commits) throws StorageException {
        List keys = CollectionUtils.map(commits, CommitAssociationIndexBase::createCommitKey);
        return CollectionUtils.mapWithException((Collection)this.store.get(keys), this::deserializeEntry);
    }

    public static List<CommitDescriptor> deltaToCommits(KeyDelta delta) {
        ArrayList<CommitDescriptor> result = new ArrayList<CommitDescriptor>();
        for (StorageKey key : delta.getAddedOrChangedKeys()) {
            byte[] keyBytes = key.getBytes();
            if (keyBytes.length <= 8) continue;
            result.add(CommitAssociationIndexBase.deserializeCommitKey(keyBytes));
        }
        return result;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
            String branchName = entry.getKey();
            long timestamp = entry.getValue();
            if (timestamp != Long.MAX_VALUE) {
                ++timestamp;
            }
            byte[] beginKey = CommitAssociationIndexBase.createCommitKey(new CommitDescriptor(branchName, timestamp));
            byte[] endKey = CommitAssociationIndexBase.createCommitKey(new CommitDescriptor(branchName, Long.MAX_VALUE));
            StorageUtils.deleteRange((ConvenientStore)this.store, (byte[])beginKey, (byte[])endKey, key -> branchName.equals(CommitAssociationIndexBase.deserializeCommitKey(key).getBranchName()));
        }
        this.recalculateTimestamps();
    }

    private void recalculateTimestamps() throws StorageException {
        AtomicLong maxTimestamp = new AtomicLong(0L);
        AtomicLong minTimestamp = new AtomicLong(Long.MAX_VALUE);
        ISerializer<Long, byte[]> prefixSerializer = KEY_SERIALIZER.timestampOnlyPrefixSerializer();
        this.store.scanKeys((byte[])prefixSerializer.serialize((Object)0L), (byte[])prefixSerializer.serialize((Object)Long.MAX_VALUE), (key, value) -> {
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOf(key, 8));
            maxTimestamp.accumulateAndGet(timestamp, Math::max);
            minTimestamp.accumulateAndGet(timestamp, Math::min);
        });
        if (minTimestamp.get() < Long.MAX_VALUE) {
            this.store.put(NEWEST_TIMESTAMP_KEY, ByteArrayUtils.longToByteArray((long)maxTimestamp.get()));
            this.store.put(OLDEST_TIMESTAMP_KEY, ByteArrayUtils.longToByteArray((long)minTimestamp.get()));
        } else {
            this.store.remove(NEWEST_TIMESTAMP_KEY);
            this.store.remove(OLDEST_TIMESTAMP_KEY);
        }
    }

    public long getOldestTimestamp() throws StorageException {
        return this.obtainTimestamp(OLDEST_TIMESTAMP_KEY, Long.MAX_VALUE);
    }

    public long getNewestTimestamp() throws StorageException {
        return this.obtainTimestamp(NEWEST_TIMESTAMP_KEY, 0L);
    }

    private long obtainTimestamp(byte[] key, long defaultValue) throws StorageException {
        byte[] bytes = this.store.get(key);
        if (bytes == null) {
            return defaultValue;
        }
        return ByteArrayUtils.byteArrayToLong((byte[])bytes);
    }

    protected void setEntry(byte[] key, T entry) throws StorageException {
        PairList values = new PairList();
        values.add((Object)key, (Object)this.serializeEntry(entry));
        long timestamp = ((CommitAssociatedObjectBase)entry).getTimestamp();
        if (timestamp < this.getOldestTimestamp()) {
            values.add((Object)OLDEST_TIMESTAMP_KEY, (Object)ByteArrayUtils.longToByteArray((long)timestamp));
        }
        if (timestamp > this.getNewestTimestamp()) {
            values.add((Object)NEWEST_TIMESTAMP_KEY, (Object)ByteArrayUtils.longToByteArray((long)timestamp));
        }
        this.store.put(values);
    }

    public int getOverallNumberOfEntries() throws StorageException {
        return Math.max(0, StorageUtils.keyCount((IStore)this.store) - 2);
    }
}

