/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.teamscale.core.index.CompactParentedCommitDescriptorSerializer;
import com.teamscale.core.index.ICommitDescriptorSerializer;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.compare.ComparableUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="commit-descriptors", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={ParentedCommitDescriptor.class})
public class CommitDescriptorIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String NAME = "commit-descriptors";
    private static final CompactParentedCommitDescriptorSerializer VALUE_SERIALIZER = new CompactParentedCommitDescriptorSerializer();
    private static final ICommitDescriptorSerializer KEY_SERIALIZER = ICommitDescriptorSerializer.BranchTimestamp.COMPACT;

    public CommitDescriptorIndex(IStore store) {
        super(store);
    }

    public static CommitDescriptorIndex open(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance(projectId)) {
            return new CommitDescriptorIndex((IStore)new InMemoryStore());
        }
        return indexLayer.openNonHistorizedProjectIndex(CommitDescriptorIndex.class, projectId);
    }

    @VisibleForTesting
    static byte @NonNull [] serializeKey(CommitDescriptor commit) {
        return KEY_SERIALIZER.serialize(commit);
    }

    private static @NonNull List<byte[]> serializeKeys(Collection<CommitDescriptor> keys) throws StorageException {
        return KEY_SERIALIZER.serialize(keys);
    }

    private static @NonNull CommitDescriptor deserializeKey(byte[] key) {
        return KEY_SERIALIZER.deserialize(key);
    }

    public void insertCommit(ParentedCommitDescriptor commit) throws StorageException {
        for (CommitDescriptor parent : commit.getParentCommits()) {
            CCSMAssert.isNotNull((Object)this.getCommit(parent), (String)("Encountered non-existing parent " + String.valueOf(parent) + " of commit " + String.valueOf(commit)));
        }
        this.store.put(CommitDescriptorIndex.serializeKey(commit.getCommit()), VALUE_SERIALIZER.serialize(commit));
    }

    public @Nullable ParentedCommitDescriptor getCommit(CommitDescriptor commit) throws StorageException {
        byte[] value = this.store.get(CommitDescriptorIndex.serializeKey(commit));
        if (value == null) {
            return null;
        }
        return VALUE_SERIALIZER.deserialize(value);
    }

    public List<@Nullable ParentedCommitDescriptor> getCommits(Collection<CommitDescriptor> commits) throws StorageException {
        return this.getCommitsForKeys(CommitDescriptorIndex.serializeKeys(commits));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<@Nullable ParentedCommitDescriptor> getCommitsForKeys(List<byte[]> keys) throws StorageException {
        @Nullable List values = this.store.get(keys);
        ArrayList<ParentedCommitDescriptor> result = new ArrayList<ParentedCommitDescriptor>(values.size());
        for (byte[] value : values) {
            if (value == null) {
                result.add(null);
                continue;
            }
            result.add(VALUE_SERIALIZER.deserialize(value));
        }
        return result;
    }

    public List<ParentedCommitDescriptor> getAllCommits() throws StorageException {
        return this.getCommitsForKeys(StorageUtils.listKeys((IStore)this.store));
    }

    public List<ParentedCommitDescriptor> getCommitsForBranch(final @NonNull String branchName) throws StorageException {
        final ArrayList<ParentedCommitDescriptor> commits = new ArrayList<ParentedCommitDescriptor>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                    commits.add(VALUE_SERIALIZER.deserialize(value));
                }
            }
        };
        this.store.scan(StringUtils.stringToBytes((String)branchName), (IKeyValueCallback)callback);
        callback.throwCaughtException();
        Collections.sort(commits);
        return commits;
    }

    public CommitHistoryScanner getCommitHistoryCollector(CommitDescriptor lastCommitToConsider) {
        return new CommitHistoryScanner(this, lastCommitToConsider);
    }

    public List<CommitDescriptor> getCommitHistory(CommitDescriptor lastCommitToConsider, long lowerTimestampBoundary) throws StorageException {
        CommitHistoryScanner commitHistoryScanner = this.getCommitHistoryCollector(lastCommitToConsider);
        ArrayList result = new ArrayList();
        long timeRange = lastCommitToConsider.getTimestamp() - lowerTimestampBoundary;
        commitHistoryScanner.scanTimeRange(timeRange, parentedCommit -> result.add(parentedCommit.getCommit()));
        return CollectionUtils.sort(result);
    }

    public Optional<ParentedCommitDescriptor> getLatestCommitForBranch(String branchName) throws StorageException {
        return Optional.ofNullable((ParentedCommitDescriptor)CollectionUtils.getLast(this.getCommitsForBranch(branchName)));
    }

    public List<ParentedCommitDescriptor> getCommitHistoryWithFirstParentCommits(CommitDescriptor child, long lowerTimestampBoundary) throws StorageException {
        CommitDescriptor parentCommit;
        ArrayList<ParentedCommitDescriptor> parents = new ArrayList<ParentedCommitDescriptor>();
        ParentedCommitDescriptor current = this.getCommit(child);
        if (current != null) {
            parents.add(current);
        }
        HashMap<CommitDescriptor, byte[]> commitCache = new HashMap<CommitDescriptor, byte[]>();
        while (current != null && (parentCommit = current.getFirstParentCommit()) != null) {
            if (!commitCache.containsKey(parentCommit)) {
                this.loadAllCommitsOnBranchIntoCache(parentCommit, lowerTimestampBoundary, commitCache);
            }
            if (!commitCache.containsKey(parentCommit) || (current = VALUE_SERIALIZER.deserialize(commitCache.get(parentCommit))).getTimestamp() <= lowerTimestampBoundary) break;
            parents.add(current);
        }
        return parents;
    }

    private void loadAllCommitsOnBranchIntoCache(CommitDescriptor child, long lowerTimestampBoundary, HashMap<CommitDescriptor, byte[]> cache) throws StorageException {
        String branchName = child.getBranchName();
        this.store.scan(CommitDescriptorIndex.serializeKey(new CommitDescriptor(branchName, lowerTimestampBoundary)), CommitDescriptorIndex.serializeKey(child.cloneWithIncrementedTimestamp()), (key, value) -> {
            if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                CommitDescriptor deserialized = CommitDescriptorIndex.deserializeKey(key);
                HashMap hashMap = cache;
                synchronized (hashMap) {
                    cache.put(deserialized, value);
                }
            }
        });
    }

    public Optional<CommitDescriptor> getFirstActualCommitBefore(CommitDescriptor commit, long lowerTimestampBoundary) throws StorageException {
        return this.getFirstActualCommitBeforeOrAt(commit.cloneWithDecrementedTimestamp(), lowerTimestampBoundary);
    }

    public Optional<CommitDescriptor> getFirstActualCommitBeforeOrAt(CommitDescriptor commit, long lowerTimestampBoundary) throws StorageException {
        long upperTimestampBoundary = commit.getTimestamp();
        if (upperTimestampBoundary < Long.MAX_VALUE) {
            byte[] directHit = this.store.get(CommitDescriptorIndex.serializeKey(commit));
            if (directHit != null) {
                return Optional.of(commit);
            }
            ++upperTimestampBoundary;
        }
        AtomicReference max = new AtomicReference();
        String branchName = commit.getBranchName();
        this.store.scanKeys(CommitDescriptorIndex.serializeKey(new CommitDescriptor(branchName, lowerTimestampBoundary)), CommitDescriptorIndex.serializeKey(new CommitDescriptor(branchName, upperTimestampBoundary)), (key, value) -> {
            if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                CommitDescriptor deserialized = CommitDescriptorIndex.deserializeKey(key);
                max.accumulateAndGet(deserialized, ComparableUtils.maxBy(Comparator.nullsFirst(Comparator.naturalOrder())));
            }
        });
        return Optional.ofNullable((CommitDescriptor)max.get());
    }

    static boolean keyLengthMatchesBranchNameLengthExactly(byte[] key, String branchName) {
        byte[] branchTimestampKeyFromBranchName = CommitDescriptorIndex.serializeKey(new CommitDescriptor(branchName, 1L));
        return key.length == branchTimestampKeyFromBranchName.length;
    }

    public List<CommitDescriptor> getAllCommitsOnBranchBetweenInclusive(CommitDescriptor startCommit, CommitDescriptor endCommit) throws StorageException {
        CCSMAssert.isTrue((startCommit.getTimestamp() <= endCommit.getTimestamp() ? 1 : 0) != 0, (String)"Start commit must be before end commit");
        CCSMAssert.isTrue((boolean)startCommit.getBranchName().equals(endCommit.getBranchName()), (String)("Can only get commit range for one specific branch, however two different branches were given: " + startCommit.getBranchName() + ", " + endCommit.getBranchName()));
        if (endCommit.getTimestamp() < Long.MAX_VALUE) {
            endCommit = endCommit.cloneWithIncrementedTimestamp();
        }
        String branchName = startCommit.getBranchName();
        ArrayList<CommitDescriptor> commitDescriptors = new ArrayList<CommitDescriptor>();
        this.store.scanKeys(CommitDescriptorIndex.serializeKey(startCommit), CommitDescriptorIndex.serializeKey(endCommit), (key, value) -> {
            if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                CommitDescriptor deserialized = CommitDescriptorIndex.deserializeKey(key);
                List list = commitDescriptors;
                synchronized (list) {
                    commitDescriptors.add(deserialized);
                }
            }
        });
        return commitDescriptors;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        String branchName = Objects.requireNonNull((String)CollectionUtils.getAny(timestampByBranch.keySet()));
        if (timestampByBranch.size() == 1 && PreCommitUtils.isPrecommitBranch(branchName)) {
            this.rollbackPrecommitBranch(branchName);
            return;
        }
        HashSet<CommitDescriptor> deleted = new HashSet<CommitDescriptor>();
        HashSet requiredParents = new HashSet();
        for (ParentedCommitDescriptor commit : this.getAllCommits()) {
            Long cutOffTimestamp = timestampByBranch.get(commit.getBranchName());
            if (cutOffTimestamp != null && commit.getTimestamp() > cutOffTimestamp) {
                deleted.add(commit.getCommit());
                continue;
            }
            requiredParents.addAll(commit.getParentCommits());
        }
        if (!CollectionUtils.intersectionSet(deleted, (Collection[])new Collection[]{requiredParents}).isEmpty()) {
            throw new StorageException("Did not perform rollback as this would lead to missing parent commits.");
        }
        List<byte[]> deleteKeys = CommitDescriptorIndex.serializeKeys(deleted);
        this.store.remove(deleteKeys);
    }

    private void rollbackPrecommitBranch(String branchName) throws StorageException {
        ArrayList toDelete = new ArrayList();
        byte[] prefix = Objects.requireNonNull(StringUtils.stringToBytes((String)branchName));
        int expectedLength = prefix.length + 8;
        this.store.scanKeys(prefix, (key, value) -> {
            if (key.length == expectedLength) {
                List list = toDelete;
                synchronized (list) {
                    toDelete.add(key);
                }
            }
        });
        if (!toDelete.isEmpty()) {
            this.store.remove(toDelete);
        }
    }

    public class CommitHistoryScanner {
        private final PriorityQueue<CommitDescriptor> unresolvedCommits;
        private final HashSet<CommitDescriptor> encounteredCommits;
        private final HashMap<CommitDescriptor, byte[]> commitCache;
        private final CommitDescriptor latestCommitToConsider;
        private long lowerTimestampBoundary;
        private boolean foundFirstCommit;
        final /* synthetic */ CommitDescriptorIndex this$0;

        private CommitHistoryScanner(CommitDescriptorIndex this$0, CommitDescriptor latestCommitToConsider) {
            CommitDescriptorIndex commitDescriptorIndex = this$0;
            Objects.requireNonNull(commitDescriptorIndex);
            this.this$0 = commitDescriptorIndex;
            this.unresolvedCommits = new PriorityQueue(Comparator.reverseOrder());
            this.encounteredCommits = new HashSet();
            this.commitCache = new HashMap();
            this.foundFirstCommit = false;
            this.latestCommitToConsider = latestCommitToConsider;
            this.lowerTimestampBoundary = latestCommitToConsider.getTimestamp();
        }

        public void scanTimeRange(long timeRange, Consumer<? super ParentedCommitDescriptor> commitDescriptorConsumer) throws StorageException {
            CCSMAssert.isTrue((timeRange >= 0L ? 1 : 0) != 0, (String)"Can't scan negative time range.");
            this.scanStartTimestamp(Math.max(0L, this.lowerTimestampBoundary - timeRange), commitDescriptorConsumer);
        }

        public void scanStartTimestamp(long lowerTimestampBoundary, Consumer<? super ParentedCommitDescriptor> commitDescriptorConsumer) throws StorageException {
            CCSMAssert.isTrue((this.lowerTimestampBoundary >= lowerTimestampBoundary ? 1 : 0) != 0, (String)"Can't scan into the future");
            this.lowerTimestampBoundary = lowerTimestampBoundary;
            this.loadFirstCommitIfNeeded();
            CommitDescriptor unresolvedCommit = this.unresolvedCommits.peek();
            while (unresolvedCommit != null && unresolvedCommit.getTimestamp() > this.lowerTimestampBoundary) {
                ParentedCommitDescriptor resolvedCommit = this.getParentedCommit(unresolvedCommit);
                CCSMAssert.isNotNull((Object)resolvedCommit, (String)"Inconsistent commit cache or commit index encountered while collecting commit history.");
                commitDescriptorConsumer.accept((ParentedCommitDescriptor)resolvedCommit);
                HashSet newCommits = CollectionUtils.differenceSet((Collection)resolvedCommit.getParentCommits(), (Collection[])new Collection[]{this.encounteredCommits});
                this.unresolvedCommits.addAll(newCommits);
                this.encounteredCommits.addAll(newCommits);
                this.unresolvedCommits.poll();
                unresolvedCommit = this.unresolvedCommits.peek();
            }
        }

        private void loadFirstCommitIfNeeded() throws StorageException {
            if (this.foundFirstCommit) {
                return;
            }
            Optional<CommitDescriptor> firstCommitInHistory = this.this$0.getFirstActualCommitBeforeOrAt(this.latestCommitToConsider, this.lowerTimestampBoundary);
            this.foundFirstCommit = firstCommitInHistory.isPresent();
            firstCommitInHistory.ifPresent(this.unresolvedCommits::add);
            firstCommitInHistory.ifPresent(this.encounteredCommits::add);
        }

        public long getLowerTimestampBoundary() {
            return this.lowerTimestampBoundary;
        }

        private ParentedCommitDescriptor getParentedCommit(CommitDescriptor commitWithoutParents) throws StorageException {
            if (!this.commitCache.containsKey(commitWithoutParents)) {
                this.this$0.loadAllCommitsOnBranchIntoCache(commitWithoutParents, this.lowerTimestampBoundary, this.commitCache);
            }
            return VALUE_SERIALIZER.deserialize(this.commitCache.get(commitWithoutParents));
        }
    }
}

