/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.teamscale.core.index.CommitDescriptorIndex;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CommitResolver {
    private final ConcurrentHashMap<CommitDescriptor, ParentedCommitDescriptor> firstActualCommitCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<CommitDescriptor, List<CommitDescriptor>> commitParentCache = new ConcurrentHashMap();

    public Optional<CommitDescriptor> resolveCommit(CommitDescriptor commit, IBranchingLayer branchingLayer, ProjectStorageSystem projectStorageSystem) throws StorageException {
        return this.resolveCommit(commit, branchingLayer, CommitResolver.openCommitDescriptorIndex(projectStorageSystem));
    }

    private static CommitDescriptorIndex openCommitDescriptorIndex(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
    }

    protected Optional<CommitDescriptor> resolveCommit(CommitDescriptor commit, IBranchingLayer branchingLayer, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        if (commit == null) {
            return Optional.empty();
        }
        if (CommitResolver.commitExists(commit, branchingLayer)) {
            return Optional.of(commit);
        }
        if (branchingLayer.readHeadCommit(commit.getBranchName()) == null && branchingLayer.isEmpty()) {
            return Optional.empty();
        }
        Optional<CommitDescriptor> commitDescriptor = this.getFirstActualCommitBeforeOrAt(commit, commitDescriptorIndex).map(ParentedCommitDescriptor::getCommit);
        if (commitDescriptor.isPresent() && CommitResolver.commitExists(commitDescriptor.get(), branchingLayer)) {
            return commitDescriptor;
        }
        if (commitDescriptor.isEmpty()) {
            return Optional.empty();
        }
        return this.resolveCommitFromCache(commit, branchingLayer, commitDescriptor.get(), commitDescriptorIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CommitDescriptor> resolveCommitFromCache(CommitDescriptor originalCommit, IBranchingLayer branchingLayer, CommitDescriptor commitDescriptor, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        List knownCachedParents;
        List list = knownCachedParents = this.commitParentCache.computeIfAbsent(originalCommit, ignored -> new ArrayList());
        synchronized (list) {
            if (knownCachedParents.isEmpty()) {
                return CommitResolver.findParentCommitForStore(knownCachedParents, commitDescriptor, branchingLayer, commitDescriptorIndex);
            }
            for (CommitDescriptor parent : knownCachedParents) {
                if (!CommitResolver.commitExists(parent, branchingLayer)) continue;
                return Optional.of(parent);
            }
            CommitDescriptor oldestParent = (CommitDescriptor)knownCachedParents.stream().min(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("Could not find oldest parent commit"));
            return CommitResolver.findParentCommitForStore(knownCachedParents, oldestParent, branchingLayer, commitDescriptorIndex);
        }
    }

    private static Optional<CommitDescriptor> findParentCommitForStore(List<CommitDescriptor> knownCachedParents, CommitDescriptor lookupCommit, IBranchingLayer branchingLayer, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        while (!CommitResolver.commitExists(lookupCommit, branchingLayer)) {
            ParentedCommitDescriptor parentedCommitDescriptor = commitDescriptorIndex.getCommit(lookupCommit);
            if (parentedCommitDescriptor == null) {
                throw new StorageException("Did not find parented commit descriptor for " + String.valueOf(lookupCommit));
            }
            UnmodifiableList parents = parentedCommitDescriptor.getParentCommits();
            if (parents.isEmpty()) {
                return Optional.empty();
            }
            lookupCommit = (CommitDescriptor)parents.getFirst();
            knownCachedParents.add(lookupCommit);
        }
        return Optional.of(lookupCommit);
    }

    public Optional<ParentedCommitDescriptor> getFirstActualCommitBeforeOrAt(CommitDescriptor commit, ProjectStorageSystem projectStorageSystem) throws StorageException {
        return this.getFirstActualCommitBeforeOrAt(commit, CommitResolver.openCommitDescriptorIndex(projectStorageSystem));
    }

    private static Optional<CommitDescriptor> searchFirstParentHierarchyForCommitBeforeOrAt(String branch, long timestamp, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        List<ParentedCommitDescriptor> commitsOnBranch = commitDescriptorIndex.getCommitsForBranch(branch);
        if (!commitsOnBranch.isEmpty()) {
            CommitDescriptor parent = commitsOnBranch.getFirst().getCommit();
            while (parent != null && parent.getTimestamp() > timestamp) {
                parent = Objects.requireNonNull(commitDescriptorIndex.getCommit(parent)).getFirstParentCommit();
            }
            if (parent != null) {
                return Optional.of(parent);
            }
        }
        return Optional.empty();
    }

    private static boolean commitExists(CommitDescriptor commit, IBranchingLayer branchingLayer) throws StorageException {
        return branchingLayer.commitExists(commit.getBranchName(), commit.getTimestamp());
    }

    public CommitDescriptor resolveCommit(CommitDescriptor commit, Class<? extends IStorageIndex> indexClass, ProjectStorageSystem projectStorageSystem) throws StorageException {
        return this.resolveCommit(commit, indexClass, IStorageIndex.getIndexAnnotation(indexClass).name(), projectStorageSystem);
    }

    public CommitDescriptor resolveCommit(CommitDescriptor commit, Class<? extends IStorageIndex> indexClass, String indexName, ProjectStorageSystem storageSystem) throws StorageException {
        IBranchingLayer branchingLayer = storageSystem.openBranchingLayer(indexName, indexClass);
        return this.resolveCommit(commit, branchingLayer, storageSystem).orElse(commit);
    }

    public CommitDescriptor resolveCommit(HistoryAccessOption historyAccessOption, Class<? extends IStorageIndex> indexClass, ProjectStorageSystem storageSystem) throws StorageException {
        return this.resolveCommit(CommitResolver.convertToCommit(historyAccessOption), indexClass, storageSystem);
    }

    public CommitDescriptor resolveCommit(HistoryAccessOption historyAccessOption, Class<? extends IStorageIndex> indexClass, String indexName, ProjectStorageSystem storageSystem) throws StorageException {
        return this.resolveCommit(CommitResolver.convertToCommit(historyAccessOption), indexClass, indexName, storageSystem);
    }

    private static CommitDescriptor convertToCommit(HistoryAccessOption historyAccessOption) {
        String branchName = historyAccessOption.getBranchName();
        if (historyAccessOption.isReadHead()) {
            return CommitDescriptor.latestOnBranch((String)branchName);
        }
        return new CommitDescriptor(branchName, historyAccessOption.getTimestamp());
    }

    protected Optional<ParentedCommitDescriptor> getFirstActualCommitBeforeOrAt(CommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        ParentedCommitDescriptor cachedDescriptor = this.firstActualCommitCache.get(commit);
        if (cachedDescriptor != null) {
            return Optional.of(cachedDescriptor);
        }
        Optional<CommitDescriptor> commitDescriptor = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(commit, 0L);
        if (commitDescriptor.isEmpty()) {
            commitDescriptor = CommitResolver.searchFirstParentHierarchyForCommitBeforeOrAt(commit.getBranchName(), commit.getTimestamp(), commitDescriptorIndex);
        }
        if (commitDescriptor.isEmpty()) {
            return Optional.empty();
        }
        ParentedCommitDescriptor parentedCommit = commitDescriptorIndex.getCommit(commitDescriptor.get());
        if (parentedCommit == null) {
            return Optional.empty();
        }
        this.firstActualCommitCache.putIfAbsent(commit, parentedCommit);
        return Optional.of(this.firstActualCommitCache.get(commit));
    }
}

