/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import java.util.Arrays;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public sealed interface ICommitDescriptorSerializer
extends ISerializer<CommitDescriptor, byte[]> {
    public byte @NonNull [] serialize(@NonNull CommitDescriptor var1);

    public @NonNull CommitDescriptor deserialize(byte @NonNull [] var1);

    public static enum TimestampBranch implements ICommitDescriptorSerializer
    {
        INSTANCE;


        @Override
        public byte @NonNull [] serialize(@NonNull CommitDescriptor commit) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.longToByteArray((long)commit.getTimestamp()), StringUtils.stringToBytes((String)commit.getBranchName())});
        }

        @Override
        public @NonNull CommitDescriptor deserialize(byte @NonNull [] value) {
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOf(value, 8));
            String branchName = StringUtils.bytesToString((byte[])Arrays.copyOfRange(value, 8, value.length));
            return new CommitDescriptor(branchName, timestamp);
        }

        public ISerializer<Long, byte[]> timestampOnlyPrefixSerializer() {
            return ISerializer.forLong();
        }
    }

    public static enum BranchTimestamp implements ICommitDescriptorSerializer
    {
        DEFAULT(new byte[]{1, 2, 1}),
        COMPACT(ByteArrayUtils.EMPTY_ARRAY);

        private final byte[] separator;

        private BranchTimestamp(byte[] separator) {
            this.separator = Arrays.copyOf(separator, separator.length);
        }

        @Override
        public byte @NonNull [] serialize(@NonNull CommitDescriptor commit) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)commit.getBranchName()), this.separator, ByteArrayUtils.longToByteArray((long)commit.getTimestamp())});
        }

        @Override
        public @NonNull CommitDescriptor deserialize(byte @NonNull [] value) {
            String branchName = StringUtils.bytesToString((byte[])Arrays.copyOf(value, value.length - 8 - this.separator.length));
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(value, value.length - 8, value.length));
            return new CommitDescriptor(branchName, timestamp);
        }

        public ISerializer<String, byte[]> branchOnlyPrefixSerializer() {
            return ISerializer.of(branch -> ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)branch), this.separator}), bytes -> StringUtils.bytesToString((byte[])Arrays.copyOf(bytes, ((byte[])bytes).length - this.separator.length)));
        }
    }
}

