/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.license;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.license.LicenseException;
import com.teamscale.core.license.LicenseUtil;
import com.teamscale.core.license.LicensedFeatureCollection;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class License {
    private static final String PUBLIC_KEY = "308201B83082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0381850002818100DA2A3FB8A662DDBC152A8B0E7608C1C8D5C61CF739EFD5767AD1CA500A7B5DB6AE44244AA3D152AFFDBE20731758BB38D3780A78B317C0EBC3D442ED61E0A1BFAB7AC34431D4B7822F32F40E64DB8F6744B09C72B82A127494DA1C0A8D349CC882F203CE634CB52C5193639D3FF1E96CD092DC73ABA07D088FFC8D0BB0FEF39F";
    @VisibleForTesting
    static final String LICENSEE_OVERWRITE_ENV_VAR_NAME = "TS_LICENSE_LICENSEE";
    @VisibleForTesting
    static final String VALIDITY_OVERWRITE_ENV_VAR_NAME = "TS_LICENSE_VALID_UNTIL";
    @VisibleForTesting
    static final String USER_COUNT_OVERWRITE_ENV_VAR_NAME = "TS_LICENSE_USERS";
    private static final String EXPIRATION_WARN_DAYS_ENV_VAR_NAME = "TS_LICENSE_EXPIRATION_WARN_DAYS";
    private static final Period EXPIRATION_PERIOD = Period.ofDays(License.loadEnvIntOrDefault(System::getenv, "TS_LICENSE_EXPIRATION_WARN_DAYS", 30));
    private static final String LICENSE_DATE_FORMAT = "dd.MM.yyyy";
    private static final String VALID_FROM_KEY = "validFrom";
    private static final String VALID_TO_KEY = "validTo";
    private static final String LICENSEE_KEY = "licensee";
    private static final String NUM_USERS_KEY = "num-users";
    @Deprecated
    private static final String LANGUAGES_KEY = "languages";
    @Deprecated
    private static final String REPOSITORY_CONNECTORS_KEY = "repository-connectors";
    @Deprecated
    private static final String ISSUE_TRACKERS_KEY = "issue-trackers";
    @Deprecated
    private static final String REQUIREMENTS_MANAGEMENT_TOOLS_KEY = "requirements-management-tools";
    @Deprecated
    private static final String LDAP_KEY = "ldap";
    @Deprecated
    private static final String AUDIT_KEY = "audit";
    @Deprecated
    private static final String TAINT_ANALYSIS_KEY = "taint-analysis";
    @Deprecated
    private static final String CPPCHECK_PREMIUM_KEY = "cppcheck-premium";
    private static final String LICENSE_VERSION_KEY = "version";
    private static final String SIGNATURE_KEY = "signature";
    @JsonProperty(value="licensee")
    private String licensee;
    @JsonProperty(value="licenseVersion")
    private final int licenseVersion;
    @JsonProperty(value="validFrom")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    private final LocalDate validFrom;
    @JsonProperty(value="validTo")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    private LocalDate validTo;
    @JsonProperty(value="numUsers")
    private int numUsers;
    @JsonProperty(value="languages")
    @Deprecated
    private final LicensedFeatureCollection<ELanguage> languages;
    @JsonProperty(value="repositoryConnectors")
    @Deprecated
    private final LicensedFeatureCollection<ERepositoryConnector> repositoryConnectors;
    @JsonProperty(value="issueTrackers")
    @Deprecated
    private final LicensedFeatureCollection<EIssueTracker> issueTrackers;
    @JsonProperty(value="requirementsManagementTools")
    @Deprecated
    private final LicensedFeatureCollection<ERequirementsManagementTool> requirementsManagementTools;
    @JsonProperty(value="ldap")
    @Deprecated
    private final boolean ldap;
    @JsonProperty(value="audit")
    @Deprecated
    private final boolean audit;
    @JsonProperty(value="taintAnalysis")
    @Deprecated
    private final boolean taintAnalysis;
    @JsonProperty(value="cppcheckPremium")
    @Deprecated
    private final boolean cppcheckPremium;
    @JsonIgnore
    private byte[] signature;
    @JsonIgnore
    private final Properties rawSignedProperties;

    public License(String licensee, LocalDate validFrom, LocalDate validTo, int numUsers, LicensedFeatureCollection<ELanguage> languages, LicensedFeatureCollection<ERepositoryConnector> repositoryConnectors, LicensedFeatureCollection<EIssueTracker> issueTrackers, LicensedFeatureCollection<ERequirementsManagementTool> requirementsManagementTools, boolean ldap, boolean audit, boolean taintAnalysis, boolean cppcheckPremium, int licenseVersion, byte[] signature) {
        this(licensee, validFrom, validTo, numUsers, languages, repositoryConnectors, issueTrackers, requirementsManagementTools, ldap, audit, taintAnalysis, cppcheckPremium, licenseVersion, signature, null);
    }

    private License(String licensee, LocalDate validFrom, LocalDate validTo, int numUsers, LicensedFeatureCollection<ELanguage> languages, LicensedFeatureCollection<ERepositoryConnector> repositoryConnectors, LicensedFeatureCollection<EIssueTracker> issueTrackers, LicensedFeatureCollection<ERequirementsManagementTool> requirementsManagementTools, boolean ldap, boolean audit, boolean taintAnalysis, boolean cppcheckPremium, int licenseVersion, byte[] signature, Properties rawSignedProperties) {
        this.licensee = licensee;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.numUsers = numUsers;
        this.languages = languages;
        this.repositoryConnectors = repositoryConnectors;
        this.issueTrackers = issueTrackers;
        this.requirementsManagementTools = requirementsManagementTools;
        this.ldap = ldap;
        this.audit = audit;
        this.taintAnalysis = taintAnalysis;
        this.cppcheckPremium = cppcheckPremium;
        this.licenseVersion = licenseVersion;
        this.signature = signature;
        this.rawSignedProperties = rawSignedProperties;
    }

    private static String getStringProperty(Properties properties, String key) throws LicenseException {
        Object value = properties.get(key);
        if (value == null) {
            throw new LicenseException("Missing property: " + key);
        }
        if (!(value instanceof String)) {
            throw new LicenseException("Invalid property value for key " + key + ": " + String.valueOf(value));
        }
        return (String)value;
    }

    private static LocalDate getDateProperty(Properties properties, String key) throws LicenseException {
        String stringValue = License.getStringProperty(properties, key);
        try {
            return LocalDate.parse(stringValue);
        }
        catch (DateTimeParseException e) {
            throw new LicenseException("Invalid date property value for key " + key + ": " + stringValue, e);
        }
    }

    private static int getIntProperty(Properties properties, String key) throws LicenseException {
        String stringValue = License.getStringProperty(properties, key);
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new LicenseException("Invalid int property value for key " + key + ": " + stringValue, e);
        }
    }

    public static License read(Reader reader) throws IOException, LicenseException {
        return License.read(reader, new ArrayList<String>());
    }

    public static License read(Reader reader, List<String> errors) throws IOException, LicenseException {
        Properties properties = new Properties();
        properties.load(reader);
        String licensee = License.getStringProperty(properties, LICENSEE_KEY);
        LocalDate validFrom = License.getDateProperty(properties, VALID_FROM_KEY);
        LocalDate validTo = License.getDateProperty(properties, VALID_TO_KEY);
        int licenseVersion = License.getIntProperty(properties, LICENSE_VERSION_KEY);
        if (licenseVersion < 3) {
            licensee = new String(licensee.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            properties.put(LICENSEE_KEY, licensee);
        }
        int numUsers = License.getIntProperty(properties, NUM_USERS_KEY);
        LicensedFeatureCollection<ELanguage> languages = null;
        LicensedFeatureCollection<ERepositoryConnector> repositoryConnectors = null;
        LicensedFeatureCollection<EIssueTracker> issueTrackers = null;
        LicensedFeatureCollection<ERequirementsManagementTool> requirementsManagementTools = null;
        boolean ldap = false;
        boolean audit = false;
        boolean taintAnalysis = false;
        boolean cppcheckPremium = false;
        if (licenseVersion == 1 || licenseVersion == 3) {
            String languagesAsString = properties.get(LANGUAGES_KEY).toString();
            languages = new LicensedFeatureCollection<ELanguage>("Language", languagesAsString, ELanguage.class, errors);
            String repoConnectorsAsString = properties.get(REPOSITORY_CONNECTORS_KEY).toString();
            repositoryConnectors = new LicensedFeatureCollection<ERepositoryConnector>("Repository connector", repoConnectorsAsString, ERepositoryConnector.class, errors);
            String issueTrackersAsString = properties.get(ISSUE_TRACKERS_KEY).toString();
            issueTrackers = new LicensedFeatureCollection<EIssueTracker>("Issue tracker", issueTrackersAsString, EIssueTracker.class, errors);
            String requirementsManagementToolsAsString = License.getRequirementsManagementToolsAsString(properties);
            requirementsManagementTools = new LicensedFeatureCollection<ERequirementsManagementTool>("Requirements management tool", requirementsManagementToolsAsString, ERequirementsManagementTool.class, errors);
            ldap = Boolean.parseBoolean(properties.getProperty(LDAP_KEY));
            audit = Boolean.parseBoolean(properties.getProperty(AUDIT_KEY));
            taintAnalysis = Boolean.parseBoolean(properties.getProperty(TAINT_ANALYSIS_KEY));
            cppcheckPremium = Boolean.parseBoolean(properties.getProperty(CPPCHECK_PREMIUM_KEY));
        }
        byte[] signature = License.getSignatureFromProperties(properties);
        Properties rawSignedProperties = new Properties();
        rawSignedProperties.putAll((Map<?, ?>)properties);
        rawSignedProperties.remove(SIGNATURE_KEY);
        return new License(licensee, validFrom, validTo, numUsers, languages, repositoryConnectors, issueTrackers, requirementsManagementTools, ldap, audit, taintAnalysis, cppcheckPremium, licenseVersion, signature, rawSignedProperties);
    }

    private static String getRequirementsManagementToolsAsString(Properties properties) {
        Object property = properties.get(REQUIREMENTS_MANAGEMENT_TOOLS_KEY);
        if (property == null) {
            return "";
        }
        return property.toString().trim();
    }

    private static byte[] getSignatureFromProperties(Properties properties) throws LicenseException {
        String stringValue = License.getStringProperty(properties, SIGNATURE_KEY);
        try {
            return StringUtils.decodeFromHex((String)stringValue);
        }
        catch (NumberFormatException e) {
            throw new LicenseException("Invalid signature in properties: " + stringValue, e);
        }
    }

    public void write(Writer writer) throws IOException {
        Properties properties = this.getAsProperties(true);
        properties.store(writer, null);
    }

    public boolean isCppcheckPremium() {
        return this.cppcheckPremium;
    }

    private Properties getAsProperties(boolean includeSignature) {
        Properties properties = new Properties();
        properties.put(LICENSE_VERSION_KEY, String.valueOf(this.licenseVersion));
        properties.put(LICENSEE_KEY, this.licensee);
        properties.put(VALID_FROM_KEY, this.validFrom.toString());
        properties.put(VALID_TO_KEY, this.validTo.toString());
        properties.put(NUM_USERS_KEY, String.valueOf(this.numUsers));
        if (this.licenseVersion == 1 || this.licenseVersion == 3) {
            String requirementsManagementToolsFeaturesAsString;
            properties.put(LANGUAGES_KEY, this.languages.getFeaturesAsString());
            properties.put(REPOSITORY_CONNECTORS_KEY, this.repositoryConnectors.getFeaturesAsString());
            properties.put(ISSUE_TRACKERS_KEY, this.issueTrackers.getFeaturesAsString());
            properties.put(LDAP_KEY, String.valueOf(this.ldap));
            properties.put(CPPCHECK_PREMIUM_KEY, String.valueOf(this.cppcheckPremium));
            if (this.audit) {
                properties.put(AUDIT_KEY, String.valueOf(this.audit));
            }
            if (this.taintAnalysis) {
                properties.put(TAINT_ANALYSIS_KEY, String.valueOf(this.taintAnalysis));
            }
            if (!StringUtils.isEmpty((String)(requirementsManagementToolsFeaturesAsString = this.requirementsManagementTools.getFeaturesAsString()))) {
                properties.put(REQUIREMENTS_MANAGEMENT_TOOLS_KEY, requirementsManagementToolsFeaturesAsString);
            }
        }
        if (this.signature != null && includeSignature) {
            properties.put(SIGNATURE_KEY, this.getSignatureString());
        }
        return properties;
    }

    public String getSignatureString() {
        return StringUtils.encodeAsHex((byte[])this.signature);
    }

    public String getInfoString() {
        Properties properties = this.getAsProperties(false);
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            if (SIGNATURE_KEY.equals(key)) continue;
            result.append(key.toString()).append(" = ").append(entry.getValue().toString());
            result.append(StringUtils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public String getLicensee() {
        return this.licensee;
    }

    @JsonGetter(value="expiresSoon")
    public boolean getExpiresSoon() {
        LocalDate today = (LocalDate)DateTimeUtils.withClock(LocalDate::now);
        return today.isAfter(this.validTo.minus(EXPIRATION_PERIOD));
    }

    @JsonGetter(value="expired")
    public boolean getExpired() {
        return ((LocalDate)DateTimeUtils.withClock(LocalDate::now)).isAfter(this.validTo);
    }

    public long daysLeft() {
        LocalDate today = (LocalDate)DateTimeUtils.withClock(LocalDate::now);
        return ChronoUnit.DAYS.between(today, this.validTo);
    }

    public LocalDate getValidTo() {
        return this.validTo;
    }

    public int getNumUsers() {
        return this.numUsers;
    }

    public void setSignature(byte[] signature) {
        this.signature = (byte[])signature.clone();
    }

    public byte[] getContentForSigning() {
        Properties properties = this.getAsProperties(false);
        return License.serializePropertiesForSignature(properties);
    }

    private static byte[] serializePropertiesForSignature(Properties properties) {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            lines.add((CallSite)((Object)(String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()))));
        }
        Collections.sort(lines);
        String stringToSign = StringUtils.concat(lines, (String)";");
        stringToSign = new String(stringToSign.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        return StringUtils.stringToBytes((String)stringToSign);
    }

    public boolean verifySignature() throws LicenseException {
        return this.verifySignature(StringUtils.decodeFromHex((String)PUBLIC_KEY));
    }

    public boolean verifySignature(byte[] publicKey) throws LicenseException {
        CCSMAssert.isNotNull((Object)this.signature, (String)"No signature set for verification");
        CCSMAssert.isNotNull((Object)this.rawSignedProperties, (String)"Raw license properties needed for signature verification");
        try {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = LicenseUtil.createKeyFactory().generatePublic(pubKeySpec);
            Signature sig = LicenseUtil.createSignature();
            sig.initVerify(pubKey);
            sig.update(License.serializePropertiesForSignature(this.rawSignedProperties));
            return sig.verify(this.signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new LicenseException("Error verifying license signature: " + e.getMessage(), e);
        }
    }

    public void loadEnvironmentVariableOverwrites() {
        this.loadEnvironmentVariableOverwrites(System::getenv);
    }

    @VisibleForTesting
    void loadEnvironmentVariableOverwrites(Function<String, String> environmentProvider) {
        String licenseeOverride = environmentProvider.apply(LICENSEE_OVERWRITE_ENV_VAR_NAME);
        if (licenseeOverride != null) {
            this.licensee = licenseeOverride;
        }
        this.numUsers = Math.min(this.numUsers, License.loadEnvIntOrDefault(environmentProvider, USER_COUNT_OVERWRITE_ENV_VAR_NAME, Integer.MAX_VALUE));
        String validToOverrideString = environmentProvider.apply(VALIDITY_OVERWRITE_ENV_VAR_NAME);
        if (validToOverrideString != null) {
            try {
                LocalDate validToOverride = LocalDate.parse(validToOverrideString);
                if (validToOverride.isBefore(this.validTo)) {
                    this.validTo = validToOverride;
                }
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
    }

    private static int loadEnvIntOrDefault(Function<String, String> environmentProvider, String variableName, int defaultValue) {
        String value = environmentProvider.apply(variableName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

