/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.interaction;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.interaction.InteractionLogMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ShortInteractionLog
extends ShortLogEntryBase {
    private static final String SCHEDULING_COMMIT_PROPERTY_NAME = "schedulingCommit";
    private static final String TRIGGER_NAME_PROPERTY_NAME = "triggerName";
    private static final String TARGET_URL_PROPERTY_NAME = "targetUrl";
    private static final String TARGET_ID_PROPERTY_NAME = "targetId";
    private static final String MESSAGE_PROPERTY_NAME = "message";
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="schedulingCommit")
    private final @Nullable CommitDescriptor schedulingCommit;
    @JsonProperty(value="triggerName")
    private final @Nullable String triggerName;
    @JsonProperty(value="targetUrl")
    private final @Nullable String targetUrl;
    @JsonProperty(value="targetId")
    private final @Nullable String targetId;
    private static final long serialVersionUID = 1L;

    public ShortInteractionLog(LogEntryIdentifier identifier, @Nullable String triggerName, InternalProjectId projectId, @Nullable CommitDescriptor schedulingCommit, Message message) {
        super(identifier, LogCount.ofZero(), (IProjectId)projectId);
        this.triggerName = triggerName;
        this.schedulingCommit = schedulingCommit;
        if (message instanceof InteractionLogMessage) {
            InteractionLogMessage interactionLogMessage = (InteractionLogMessage)message;
            this.message = ShortInteractionLog.formatTimestampsAsDates(interactionLogMessage.getMessage());
            this.targetUrl = interactionLogMessage.getTargetUrl();
            this.targetId = interactionLogMessage.getTargetId();
        } else {
            this.message = ShortInteractionLog.formatTimestampsAsDates(message.getFormattedMessage());
            this.targetUrl = null;
            this.targetId = null;
        }
    }

    public static List<ShortInteractionLog> convert(String triggerName, CommitDescriptor schedulingCommit, InternalProjectId projectId, List<LogEvent> interactionLogEvents) {
        ArrayList<ShortInteractionLog> shortInteractionLogs = new ArrayList<ShortInteractionLog>();
        for (LogEvent logEvent : interactionLogEvents) {
            shortInteractionLogs.add(new ShortInteractionLog(LogEntryIdentifier.freshWithTimestamp(logEvent.getTimeMillis()), triggerName, projectId, schedulingCommit, logEvent.getMessage()));
        }
        return shortInteractionLogs;
    }

    public String toString() {
        return StringUtils.concat(Arrays.asList(this.triggerName, this.getProjectId(), this.schedulingCommit, this.message, this.targetUrl, this.targetId));
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.triggerName, Optional.ofNullable(this.schedulingCommit).map(CommitDescriptor::toString).orElse(""), this.message, this.targetUrl, this.targetId));
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        super.appendFields(builder);
        builder.append(this.triggerName).append(" ").append(this.schedulingCommit).append(" ").append(this.message).append(" ").append(this.targetUrl).append(" ").append(this.targetId).append(" ");
    }

    public String getMessage() {
        return this.message;
    }
}

