/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.parse;

import com.teamscale.core.log.parse.ParseLogEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="parse-log", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.COMMIT_ISOLATED}, valueClasses={ParseLogEntry.class})
public class ParseLogIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "parse-log";
    private static final String KEY_SEPARATOR = ";#;";
    private static final String SIZE_KEY = "size";
    private static final byte[] SIZE_KEY_BYTES = StringUtils.stringToBytes((String)"size");
    private static final String INSERT_LOCK = "insert";

    public ParseLogIndex(IStore store) {
        super(store);
    }

    public int getNumberOfEntries() throws StorageException {
        byte[] value = this.store.getWithString(SIZE_KEY);
        if (value == null) {
            return 0;
        }
        return ByteArrayUtils.byteArrayToInt((byte[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistLogEntries(List<ParseLogEntry> entries) throws StorageException {
        if (entries.isEmpty()) {
            return;
        }
        PairList keysValues = new PairList();
        for (ParseLogEntry entry : entries) {
            keysValues.add((Object)ParseLogIndex.makeKey(entry), (Object)StorageUtils.serialize((Serializable)entry));
        }
        Lock lock = this.store.obtainLock(INSERT_LOCK);
        lock.lock();
        try {
            int existing = Math.toIntExact(this.store.getWithStrings(keysValues.extractFirstList()).stream().filter(Objects::nonNull).count());
            int numberOfEntries = this.getNumberOfEntries() + keysValues.size() - existing;
            keysValues.add((Object)SIZE_KEY, (Object)ByteArrayUtils.intToByteArray((int)numberOfEntries));
            this.store.putWithStrings(keysValues);
        }
        finally {
            lock.unlock();
        }
    }

    private static String makeKey(ParseLogEntry entry) {
        return entry.getUniformPath() + KEY_SEPARATOR + entry.getCommit().toServiceCallFormat() + KEY_SEPARATOR + entry.getLineNumber();
    }

    public List<ParseLogEntry> getParseLogEntries(String uniformPath, CommitDescriptor commit) throws StorageException {
        return this.getAllWithKeyPrefix(uniformPath + KEY_SEPARATOR + commit.toServiceCallFormat() + KEY_SEPARATOR);
    }

    public List<ParseLogEntry> getAllParseLogEntries() throws StorageException {
        return this.getAllWithKeyPrefix("");
    }

    private List<ParseLogEntry> getAllWithKeyPrefix(String prefix) throws StorageException {
        final ArrayList<ParseLogEntry> result = new ArrayList<ParseLogEntry>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (!Arrays.equals(SIZE_KEY_BYTES, key)) {
                    result.add((ParseLogEntry)StorageUtils.deserialize((byte[])value));
                }
            }
        };
        this.store.scan(prefix, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return result;
    }
}

