/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics;

import java.io.Serializable;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.math.Range;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class AssessedRange
extends Range
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final ETrafficLightColor color;

    public AssessedRange(double lower, double upper, ETrafficLightColor color) {
        super(lower, false, upper, true);
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Invalid/empty range (lower >= upper): " + lower + " and " + upper);
        }
        this.color = color;
    }

    public static Assessment determineAssessment(double value, List<AssessedRange> ranges, ETrafficLightColor defaultColor) {
        for (AssessedRange r : ranges) {
            if (!r.contains(value)) continue;
            return new Assessment(r.color);
        }
        return new Assessment(defaultColor);
    }

    public static void checkRanges(List<AssessedRange> ranges) throws ConQATException {
        for (AssessedRange r1 : ranges) {
            for (AssessedRange r2 : ranges) {
                if (r1 == r2 || !r1.contains(r2.getUpper())) continue;
                throw new ConQATException("May not use overlapping ranges: " + String.valueOf(r1) + " and " + String.valueOf(r2));
            }
        }
    }
}

