/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.teamscale.core.metrics.directory.MetricArrayDeserializer;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class MetricDirectoryEntry
implements Serializable,
Comparable<MetricDirectoryEntry> {
    private static final long serialVersionUID = 1L;
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String METRIC_VALUES_PROPERTY = "metricValues";
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="metricValues")
    @JsonDeserialize(using=MetricArrayDeserializer.class)
    @Schema(implementation=MetricValues.class)
    private @Nullable Object[] metricValues;
    @JsonProperty(value="childMetrics")
    @JsonDeserialize(contentUsing=MetricArrayDeserializer.class)
    @Schema(implementation=ChildMetrics.class)
    private Map<String, Object[]> childMetrics = new HashMap<String, Object[]>();

    public MetricDirectoryEntry(String uniformPath, int size) {
        this.uniformPath = uniformPath;
        this.metricValues = new Object[size];
    }

    public MetricDirectoryEntry(String uniformPath, MetricDirectorySchema schema) {
        this(uniformPath, schema.getAllEntries().size());
    }

    @JsonCreator
    public MetricDirectoryEntry(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="metricValues") Object[] metricValues) {
        this.uniformPath = uniformPath;
        this.metricValues = metricValues;
    }

    public UnmodifiableMap<String, Object[]> getChildMetricsMap() {
        return CollectionUtils.asUnmodifiable(this.childMetrics);
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public void removeChild(String uniformPath) {
        this.childMetrics.remove(uniformPath);
    }

    public void insertOrUpdateChild(MetricDirectoryEntry entry) {
        this.setChildMetrics(entry.getUniformPath(), (Object[])entry.metricValues.clone());
    }

    public void setChildMetrics(String uniformPath, Object[] values) {
        this.childMetrics.put(uniformPath, values);
    }

    public void setChildMetrics(Map<String, Object[]> childMetrics) {
        this.childMetrics = childMetrics;
    }

    public void setValue(int offset, Object newValue) {
        this.metricValues[offset] = newValue;
    }

    public boolean hasChildren() {
        return !this.childMetrics.isEmpty();
    }

    public void appendChildValues(int offset, Collection<Object> target) {
        for (Object[] values : this.childMetrics.values()) {
            if (values[offset] == null) continue;
            target.add(values[offset]);
        }
    }

    public @NonNull Object getValue(int offset) {
        Object value = this.getValueWithoutNullAssert(offset);
        CCSMAssert.isNotNull((Object)value, (String)("Encountered null value for metric index " + offset + " at " + this.uniformPath));
        return value;
    }

    public <T> T getValue(MetricDirectorySchema schema, String name, Class<T> valueType) {
        int valuePosition = schema.getValuePosition(name);
        if (valuePosition < 0) {
            throw new IllegalArgumentException("Schema does not include metric for \"%s\"".formatted(name));
        }
        Object value = this.getValue(valuePosition);
        return MetricDirectoryEntry.castValueType(valueType, value);
    }

    public <T> @Nullable T getValueWithoutNullAssert(MetricDirectorySchema schema, String name, Class<T> valueType) {
        int valuePosition = schema.getValuePosition(name);
        if (valuePosition < 0) {
            return null;
        }
        Object value = this.getValueWithoutNullAssert(valuePosition);
        if (value == null) {
            return null;
        }
        return MetricDirectoryEntry.castValueType(valueType, value);
    }

    private static <T> @NonNull T castValueType(Class<T> valueType, Object value) {
        CCSMAssert.isTrue((boolean)valueType.isInstance(value), () -> "Metric value (%s: %s) is not of expected type %s".formatted(value.getClass(), value, valueType));
        return valueType.cast(value);
    }

    public <T> @Nullable T getValueWithoutNullAssert(int offset, Class<T> valueType) {
        Object value = this.metricValues[offset];
        if (value == null) {
            return null;
        }
        return MetricDirectoryEntry.castValueType(valueType, this.metricValues[offset]);
    }

    public @Nullable Object getValueWithoutNullAssert(int offset) {
        return this.metricValues[offset];
    }

    @Contract(value="_,!null -> !null")
    public @Nullable Object getValueOrDefault(int offset, @Nullable Object defaultValue) {
        Object metricValue = this.metricValues[offset];
        if (metricValue != null) {
            return metricValue;
        }
        return defaultValue;
    }

    public Object[] getValues() {
        return this.metricValues;
    }

    public String toString() {
        return this.getUniformPath() + " (" + Arrays.toString(this.metricValues) + ")";
    }

    @Override
    public int compareTo(MetricDirectoryEntry other) {
        return this.uniformPath.compareTo(other.uniformPath);
    }

    public double getDoubleValue(int offset) {
        Object value = this.getValue(offset);
        CCSMAssert.isInstanceOf((Object)value, Number.class);
        return ((Number)value).doubleValue();
    }

    public @Nullable Double getDoubleValueWithoutNullAssert(int offset) {
        Object value = this.getValueWithoutNullAssert(offset);
        if (value == null) {
            return null;
        }
        CCSMAssert.isInstanceOf((Object)value, Number.class);
        return ((Number)value).doubleValue();
    }

    public boolean isIncomplete() {
        for (Object value : this.metricValues) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryForArchitectureFile() {
        return UniformPathUtils.isArchitectureFile((String)this.uniformPath);
    }

    public void setValues(Object[] newValues) {
        this.metricValues = newValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDirectoryEntry that = (MetricDirectoryEntry)o;
        return Objects.equals(this.uniformPath, that.uniformPath) && Arrays.equals(this.metricValues, that.metricValues) && Objects.equals(this.childMetrics, that.childMetrics);
    }

    public int hashCode() {
        int result = Objects.hash(this.uniformPath, this.childMetrics);
        result = 31 * result + Arrays.hashCode(this.metricValues);
        return result;
    }

    private static interface ChildMetrics
    extends Map<String, MetricValues> {
    }

    @ArraySchema(schema=@Schema(implementation=MetricValue.class))
    public static interface MetricValues
    extends List<MetricValue> {
    }

    @Schema(oneOf={Number.class, Assessment.class, String.class, CounterSet.class})
    public static interface MetricValue {
    }
}

