/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.Nullable;

public class MetricValueDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser p, DeserializationContext context) throws IOException {
        JsonNode elementNode = (JsonNode)p.readValueAsTree();
        return MetricValueDeserializer.getMetricValueFromJson(p, elementNode);
    }

    static @Nullable Object getMetricValueFromJson(JsonParser p, JsonNode elementNode) throws JsonProcessingException {
        JsonNode jsonNode = elementNode;
        Objects.requireNonNull(jsonNode);
        JsonNode jsonNode2 = jsonNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LongNode.class, IntNode.class, NumericNode.class, TextNode.class, ObjectNode.class, NullNode.class}, (JsonNode)jsonNode2, n)) {
            case 0 -> {
                LongNode longNode = (LongNode)jsonNode2;
                yield longNode.longValue();
            }
            case 1 -> {
                IntNode intNode = (IntNode)jsonNode2;
                yield intNode.intValue();
            }
            case 2 -> {
                NumericNode numericNode = (NumericNode)jsonNode2;
                yield numericNode.doubleValue();
            }
            case 3 -> {
                TextNode textNode = (TextNode)jsonNode2;
                yield textNode.textValue();
            }
            case 4 -> {
                ObjectNode objectNode = (ObjectNode)jsonNode2;
                if (objectNode.has("map") && objectNode.has("total")) {
                    yield (CounterSet)p.getCodec().treeToValue((TreeNode)elementNode, CounterSet.class);
                }
                if (objectNode.has("mapping")) {
                    yield (Assessment)p.getCodec().treeToValue((TreeNode)elementNode, Assessment.class);
                }
                CCSMAssert.fail((String)("Unknown metric type: " + String.valueOf(elementNode)));
                yield null;
            }
            case 5 -> {
                NullNode ignored = (NullNode)jsonNode2;
                yield null;
            }
            default -> CCSMAssert.fail((String)("Unknown metric type: " + String.valueOf(elementNode)));
        };
    }
}

