/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.teamscale.core.index.ICommitDescriptorSerializer;
import com.teamscale.core.utils.XXHashUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class TrendIndexBase<T>
extends IndexBase
implements IRollbackableIndex {
    private static final byte[] TOMB_STONE_MARKER = new byte[]{-1};
    private static final byte[] TIMESTAMP_SEPARATOR = new byte[]{-2};
    private static final byte[] REVERSE_LOOKUP_KEY_PREFIX = new byte[]{-3};
    private static final ICommitDescriptorSerializer COMMIT_SERIALIZER = ICommitDescriptorSerializer.BranchTimestamp.COMPACT;

    protected TrendIndexBase(IStore store) {
        super(store);
    }

    public void setValues(PairList<String, T> updatedKeysAndValues, CommitDescriptor commit) throws StorageException {
        PairList values = new PairList();
        byte[] suffix = TrendIndexBase.createKeySuffix(commit);
        for (int i = 0; i < updatedKeysAndValues.size(); ++i) {
            String uniformPath = (String)updatedKeysAndValues.getFirst(i);
            byte[] key = TrendIndexBase.createKey(suffix, uniformPath);
            values.add((Object)key, (Object)this.valueToBytes(updatedKeysAndValues.getSecond(i)));
        }
        byte[] uniformPathsValue = StorageUtils.serialize(new ArrayList(CollectionUtils.sort((Collection)updatedKeysAndValues.extractFirstList())));
        values.add((Object)TrendIndexBase.createReverseLookupKey(commit, uniformPathsValue), (Object)uniformPathsValue);
        this.store.put(values);
    }

    private static byte[] createReverseLookupKey(CommitDescriptor commit, byte[] uniformPathsValue) {
        if (uniformPathsValue == null) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{REVERSE_LOOKUP_KEY_PREFIX, COMMIT_SERIALIZER.serialize(commit)});
        }
        return ByteArrayUtils.concat((byte[][])new byte[][]{REVERSE_LOOKUP_KEY_PREFIX, COMMIT_SERIALIZER.serialize(commit), ByteArrayUtils.longToByteArray((long)XXHashUtils.xxhash64(uniformPathsValue))});
    }

    private static CommitDescriptor reverseLookupKeyToCommit(byte[] key) {
        return COMMIT_SERIALIZER.deserialize(Arrays.copyOfRange(key, 1, key.length - 8));
    }

    private static byte[] createKey(byte[] suffix, String uniformPath) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)uniformPath), suffix});
    }

    protected abstract byte[] valueToBytes(T var1) throws StorageException;

    protected abstract T bytesToValue(byte[] var1) throws StorageException;

    public void removeValues(List<String> deletedKeys, CommitDescriptor commit) throws StorageException {
        PairList values = new PairList();
        byte[] suffix = TrendIndexBase.createKeySuffix(commit);
        for (String key : deletedKeys) {
            values.add((Object)ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)key), suffix}), (Object)TOMB_STONE_MARKER);
        }
        this.store.put(values);
    }

    private static byte[] createKeySuffix(CommitDescriptor commit) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{TIMESTAMP_SEPARATOR, COMMIT_SERIALIZER.serialize(commit)});
    }

    public List<TrendEntry<T>> extractTrend(String uniformPath, List<CommitDescriptor> relevantCommits) throws StorageException {
        ArrayList sortedRelevantCommits = CollectionUtils.sort(relevantCommits);
        List keys = CollectionUtils.map((Collection)sortedRelevantCommits, commit -> TrendIndexBase.createKey(TrendIndexBase.createKeySuffix(commit), uniformPath));
        List values = this.store.get(keys);
        ArrayList<TrendEntry<T>> result = new ArrayList<TrendEntry<T>>();
        for (int i = values.size() - 1; i >= 0; --i) {
            byte[] value = (byte[])values.get(i);
            if (value == null) continue;
            if (Arrays.equals(value, TOMB_STONE_MARKER)) {
                return result;
            }
            result.add(new TrendEntry<T>(((CommitDescriptor)sortedRelevantCommits.get(i)).getTimestamp(), this.bytesToValue(value)));
        }
        return result;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
            ArrayList<byte[]> keysToDelete = new ArrayList<byte[]>();
            this.collectKeysToDelete(keysToDelete, entry);
            this.store.remove(keysToDelete);
        }
    }

    private void collectKeysToDelete(final List<byte[]> keysToDelete, Map.Entry<String, Long> entry) throws StorageException {
        final String branchName = entry.getKey();
        CommitDescriptor startCommit = new CommitDescriptor(branchName, entry.getValue() + 1L);
        CommitDescriptor endCommit = new CommitDescriptor(branchName, Long.MAX_VALUE);
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                CommitDescriptor commit = TrendIndexBase.reverseLookupKeyToCommit(key);
                if (!commit.getBranchName().equals(branchName)) {
                    return;
                }
                byte[] keySuffix = TrendIndexBase.createKeySuffix(commit);
                for (String uniformPath : StorageUtils.deserializeStringList((byte[])value)) {
                    keysToDelete.add(TrendIndexBase.createKey(keySuffix, uniformPath));
                }
            }
        };
        this.store.scan(TrendIndexBase.createReverseLookupKey(startCommit, null), TrendIndexBase.createReverseLookupKey(endCommit, null), (IKeyValueCallback)callback);
        callback.throwCaughtException();
    }

    public record TrendEntry<T>(long timestamp, T value) implements Comparable<TrendEntry<T>>
    {
        @Override
        public int compareTo(TrendEntry<T> other) {
            return Long.compare(this.timestamp, other.timestamp);
        }
    }
}

