/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.teamscale.core.migration.IJsonFileVersion;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.MigrationException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TeamscaleVersionContainer {
    private static final String VERSION_FIELD = "_version";
    private static final String TYPE_FIELD = "_type";
    private static final Pattern JSON_VERSION_PARSE_PATTERN = Pattern.compile("\"_version\" *: *\"(.*?)\"");
    private static final Pattern JSON_TYPE_PARSE_PATTERN = Pattern.compile("\"_type\" *: *\"(.*?)\"");

    public static <T, VERSION extends Enum<VERSION>> String toJson(T payload, VERSION version) throws JsonSerializationException {
        String metaData = JsonUtils.serializeToJSONCanonical((Object)new ContainerMetaData(version.name(), payload.getClass().getSimpleName()));
        String metaDataWithoutRbraceAndLineBreak = metaData.substring(0, metaData.length() - 2);
        if (metaDataWithoutRbraceAndLineBreak.endsWith("\r")) {
            metaDataWithoutRbraceAndLineBreak = metaDataWithoutRbraceAndLineBreak.substring(0, metaDataWithoutRbraceAndLineBreak.length() - 1);
        }
        return metaDataWithoutRbraceAndLineBreak + "," + JsonUtils.serializeToJSONCanonical(payload).substring(1);
    }

    public static <VERSION extends Enum<VERSION>> Optional<VERSION> extractVersion(String json, Class<VERSION> versionEnum) {
        Matcher matcher = JSON_VERSION_PARSE_PATTERN.matcher(json);
        if (!matcher.find()) {
            return Optional.empty();
        }
        return Optional.ofNullable(EnumUtils.valueOf(versionEnum, (String)matcher.group(1)));
    }

    public static Optional<String> extractType(String json) {
        Matcher matcher = JSON_TYPE_PARSE_PATTERN.matcher(json);
        if (!matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(1));
    }

    public static String createInvalidVersionErrorMessage(String payloadReadableName) {
        return "No version or unknown (too new or too old) version in " + payloadReadableName + " file. If this artifact was created with a Teamscale version before 8.1, please migrate first to version 8.1 and then to the current version.";
    }

    public static <T, C, VERSION extends Enum<VERSION>> T fromJson(byte[] jsonData, C context, Class<T> expectedPayloadType, VERSION requiredVersion, String payloadReadableName) throws MigrationException {
        return TeamscaleVersionContainer.fromJson(StringUtils.bytesToString((byte[])jsonData), context, expectedPayloadType, requiredVersion, payloadReadableName);
    }

    public static <T, C, VERSION extends Enum<VERSION>> T fromJson(String json, C context, Class<T> expectedPayloadType, VERSION requiredVersion, String payloadReadableName) throws MigrationException {
        VERSION currentVersion = TeamscaleVersionContainer.extractVersion(json, TeamscaleVersionContainer.determineVersionEnum(requiredVersion)).orElseThrow(() -> new MigrationException(TeamscaleVersionContainer.createInvalidVersionErrorMessage(payloadReadableName) + json));
        String migrated = TeamscaleVersionContainer.migrate(json, context, currentVersion, requiredVersion, payloadReadableName);
        if (migrated == null) {
            return null;
        }
        Optional<String> type = TeamscaleVersionContainer.extractType(migrated);
        if (type.isPresent() && !type.get().equals(expectedPayloadType.getSimpleName())) {
            throw new MigrationException("Type mismatch: JSON contained " + type.get() + " while we expect " + expectedPayloadType.getSimpleName());
        }
        try {
            return (T)JsonUtils.deserializeFromJson((String)TeamscaleVersionContainer.stripMetaDataFields(migrated), expectedPayloadType);
        }
        catch (ConQATException e) {
            throw new MigrationException(e);
        }
    }

    private static String stripMetaDataFields(String json) {
        return json.replaceAll("\"(_type|_version)\" *: *\".*?\" *,", "");
    }

    private static <VERSION> Class<VERSION> determineVersionEnum(VERSION requiredVersion) {
        Class<?> enumClass = requiredVersion.getClass();
        if (!enumClass.isEnum() && enumClass.isAnonymousClass()) {
            enumClass = enumClass.getEnclosingClass();
        }
        return enumClass;
    }

    private static <C, VERSION extends Enum<VERSION>> String migrate(String json, C context, VERSION currentVersion, VERSION requiredVersion, String payloadReadableName) throws MigrationException {
        if (currentVersion.ordinal() > requiredVersion.ordinal()) {
            throw new MigrationException("Version of " + payloadReadableName + " is too new. Expected version " + String.valueOf(requiredVersion) + " instead of " + String.valueOf(currentVersion) + "!");
        }
        VERSION[] validVersions = TeamscaleVersionContainer.determineVersionEnum(currentVersion).getEnumConstants();
        while (currentVersion.ordinal() < requiredVersion.ordinal()) {
            currentVersion = validVersions[currentVersion.ordinal() + 1];
            IJsonMigrator migrator = ((IJsonFileVersion)((Object)currentVersion)).getMigrator(json, context);
            json = migrator.migrate(json);
        }
        return json;
    }

    public static <VERSION extends Enum<VERSION>> Optional<VERSION> extractVersion(byte[] jsonData, VERSION requiredVersion) {
        return TeamscaleVersionContainer.extractVersion(StringUtils.bytesToString((byte[])jsonData), TeamscaleVersionContainer.determineVersionEnum(requiredVersion));
    }

    @JsonPropertyOrder(value={"_version", "_type"})
    private static class ContainerMetaData {
        @JsonProperty(value="_version")
        private final String version;
        @JsonProperty(value="_type")
        private final String type;

        public ContainerMetaData(String version, String type) {
            this.version = version;
            this.type = type;
        }
    }
}

