/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion132CleanEmptyTaskTags
extends SerializedValueMigratorBase {
    public MigrateVersion132CleanEmptyTaskTags() {
        super(true);
    }

    @Override
    public void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass serializedClass = entityPool.findClass("org.conqat.engine.service.shared.data.Task");
        if (serializedClass == null) {
            return;
        }
        for (SerializedObject serializedObject : SerializedEntityUtils.findInstancesOf((SerializedClass)serializedClass, (SerializedEntityPool)entityPool)) {
            SerializedObject tagListObject;
            Object tagsField = serializedObject.getFieldValue("tags");
            if (tagsField == null || (tagListObject = (SerializedObject)entityPool.getEntity(((Integer)tagsField).intValue(), SerializedObject.class)) == null) continue;
            SerializedClass listClass = SerializationMigrationUtils.findClassInHierarchy((SerializedObject)tagListObject, ArrayList.class);
            SerializedClassValues fieldSets = tagListObject.getFieldSet(tagListObject.getPlainClassHierarchy().indexOf(listClass));
            int numberOfTags = (Integer)fieldSets.getValue(0);
            if (numberOfTags == 0) continue;
            List postFieldData = fieldSets.getPostFieldData();
            HashSet tagToDelete = new HashSet();
            for (Object data : postFieldData) {
                SerializedStringObject containedElement;
                if (!(data instanceof Integer) || (containedElement = (SerializedStringObject)entityPool.getEntity(((Integer)data).intValue(), SerializedStringObject.class)) != null && !StringUtils.isBlank((CharSequence)containedElement.getValue())) continue;
                tagToDelete.add(data);
            }
            postFieldData.removeAll(tagToDelete);
            fieldSets.setValue(0, (Object)(postFieldData.size() - 1));
        }
    }

    @Override
    public String getStoreName() {
        return "tasks";
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V132;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.PROJECT;
    }
}

