/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion136AddFontSizeParameterMarkdownSlide
extends ReportSlideMigratorBase {
    private static final String MARKDOWN_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.MarkdownSlide";
    private static final String MARKDOWN_PARAMETER_CLASS = "com.teamscale.index.quality_report.slides.MarkdownSlide$MarkdownSlideParameters";
    private static final String FONTSIZE = "fontSize";

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        this.addFontSizeForSlideType(entityPool, MARKDOWN_SLIDE_CLASS, MARKDOWN_PARAMETER_CLASS);
    }

    private void addFontSizeForSlideType(SerializedEntityPool entityPool, String slideClass, String slideParameterClass) throws IOException {
        SerializedClass serializedClass = entityPool.findClass(slideParameterClass);
        if (serializedClass != null && !serializedClass.containsField(FONTSIZE)) {
            serializedClass.addField((SerializedFieldBase)new SerializedIntField(FONTSIZE));
        }
        for (SerializedObject slide : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(slideClass), (SerializedEntityPool)entityPool)) {
            SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)slide.getFieldValue("slideParameters")).intValue(), SerializedObject.class);
            slideParameters.setFieldValue(FONTSIZE, (Object)26);
        }
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V136;
    }
}

