/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IDynamicallyNamedStoreMigrator;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public class MigrateVersion159RemoveStartTimestampsPerBranch
implements IDynamicallyNamedStoreMigrator {
    private static final byte @NonNull [] OBSOLETE_KEY = StringUtils.stringToBytes((String)"start-timestamps-per-branch");

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V159;
    }

    @Override
    public void migrate(IStore input, IStore output, IFactory<IStore, StorageException> tempStoreFactory) throws StorageException {
        MigrateVersion159RemoveStartTimestampsPerBranch.copyAllContents(input, output);
        output.remove(OBSOLETE_KEY);
    }

    private static void copyAllContents(IStore input, IStore output) throws StorageException {
        try {
            input.scan(new byte[0], (key, value) -> {
                if (value == null) {
                    throw new IllegalStateException("Found unexpected null value for key '%s'.".formatted(StringUtils.bytesToString((byte[])key)));
                }
                try {
                    output.put(key, value);
                }
                catch (StorageException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IllegalStateException e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Override
    public Pattern getNamePattern() {
        return Pattern.compile(".+-git-repository-infos");
    }
}

