/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion170SlidesMetricAssessment
extends SerializedValueMigratorBase {
    protected MigrateVersion170SlidesMetricAssessment() {
        super(true);
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V170;
    }

    @Override
    public String getStoreName() {
        return "slide-render-data";
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass metricAssessmentClass = entityPool.findClass("com.teamscale.index.metrics.assessment.MetricAssessment");
        if (metricAssessmentClass == null) {
            return;
        }
        int schemaEntryClassHandle = entityPool.getOrCreateClass("com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry", new SerializedFieldBase[]{new SerializedObjectField("name", SerializedObjectField.STRING_TYPE), new SerializedObjectField("description", SerializedObjectField.STRING_TYPE), new SerializedObjectField("aggregation", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry.EAggregation")), new SerializedObjectField("properties", SerializedObjectField.createJvmNotationFromPlainClassName((String)"java.util.EnumSet")), new SerializedObjectField("valueType", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.core.metrics.values.EMetricValueType")), new SerializedObjectField("dynamicMetricComputation", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.core.analysis.configuration.IDynamicMetricComputation"))}).getHandle();
        metricAssessmentClass.addField((SerializedFieldBase)new SerializedObjectField("schemaEntry", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry")));
        List metricAssessments = SerializedEntityUtils.findInstancesOf((SerializedClass)metricAssessmentClass, (SerializedEntityPool)entityPool);
        for (SerializedObject metricAssessment : metricAssessments) {
            Object name = metricAssessment.getFieldValue("name");
            Object description = metricAssessment.getFieldValue("description");
            Object aggregation = metricAssessment.getFieldValue("aggregation");
            Object properties = metricAssessment.getFieldValue("properties");
            Object valueType = metricAssessment.getFieldValue("valueType");
            List<SerializedClassValues> classValuesList = Collections.singletonList(new SerializedClassValues(1));
            SerializedObject schemaEntry = new SerializedObject(schemaEntryClassHandle, classValuesList, entityPool);
            schemaEntry.setFieldValue("name", name);
            schemaEntry.setFieldValue("description", description);
            schemaEntry.setFieldValue("aggregation", aggregation);
            schemaEntry.setFieldValue("properties", properties);
            schemaEntry.setFieldValue("valueType", valueType);
            schemaEntry.setFieldValue("dynamicMetricComputation", (Object)0);
            metricAssessment.setFieldValue("schemaEntry", (Object)schemaEntry.getHandle());
        }
        SerializedClassFieldMigrator fieldMigrator = new SerializedClassFieldMigrator(entityPool);
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "name");
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "description");
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "aggregation");
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "properties");
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "valueType");
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "stringValue");
        fieldMigrator.removeField("com.teamscale.index.metrics.assessment.MetricAssessment", "formattedTextValue");
    }
}

