/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

public final class MigrateVersion191CommitDescriptorHierarchy {
    private static final EStorageSystemVersion VERSION = EStorageSystemVersion.STORAGE_SYSTEM_V191;

    private static void doMigrate(SerializedEntityPool entityPool) throws IOException {
        SerializedClass classEntity = entityPool.findClass("org.conqat.engine.index.shared.ParentedCommitDescriptor");
        if (classEntity == null) {
            return;
        }
        List entities = entityPool.getEntities(classEntity);
        for (SerializedObject entity : entities) {
            entity.removeFieldSet(entity.getFieldSetCount() - 1);
            entity.setClassHandle(classEntity.getSuperClassHandle());
        }
    }

    @ThreadSafe
    public static class MigrateVotingRecordIndex
    extends UnbranchedStoreMigration {
        public MigrateVotingRecordIndex() {
            super("voting-records", EStorageMigratorType.PROJECT, true);
        }
    }

    @ThreadSafe
    public static class MigrateElementReviewUploadIndex
    extends BranchedStoreMigration {
        public MigrateElementReviewUploadIndex() {
            super("element-review-uploads", true);
        }
    }

    @ThreadSafe
    public static class MigrateGitHubCheckRunIndex
    extends UnbranchedStoreMigration {
        public MigrateGitHubCheckRunIndex() {
            super("github-check-runs", EStorageMigratorType.PROJECT, true);
        }
    }

    @ThreadSafe
    public static class MigrateFindingBlacklistStagingIndex
    extends BranchedStoreMigration {
        public MigrateFindingBlacklistStagingIndex() {
            super("finding-blacklist-staging", true);
        }
    }

    @ThreadSafe
    public static class MigrateExternalAnalysisImportSessionIndex
    extends UnbranchedStoreMigration {
        private static final byte[] COMMIT_PREFIX = StringUtils.stringToBytes((String)"c$%$");
        private static final byte[] UNSCHEDULED_SESSIONS_PREFIX = StringUtils.stringToBytes((String)"u$%$");
        private static final byte[] VALUE_INDEX_PREFIX = StringUtils.stringToBytes((String)"v");
        private static final byte[] SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX = StringUtils.stringToBytes((String)"$%$s$%$");

        public MigrateExternalAnalysisImportSessionIndex() {
            super("external-analysis-session", EStorageMigratorType.PROJECT, true);
        }

        @Override
        protected boolean isHiddenKey(byte[] key) {
            return super.isHiddenKey(key) || MigrateExternalAnalysisImportSessionIndex.isCommitDelegate(key) || MigrateExternalAnalysisImportSessionIndex.isUnscheduledSessionDelegate(key) || MigrateExternalAnalysisImportSessionIndex.isSizeEntryInScatteredCollectionValueIndex(key);
        }

        private static boolean isCommitDelegate(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])COMMIT_PREFIX, (byte[])key);
        }

        private static boolean isUnscheduledSessionDelegate(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])UNSCHEDULED_SESSIONS_PREFIX, (byte[])key);
        }

        private static boolean isSizeEntryInScatteredCollectionValueIndex(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])VALUE_INDEX_PREFIX, (byte[])key) && ByteArrayUtils.contains((byte[])SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX, (byte[])key);
        }
    }

    @ThreadSafe
    public static class MigrateTaskIndex
    extends UnbranchedStoreMigration {
        public MigrateTaskIndex() {
            super("tasks", EStorageMigratorType.PROJECT, true);
        }
    }

    @ThreadSafe
    public static class MigrateDotNetVersionIndex
    extends UnbranchedStoreMigration {
        public MigrateDotNetVersionIndex() {
            super("dot-net-program-versions", EStorageMigratorType.PROJECT, true);
        }
    }

    @ThreadSafe
    public static class MigrateSlideRenderDataIndex
    extends UnbranchedStoreMigration {
        public MigrateSlideRenderDataIndex() {
            super("slide-render-data", EStorageMigratorType.GLOBAL, true);
        }
    }

    @ThreadSafe
    public static class MigrateExternalAnalysisResultsIndex
    extends BranchedStoreMigration {
        public MigrateExternalAnalysisResultsIndex() {
            super("external-analysis-results", true);
        }
    }

    @ThreadSafe
    private static abstract class BranchedStoreMigration
    extends BranchBasedStoreBatchMigratorBase {
        private final String storeName;

        protected BranchedStoreMigration(String storeName, boolean compressing) {
            super(VERSION, compressing);
            this.storeName = storeName;
        }

        @Override
        protected byte[] migrateValue(byte[] key, byte[] value) throws StorageException {
            try {
                SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
                MigrateVersion191CommitDescriptorHierarchy.doMigrate(entityPool);
                return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        @Override
        public String getStoreName() {
            return this.storeName;
        }
    }

    @ThreadSafe
    private static abstract class UnbranchedStoreMigration
    extends SerializedValueMigratorBase {
        private final String storeName;
        private final EStorageMigratorType type;

        protected UnbranchedStoreMigration(String storeName, EStorageMigratorType type, boolean compressed) {
            super(compressed);
            this.storeName = storeName;
            this.type = type;
        }

        @Override
        protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
            MigrateVersion191CommitDescriptorHierarchy.doMigrate(entityPool);
        }

        @Override
        public String getStoreName() {
            return this.storeName;
        }

        @Override
        public EStorageSystemVersion getVersion() {
            return VERSION;
        }

        @Override
        public EStorageMigratorType getType() {
            return this.type;
        }
    }
}

