/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IBatchStorageMigrator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitInsertingStore;
import org.conqat.engine.persistence.store.branched.BranchCommitReadingStore;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class BranchBasedStoreBatchMigratorBase
implements IBatchStorageMigrator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EStorageSystemVersion version;
    private final boolean compressingStores;
    private final ConcurrentMap<Thread, MigrationState> migrationStatePerThread = new ConcurrentHashMap<Thread, MigrationState>();

    protected BranchBasedStoreBatchMigratorBase(EStorageSystemVersion version, boolean compressingStores) {
        this.version = version;
        this.compressingStores = compressingStores;
    }

    @Override
    public final EStorageSystemVersion getVersion() {
        return this.version;
    }

    @Override
    public final EStorageMigratorType getType() {
        return EStorageMigratorType.PROJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(IStore input, IStore output, IFactory<IStore, StorageException> tempStoreFactory) throws StorageException {
        try {
            MigrationState migrationState = new MigrationState(this.getCompressedStoreIfNeeded(input), this.getCompressedStoreIfNeeded(output));
            this.migrationStatePerThread.put(Thread.currentThread(), migrationState);
            PlainCommitLayeringDataLayout dataLayout = new PlainCommitLayeringDataLayout();
            CommitLayeringBranchingLayer branchingLayer = new CommitLayeringBranchingLayer(migrationState.inputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
            List commitKeys = branchingLayer.getCommitKeys();
            ArrayList<IBranchCommitInfo> infos = new ArrayList<IBranchCommitInfo>();
            for (byte[] commitKey : commitKeys) {
                byte[] commitName = dataLayout.extractCommitNameFromCommitInfoKey(commitKey);
                IBranchCommitInfo branchInfo = branchingLayer.readCommit(commitName);
                infos.add(branchInfo);
            }
            infos.sort(Comparator.comparing(IBranchCommitInfo::getTimestamp));
            for (IBranchCommitInfo branchInfo : infos) {
                this.migrateValuesForCommit(branchInfo, (ICommitLayeringDataLayout)dataLayout);
            }
        }
        finally {
            this.migrationStatePerThread.remove(Thread.currentThread());
        }
    }

    private IStore getCompressedStoreIfNeeded(IStore store) {
        if (this.compressingStores) {
            return new CompressingStore(store);
        }
        return store;
    }

    private void migrateValuesForCommit(IBranchCommitInfo branchInfo, ICommitLayeringDataLayout dataLayout) throws StorageException {
        CommitLayeringBranchingLayer branchingLayer;
        MigrationState migrationState = (MigrationState)this.migrationStatePerThread.get(Thread.currentThread());
        byte[] commitName = CommitLayeringBranchingLayer.createCommitName((String)branchInfo.getBranchName(), (long)branchInfo.getTimestamp());
        byte[] parentCommitName = null;
        Pair parentCommitBranchAndTimestamp = branchInfo.getParentCommitBranchAndTimestamp();
        if (parentCommitBranchAndTimestamp != null && (branchingLayer = new CommitLayeringBranchingLayer(migrationState.inputStore, dataLayout)).readCommit(parentCommitName = CommitLayeringBranchingLayer.createCommitName((String)((String)parentCommitBranchAndTimestamp.getFirst()), (long)((Long)parentCommitBranchAndTimestamp.getSecond()))) == null) {
            parentCommitName = null;
            LOGGER.warn("Parent for commit {} ({}) does not exist (parent: {} ({})). Removing link to parent.", (Object)branchInfo.getBranchName(), (Object)branchInfo.getTimestamp(), parentCommitBranchAndTimestamp.getFirst(), parentCommitBranchAndTimestamp.getSecond());
        }
        BranchCommitInsertingStore outputStoreAsInsertingStore = new BranchCommitInsertingStore(migrationState.outputStore, dataLayout, commitName, parentCommitName);
        byte[] commitEntryKey = dataLayout.createCommitEntryKey(commitName, null);
        DeduplicatingKeyValueCallback callback = new DeduplicatingKeyValueCallback(this, commitName, commitEntryKey.length, dataLayout, migrationState);
        migrationState.inputStore.scan(commitEntryKey, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        this.postProcessMigratedValues(callback.migratedValues, callback.deduplicatedMigratedValues);
        outputStoreAsInsertingStore.remove(callback.deletedKeys);
        outputStoreAsInsertingStore.put(callback.migratedValues);
        migrationState.outputStore.put(callback.deduplicatedMigratedValues);
    }

    protected void postProcessMigratedValues(PairList<byte[], byte[]> migratedValues, PairList<byte[], byte[]> deduplicatedMigratedValues) throws StorageException {
    }

    private static byte[] migrateKey(byte[] originalKey) {
        return originalKey;
    }

    private byte[] migrateAndCache(byte[] originalKey, ByteArrayWrapper wrappedValue, ICommitLayeringDataLayout dataLayout) throws StorageException {
        MigrationState migrationState = (MigrationState)this.migrationStatePerThread.get(Thread.currentThread());
        byte[] result = this.migrateValue(originalKey, BranchCommitReadingStore.resolveDataReference((byte[])wrappedValue.getBytes(), (IStore)migrationState.inputStore, (ICommitLayeringDataLayout)dataLayout));
        if (result == null) {
            return null;
        }
        BranchBasedStoreBatchMigratorBase.cacheResult(wrappedValue, result, migrationState.migrationCache);
        return result;
    }

    private static void cacheResult(ByteArrayWrapper key, byte[] value, Map<ByteArrayWrapper, byte[]> migrationCache) {
        if (BranchCommitReadingStore.isActualValueOrTombStone((byte[])value)) {
            migrationCache.put(key, value);
        } else {
            migrationCache.put(key, CommitLayeringBranchingLayer.createReferenceKey((byte[])value));
        }
    }

    protected abstract byte[] migrateValue(byte[] var1, byte[] var2) throws StorageException;

    private static final class MigrationState {
        final IStore inputStore;
        final IStore outputStore;
        final Map<ByteArrayWrapper, byte[]> migrationCache = new HashMap<ByteArrayWrapper, byte[]>();

        public MigrationState(IStore inputStore, IStore outputStore) {
            this.inputStore = inputStore;
            this.outputStore = outputStore;
        }
    }

    @ThreadSafe
    private class DeduplicatingKeyValueCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private final byte[] commitName;
        private final PairList<byte[], byte[]> migratedValues;
        private final PairList<byte[], byte[]> deduplicatedMigratedValues;
        private final List<byte[]> deletedKeys;
        private final int keyOffset;
        private final ICommitLayeringDataLayout dataLayout;
        private final MigrationState migrationState;
        final /* synthetic */ BranchBasedStoreBatchMigratorBase this$0;

        private DeduplicatingKeyValueCallback(BranchBasedStoreBatchMigratorBase branchBasedStoreBatchMigratorBase, byte[] commitName, int keyOffset, ICommitLayeringDataLayout dataLayout, MigrationState migrationState) {
            BranchBasedStoreBatchMigratorBase branchBasedStoreBatchMigratorBase2 = branchBasedStoreBatchMigratorBase;
            Objects.requireNonNull(branchBasedStoreBatchMigratorBase2);
            this.this$0 = branchBasedStoreBatchMigratorBase2;
            this.migratedValues = new PairList();
            this.deduplicatedMigratedValues = new PairList();
            this.deletedKeys = new ArrayList<byte[]>();
            this.commitName = commitName;
            this.keyOffset = keyOffset;
            this.dataLayout = dataLayout;
            this.migrationState = migrationState;
        }

        protected void callbackWithException(byte[] originalKeyWithOffset, byte[] originalValue) throws StorageException {
            byte[] originalKey = Arrays.copyOfRange(originalKeyWithOffset, this.keyOffset, originalKeyWithOffset.length);
            if (BranchCommitReadingStore.isTombStone((byte[])originalValue)) {
                this.deletedKeys.add(originalKey);
                return;
            }
            ByteArrayWrapper wrappedOriginalValue = new ByteArrayWrapper(originalValue);
            byte[] migratedKey = BranchBasedStoreBatchMigratorBase.migrateKey(originalKey);
            byte[] cachedResult = this.migrationState.migrationCache.get(wrappedOriginalValue);
            if (cachedResult != null) {
                this.deduplicatedMigratedValues.add((Object)this.dataLayout.createCommitEntryKey(this.commitName, migratedKey), (Object)cachedResult);
                return;
            }
            byte[] migratedValue = this.this$0.migrateAndCache(originalKey, wrappedOriginalValue, this.dataLayout);
            if (migratedValue == null) {
                this.deletedKeys.add(migratedKey);
            } else {
                this.migratedValues.add((Object)migratedKey, (Object)migratedValue);
            }
        }
    }
}

