/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import com.teamscale.core.migration.store.IStorageMigrator;
import com.teamscale.core.migration.store.MigratingStorageSystem;
import com.teamscale.core.migration.store.RenamingAndRemovingStorageSystem;
import com.teamscale.core.migration.store.StorageMigrationRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

public class StorageMigrator {
    private final EStorageSystemVersion sourceVersion;
    private List<MigratingStorageSystem> migratingStorageSystems = new ArrayList<MigratingStorageSystem>();
    private final IFactory<IStore, StorageException> tempStoreCreator;
    private final StorageMigrationRegistry storageMigrationRegistry;

    public StorageMigrator(EStorageSystemVersion sourceVersion, IFactory<IStore, StorageException> tempStoreCreator) throws StorageException {
        this(sourceVersion, tempStoreCreator, StorageMigrationRegistry.getInstance());
    }

    @VisibleForTesting
    StorageMigrator(EStorageSystemVersion sourceVersion, IFactory<IStore, StorageException> tempStoreCreator, StorageMigrationRegistry storageMigrationRegistry) throws StorageException {
        CCSMAssert.isNotNull((Object)((Object)sourceVersion));
        if (sourceVersion.ordinal() > EStorageSystemVersion.CURRENT_VERSION.ordinal()) {
            throw new StorageException("Cannot migrate from a version that is newer than the current version!");
        }
        this.sourceVersion = sourceVersion;
        this.tempStoreCreator = tempStoreCreator;
        this.storageMigrationRegistry = storageMigrationRegistry;
    }

    public void flushBatchMigrationsForOpenStorageSystems() throws StorageException {
        ArrayList reverseCopy = CollectionUtils.reverse(this.migratingStorageSystems);
        for (MigratingStorageSystem migratingStore : reverseCopy) {
            migratingStore.batchMigrate();
        }
        this.migratingStorageSystems = new ArrayList<MigratingStorageSystem>();
    }

    public boolean shouldImportStore(String storeName) {
        for (int i = this.sourceVersion.ordinal() + 1; i <= EStorageSystemVersion.CURRENT_VERSION.ordinal(); ++i) {
            EStorageSystemVersion targetVersion = EStorageSystemVersion.values()[i];
            Map<String, String> storeRenames = this.storageMigrationRegistry.getStoreRenames(targetVersion);
            if (this.storageMigrationRegistry.getStoreDeletionPatterns(targetVersion).contains(storeName)) {
                return false;
            }
            if (!storeRenames.containsKey(storeName)) continue;
            storeName = storeRenames.get(storeName);
        }
        return true;
    }

    public SchemaAwareMigratedStorageSystemProvider decorate(IndexLayer indexLayer) {
        return this.decorate(indexLayer.getRawStorageSystemProvider(), indexLayer.getStorageCacheProvider());
    }

    public SchemaAwareMigratedStorageSystemProvider decorate(IStorageSystemProvider rootStorageSystem, StorageCacheProvider storageCacheProvider) {
        return new SchemaAwareMigratedStorageSystemProvider(this, rootStorageSystem, storageCacheProvider);
    }

    private SchemaAwareStorageSystem decorate(IStorageSystem storageSystem, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider, Function<EStorageSystemVersion, Map<String, IStorageMigrator>> storeMigrationsFactory) throws StorageException {
        IndexSchema schema = new SchemaAwareStorageSystem(storageSystem, storageSystemCacheProvider).getSchema();
        for (int i = EStorageSystemVersion.CURRENT_VERSION.ordinal(); i > this.sourceVersion.ordinal(); --i) {
            EStorageSystemVersion targetVersion = EStorageSystemVersion.values()[i];
            Map<String, IStorageMigrator> storageMigrators = storeMigrationsFactory.apply(targetVersion);
            Map<String, String> storeRenames = this.storageMigrationRegistry.getStoreRenames(targetVersion);
            Set<String> storeDeletions = this.storageMigrationRegistry.getStoreDeletionPatterns(targetVersion);
            schema = new MigratedIndexSchema(schema, storeRenames, storeDeletions, storageMigrators);
            MigratingStorageSystem migratingStorageSystem = new MigratingStorageSystem(targetVersion, (IStorageSystem)storageSystem, schema, this.tempStoreCreator, storageMigrators);
            this.migratingStorageSystems.add(migratingStorageSystem);
            storageSystem = new RenamingAndRemovingStorageSystem(storeRenames, storeDeletions, migratingStorageSystem);
        }
        return new SchemaAwareStorageSystem(storageSystem, schema, storageSystemCacheProvider);
    }

    public class SchemaAwareMigratedStorageSystemProvider {
        private final IStorageSystemProvider rootStorageSystemProvider;
        private final StorageCacheProvider storageCacheProvider;
        final /* synthetic */ StorageMigrator this$0;

        private SchemaAwareMigratedStorageSystemProvider(StorageMigrator this$0, IStorageSystemProvider rootStorageSystemProvider, StorageCacheProvider storageCacheProvider) {
            StorageMigrator storageMigrator = this$0;
            Objects.requireNonNull(storageMigrator);
            this.this$0 = storageMigrator;
            this.rootStorageSystemProvider = rootStorageSystemProvider;
            this.storageCacheProvider = storageCacheProvider;
        }

        public SchemaAwareStorageSystem openGlobalStorageSystem() throws StorageException {
            return this.this$0.decorate(this.rootStorageSystemProvider.openStorageSystem("__global__"), this.storageCacheProvider.getCacheProvider("__global__"), this.this$0.storageMigrationRegistry::getGlobalMigrators);
        }

        public SchemaAwareStorageSystem openProjectStorageSystem(InternalProjectId projectId) throws StorageException {
            return this.this$0.decorate(this.rootStorageSystemProvider.openStorageSystem(projectId.toString()), this.storageCacheProvider.getCacheProvider(projectId.toString()), this.this$0.storageMigrationRegistry::getProjectMigrators);
        }

        public StorageCacheProvider getStorageCacheProvider() {
            return this.storageCacheProvider;
        }
    }

    @NoIndexValueClass
    private static class MigratedIndexSchema
    extends IndexSchema {
        private static final long serialVersionUID = 1L;
        private final IndexSchema underlyingIndexSchema;
        private final Map<String, String> storeRenames;
        private final Set<String> storeDeletions;
        private final List<String> migratedStoreNames = new ArrayList<String>();
        private final Set<String> multiStoreMigratedInputStores = new HashSet<String>();

        private MigratedIndexSchema(IndexSchema underlyingIndexSchema, Map<String, String> storeRenames, Set<String> storeDeletions, Map<String, IStorageMigrator> neededInputStores) {
            super(Collections.emptyMap(), null);
            this.underlyingIndexSchema = underlyingIndexSchema;
            this.storeRenames = storeRenames;
            this.storeDeletions = storeDeletions;
            neededInputStores.forEach((storeNamePattern, migrator) -> {
                if (migrator instanceof IMultiStoreMigrator) {
                    IMultiStoreMigrator multiStoreMigrator = (IMultiStoreMigrator)migrator;
                    this.multiStoreMigratedInputStores.addAll(multiStoreMigrator.getInputStoreNames());
                } else {
                    this.migratedStoreNames.add((String)storeNamePattern);
                }
            });
        }

        public SchemaEntry getEntry(String storeName) {
            if (this.storeDeletions.contains(storeName) || this.storeRenames.containsValue(storeName) && !this.storeRenames.containsKey(storeName)) {
                return null;
            }
            String renamedStoreName = this.storeRenames.getOrDefault(storeName, storeName);
            SchemaEntry entry = this.underlyingIndexSchema.getEntry(renamedStoreName);
            if (entry != null) {
                return entry;
            }
            if (this.multiStoreMigratedInputStores.contains(storeName) || this.migratedStoreNames.stream().anyMatch(storeNamePattern -> storeNamePattern.equals(storeName))) {
                return new SchemaEntry(IndexSchema.DummyIndex.class, new EStorageOption[0]);
            }
            return null;
        }

        public UnmodifiableSet<String> getEntryNames() {
            throw new UnsupportedOperationException("Migrating storage system can't determine exact entry names.");
        }
    }
}

