/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.io.Serializable;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public interface IOption
extends Serializable {
    public String validate(IStorageInfo var1, InstanceConfiguration var2) throws StorageException;

    default public void integrateExistingOption(IOption existingOption) {
    }

    public static <T extends IOption> Optional<T> getServerOptionForName(Class<T> optionClass, String optionName, IndexLayer indexLayer) throws StorageException {
        CCSMAssert.isNotNull((Object)optionName, () -> String.format("Expected \"%s\" to be not null", "optionName"));
        ServerOptionIndex optionIndex = indexLayer.openGlobalIndex(ServerOptionIndex.class);
        Pair<String, String> optionNameAndSelector = OptionRegistryBase.extractOptionNameAndSelector(optionName);
        T option = ServerOptionRegistry.getInstance().getOption("server", (String)optionNameAndSelector.getFirst(), (String)optionNameAndSelector.getSecond(), optionClass, optionIndex);
        return Optional.ofNullable(option);
    }

    public static void setServerOptionForName(String optionName, IOption option, IndexLayer indexLayer) throws StorageException {
        ServerOptionIndex optionIndex = indexLayer.openGlobalIndex(ServerOptionIndex.class);
        Pair<String, String> optionNameAndSelector = OptionRegistryBase.extractOptionNameAndSelector(optionName);
        ServerOptionRegistry.getInstance().putOption("server", (String)optionNameAndSelector.getFirst(), (String)optionNameAndSelector.getSecond(), option, optionIndex);
    }

    default public void executedActionsAfterModification(IndexLayer indexLayer) throws StorageException {
    }

    default public void executedActionsBeforeDeletion(IndexLayer indexLayer, String optionId) throws StorageException {
    }
}

