/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionParameterDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public final class OptionDescriptor {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="parameterDescriptions")
    private final List<OptionParameterDescriptor> parameterDescriptions = new ArrayList<OptionParameterDescriptor>();
    @JsonProperty(value="defaultValue")
    private final IOption defaultValue;
    @JsonIgnore
    private final Class<? extends IOption> optionClass;
    @JsonProperty(value="multiple")
    private final boolean multiple;
    @JsonProperty(value="category")
    private final String category;
    @JsonProperty(value="categoryIndex")
    private final int categoryIndex;
    @JsonProperty(value="orderingHint")
    private final int orderingHint;
    @JsonProperty(value="hidden")
    private final boolean hidden;

    public <T extends IOption> OptionDescriptor(String id, String name, T defaultValue, Class<T> optionClass, boolean multiple, boolean hidden) {
        this.id = id;
        this.name = name;
        this.defaultValue = defaultValue;
        this.optionClass = optionClass;
        this.multiple = multiple;
        this.hidden = hidden;
        Option optionAnnotation = optionClass.getAnnotation(Option.class);
        if (optionAnnotation != null) {
            this.category = optionAnnotation.category().getName();
            this.categoryIndex = optionAnnotation.category().ordinal();
            this.orderingHint = optionAnnotation.orderingHint();
            this.description = optionAnnotation.description();
        } else {
            this.category = EOptionCategory.OTHER.getName();
            this.categoryIndex = EOptionCategory.OTHER.ordinal();
            this.orderingHint = 1000;
            this.description = "";
        }
        this.checkIOptionConstraintsAndFillParameterDescriptions();
    }

    private void checkIOptionConstraintsAndFillParameterDescriptions() {
        CCSMAssert.isTrue((this.optionClass != null && IOption.class.isAssignableFrom(this.optionClass) ? 1 : 0) != 0, (String)("Must provide implementation of IOption: " + String.valueOf(this.optionClass)));
        try {
            this.optionClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            CCSMAssert.fail((String)("Public parameter-less constructor is missing: " + String.valueOf(this.optionClass)));
        }
        catch (SecurityException e) {
            CCSMAssert.fail((String)("Public parameter-less constructor is not accessible: " + String.valueOf(this.optionClass)));
        }
        for (Field field : OptionDescriptor.getOptionFields(this.optionClass)) {
            this.parameterDescriptions.add(new OptionParameterDescriptor(field));
        }
    }

    static List<Field> getOptionFields(Class<? extends IOption> optionClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : ReflectionUtils.getAllFields(optionClass)) {
            if (OptionDescriptor.isIgnoredOptionField(field) || !field.isAnnotationPresent(OptionFieldDescription.class)) continue;
            result.add(field);
        }
        return result;
    }

    private static boolean isIgnoredOptionField(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public UnmodifiableList<OptionParameterDescriptor> getParameterDescriptions() {
        return CollectionUtils.asUnmodifiable(this.parameterDescriptions);
    }

    public Class<? extends IOption> getOptionClass() {
        return this.optionClass;
    }

    public boolean isMultiple() {
        return this.multiple;
    }
}

