/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="ts.sso-login-redirect", name="Single sign-on (SSO)", type=EOptionType.SERVER, category=EOptionCategory.AUTH, orderingHint=50)
@IndexValueClass(containedInBackup=true)
public class AutomaticSsoLoginRedirectOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "ts.sso-login-redirect";
    public static final String OPTION_NAME = "Single sign-on (SSO)";
    @JsonProperty(value="enabled")
    @OptionFieldDescription(name="Enable Automatic Login Page Redirection", description="Redirect automatically to the SSO login page when the user is not logged in, instead of displaying the custom login page of Teamscale. This option works only if exactly one SSO connection is set in the Authentication settings. The redirection is not triggered when the login page is opened explicitly.")
    public boolean enabled = false;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public static boolean isAutomaticSsoLoginRedirectEnabled(ServerOptionIndex serverOptionIndex) throws StorageException {
        return ServerOptionRegistry.getInstance().getServerOption((String)OPTION_ID, AutomaticSsoLoginRedirectOption.class, (ServerOptionIndex)serverOptionIndex).enabled;
    }
}

