/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-id", name="Teamscale instance id", type=EOptionType.SERVER, category=EOptionCategory.OTHER, hidden=true)
@IndexValueClass(containedInBackup=true)
public class InstanceIdOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-id";
    public static final String OPTION_NAME = "Teamscale instance id";
    @JsonProperty(value="id")
    @OptionFieldDescription(name="The unique id of the Teamscale instance.")
    public String id = "";

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public static String getId(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        return InstanceIdOption.getId(optionIndex);
    }

    public static String getId(ServerOptionIndex optionIndex) throws StorageException {
        InstanceIdOption option = ServerOptionRegistry.getInstance().getOption("server", OPTION_ID, null, InstanceIdOption.class, optionIndex);
        if (option == null) {
            return null;
        }
        return option.id;
    }

    public static void ensureIdPresent(IndexLayer indexLayer) throws StorageException {
        ServerOptionIndex optionIndex = indexLayer.openGlobalIndex(ServerOptionIndex.class);
        if (StringUtils.isEmpty((CharSequence)InstanceIdOption.getId(optionIndex))) {
            InstanceIdOption idOption = new InstanceIdOption();
            idOption.id = UUID.randomUUID().toString();
            ServerOptionRegistry.getInstance().putOption("server", OPTION_ID, null, idOption, optionIndex);
        }
    }
}

