/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.DefaultGlobalRoles;
import com.teamscale.core.permissions.DefaultProjectRoles;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndexKeyUtils;
import com.teamscale.core.permissions.RoleAssignment;
import com.teamscale.core.permissions.RoleAssignmentWithGlobalInfo;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.RoleSchema;
import com.teamscale.core.permissions.SubjectRoleAssignments;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.permissions.roles.IRole;
import com.teamscale.core.permissions.roles.ProjectRole;
import com.teamscale.core.permissions.roles.RoleBase;
import com.teamscale.core.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.cache.IndexWithCache;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.transaction.TransactionalStore;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="permissions", options={EStorageOption.BACKUP, EStorageOption.COMPRESSED}, valueClasses={SubjectRoleAssignments.class, GlobalRole.class, ProjectRole.class})
@IndexWithCache(value={PermissionCache.class})
public class PermissionIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "permissions";
    private static final String PERMISSION_INDEX_UPDATE_LOCK = "PERMISSION_INDEX_UPDATE_LOCK";
    private final SynchronizedCacheAccess<PermissionCache> permissionCacheAccess;

    public PermissionIndex(IStore store, SynchronizedCacheAccess<PermissionCache> permissionCacheAccess) {
        super(store);
        this.permissionCacheAccess = permissionCacheAccess;
    }

    public List<SubjectRoleAssignments> getSubjectRoleAssignments(List<? extends ISubject> subjects) throws StorageException {
        List roleAssignmentKeys = CollectionUtils.map(subjects, PermissionIndexKeyUtils::createRoleAssignmentKey);
        List serializedRoleAssignments = this.store.getWithStrings(roleAssignmentKeys);
        ArrayList<SubjectRoleAssignments> roleAssignments = new ArrayList<SubjectRoleAssignments>(serializedRoleAssignments.size());
        for (int i = 0; i < serializedRoleAssignments.size(); ++i) {
            SubjectRoleAssignments roleAssignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])serializedRoleAssignments.get(i)));
            if (roleAssignment == null) {
                ISubject subject = subjects.get(i);
                roleAssignments.add(new SubjectRoleAssignments(subject.getSubjectType(), subject.getSubjectId()));
                continue;
            }
            roleAssignments.add(roleAssignment);
        }
        return roleAssignments;
    }

    private static <V extends IRole<?>> void alterRoleAssignments(ConvenientStore transactionalStore, RoleChange roleChange, Function<String, V> roleResolver, BiConsumer<SubjectRoleAssignments, V> roleAssignmentAdder, BiConsumer<SubjectRoleAssignments, V> roleAssignmentRemover) throws StorageException {
        PermissionIndex.alterRoleAssignments(transactionalStore, roleChange.removedRoles, roleResolver, roleAssignmentRemover);
        PermissionIndex.alterRoleAssignments(transactionalStore, roleChange.addedRoles, roleResolver, roleAssignmentAdder);
    }

    private static <V extends IRole<?>> void alterRoleAssignments(ConvenientStore transactionalStore, Set<RoleAssignment> roleChange, Function<String, V> roleResolver, BiConsumer<SubjectRoleAssignments, V> assignmentChanger) throws StorageException {
        SetMap roleNamesByKey = new SetMap();
        roleChange.forEach(assignment -> roleNamesByKey.add((Object)new Pair((Object)assignment.subjectType, (Object)assignment.subjectId), (Object)assignment.roleName));
        ArrayList subjectsOrdered = new ArrayList(roleNamesByKey.getKeys());
        List keys = CollectionUtils.map(subjectsOrdered, pair -> PermissionIndexKeyUtils.createRoleAssignmentKey((ESubjectType)((Object)((Object)pair.getFirst())), (String)pair.getSecond()));
        ConvenientStore store = new ConvenientStore((IStore)transactionalStore);
        List values = store.getWithStrings(keys);
        PairList updatedAssignments = new PairList(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            SubjectRoleAssignments roleAssignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])values.get(i)));
            Pair subjectPair = (Pair)subjectsOrdered.get(i);
            if (roleAssignment == null) {
                roleAssignment = new SubjectRoleAssignments((ESubjectType)((Object)subjectPair.getFirst()), (String)subjectPair.getSecond());
            }
            for (String roleName : (Set)roleNamesByKey.getCollectionOrEmpty((Object)subjectPair)) {
                IRole resolvedRole = (IRole)roleResolver.apply(roleName);
                if (resolvedRole == null) {
                    throw new StorageException("Role doesn't exist: " + roleName);
                }
                assignmentChanger.accept(roleAssignment, resolvedRole);
            }
            updatedAssignments.add((Object)((String)keys.get(i)), (Object)StorageUtils.serialize((Serializable)roleAssignment));
        }
        store.putWithStrings(updatedAssignments);
    }

    private void alterProjectRole(IProjectId projectId, RoleChange roleChange) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            RoleSchema schema = this.getRoleSchema();
            PermissionIndex.alterRoleAssignments(transactionalStore, roleChange, schema::getProjectRole, (roleAssignment, role) -> roleAssignment.addProjectRole(projectId, (ProjectRole)role), (roleAssignment, role) -> roleAssignment.removeProjectRole(projectId, (ProjectRole)role));
        }), "Role assignment change for project " + String.valueOf(projectId) + ": " + String.valueOf(roleChange));
    }

    void changeProjectRoleAssignments(IProjectId projectId, RoleChange roleChange) throws StorageException {
        this.alterProjectRole(projectId, roleChange);
    }

    void makeProjectAdmin(ISubject subject, ProjectInfo projectInfo) throws StorageException {
        this.alterProjectRole((IProjectId)projectInfo.getInternalId(), new RoleChange(subject, DefaultProjectRoles.PROJECT_ADMIN.getReadableName()));
        for (IProjectId projectId : projectInfo.getPublicIds()) {
            this.alterProjectRole(projectId, new RoleChange(subject, DefaultProjectRoles.PROJECT_ADMIN.getReadableName()));
        }
    }

    void removeProjectAdmin(User user, ProjectInfo projectInfo) throws StorageException {
        this.alterProjectRole((IProjectId)projectInfo.getInternalId(), new RoleChange((Set<RoleAssignment>)CollectionUtils.emptySet(), CollectionUtils.asHashSet((Object[])new RoleAssignment[]{new RoleAssignment(ESubjectType.USER, user.getUsername(), DefaultProjectRoles.PROJECT_ADMIN.getReadableName())})));
        Set ids = projectInfo.getPublicIds().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        for (IProjectId id : ids) {
            this.alterProjectRole(id, new RoleChange((Set<RoleAssignment>)CollectionUtils.emptySet(), CollectionUtils.asHashSet((Object[])new RoleAssignment[]{new RoleAssignment(ESubjectType.USER, user.getUsername(), DefaultProjectRoles.PROJECT_ADMIN.getReadableName())})));
        }
    }

    private PairList<byte[], byte[]> getAllRoleAssignments() throws StorageException {
        return new ConvenientStore((IStore)this.store).getEntriesStartingWith(PermissionIndexKeyUtils.createAllRoleAssignmentKeyPrefix());
    }

    private void iterateRolesAssignments(Consumer<SubjectRoleAssignments> roleConsumer) throws StorageException {
        PairList<byte[], byte[]> allRoleAssignments = this.getAllRoleAssignments();
        for (Pair keyAndSerializedRole : allRoleAssignments) {
            roleConsumer.accept((SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedRole.getSecond())));
        }
    }

    private Set<RoleAssignmentWithGlobalInfo> getRoles(Function<SubjectRoleAssignments, Set<String>> instanceRolesLoader, Function<SubjectRoleAssignments, Set<String>> globalRoleLoader) throws StorageException {
        HashSet<RoleAssignmentWithGlobalInfo> assignments = new HashSet<RoleAssignmentWithGlobalInfo>();
        this.iterateRolesAssignments(assignment -> {
            Set rolesOnInstance = (Set)instanceRolesLoader.apply((SubjectRoleAssignments)assignment);
            Set globalRoles = (Set)globalRoleLoader.apply((SubjectRoleAssignments)assignment);
            globalRoles.forEach(role -> assignments.add(PermissionIndex.createRoleAssignment(assignment, role, true)));
            if (rolesOnInstance == null) {
                return;
            }
            rolesOnInstance.forEach(role -> assignments.add(PermissionIndex.createRoleAssignment(assignment, role, false)));
        });
        return assignments;
    }

    public Set<String> getGlobalRoles(ESubjectType subjectType, String subjectId) throws StorageException {
        SubjectRoleAssignments roleAssignments = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])this.store.getWithString(PermissionIndexKeyUtils.createRoleAssignmentKey(subjectType, subjectId)));
        if (roleAssignments == null) {
            return CollectionUtils.emptySet();
        }
        return roleAssignments.getGlobalRoleNames();
    }

    public Set<RoleAssignmentWithGlobalInfo> getBasicRoles(EBasicPermissionScope scope, String instanceId) throws StorageException {
        HashSet<RoleAssignmentWithGlobalInfo> result = new HashSet<RoleAssignmentWithGlobalInfo>();
        for (Pair keyAndSerializedRole : this.getAllRoleAssignments()) {
            SubjectRoleAssignments keyAndSerializedAssignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedRole.getSecond()));
            Set<String> globalRoles = keyAndSerializedAssignment.getGlobalBasicRoles(scope);
            globalRoles.forEach(role -> result.add(PermissionIndex.createRoleAssignment(keyAndSerializedAssignment, role, true)));
            Map<String, Set<String>> basicRoles = keyAndSerializedAssignment.getBasicRoles(scope);
            Set<String> rolesOnInstance = basicRoles.get(instanceId);
            if (rolesOnInstance == null) continue;
            rolesOnInstance.forEach(role -> result.add(PermissionIndex.createRoleAssignment(keyAndSerializedAssignment, role, false)));
        }
        return result;
    }

    private static RoleAssignmentWithGlobalInfo createRoleAssignment(SubjectRoleAssignments roleAssignment, String roleName, boolean isGlobal) {
        return new RoleAssignmentWithGlobalInfo(roleAssignment.getSubjectType(), roleAssignment.getSubjectId(), roleName, isGlobal);
    }

    public Set<RoleAssignmentWithGlobalInfo> getProjectRoles(IProjectId projectId) throws StorageException {
        return this.getRoles(assignment -> assignment.getProjectRoles().get(projectId), SubjectRoleAssignments::getGlobalProjectRoles);
    }

    public void deleteProjectRolesForUser(String userName) throws StorageException {
        this.deleteProjectRolesForInstance(ESubjectType.USER, userName);
    }

    public void deleteProjectRolesForGroup(String groupName) throws StorageException {
        this.deleteProjectRolesForInstance(ESubjectType.GROUP, groupName);
    }

    public void deleteGlobalRolesForUser(String userName) throws StorageException {
        this.deleteGlobalRolesForSubject(ESubjectType.USER, userName);
    }

    public void deleteGlobalRolesForGroup(String groupName) throws StorageException {
        this.deleteGlobalRolesForSubject(ESubjectType.GROUP, groupName);
    }

    private void deleteGlobalRolesForSubject(ESubjectType subjectType, String subjectId) throws StorageException {
        SubjectRoleAssignments assignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])this.store.getWithString(PermissionIndexKeyUtils.createRoleAssignmentKey(subjectType, subjectId)));
        if (assignment == null || assignment.getGlobalRoleNames().isEmpty()) {
            return;
        }
        Set<RoleAssignment> globalRoleAssignments = assignment.getGlobalRoleNames().stream().map(roleName -> new RoleAssignment(subjectType, subjectId, (String)roleName)).collect(Collectors.toSet());
        this.alterGlobalRoleAssignments(new RoleChange((Set<RoleAssignment>)CollectionUtils.emptySet(), globalRoleAssignments));
    }

    public void deleteAllBasicRoleAssignmentsForSubject(ESubjectType subjectType, String subjectId) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> PermissionIndex.deleteAllBasicRoleAssignmentsForSubject(subjectType, subjectId, transactionalStore)), "Deleting all basic role assignments for " + String.valueOf((Object)subjectType) + " " + subjectId);
    }

    private static void deleteAllBasicRoleAssignmentsForSubject(ESubjectType subjectType, String subjectId, ConvenientStore transactionalStore) throws StorageException {
        PairList allRoleAssignments = transactionalStore.getEntriesStartingWith(PermissionIndexKeyUtils.createRoleAssignmentKey(subjectType, subjectId));
        if (allRoleAssignments.isEmpty()) {
            return;
        }
        for (Pair keyAndSerializedRole : allRoleAssignments) {
            SubjectRoleAssignments assignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedRole.getSecond()));
            assignment.clearAllBasicRoleAssignments();
            transactionalStore.put((byte[])keyAndSerializedRole.getFirst(), StorageUtils.serialize((Serializable)assignment));
        }
    }

    private void deleteProjectRolesForInstance(ESubjectType subjectType, String instanceName) throws StorageException {
        for (Pair keyAndSerializedRole : this.getAllRoleAssignments()) {
            SubjectRoleAssignments assignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedRole.getSecond()));
            if (assignment.getSubjectType() != subjectType || !assignment.getSubjectId().equals(instanceName)) continue;
            Map<IProjectId, Set<String>> projectRoles = assignment.getProjectRoles();
            for (Map.Entry<IProjectId, Set<String>> entry : projectRoles.entrySet()) {
                IProjectId projectId = entry.getKey();
                Set<RoleAssignment> roleAssignments = entry.getValue().stream().map(role -> PermissionIndex.createRoleAssignment(assignment, role, false)).collect(Collectors.toSet());
                this.alterProjectRole(projectId, new RoleChange((Set<RoleAssignment>)CollectionUtils.emptySet(), roleAssignments));
            }
            Set<String> globalProjectRoles = assignment.getGlobalProjectRoles();
            if (globalProjectRoles.isEmpty()) continue;
            Set<RoleAssignment> globalRoleAssignments = globalProjectRoles.stream().map(role -> PermissionIndex.createRoleAssignment(assignment, role, true)).collect(Collectors.toSet());
            this.alterGlobalProjectRoleAssignments(new RoleChange((Set<RoleAssignment>)CollectionUtils.emptySet(), globalRoleAssignments));
        }
    }

    private void alterBasicRoleAssignments(EBasicPermissionScope permissionScope, String objectId, RoleChange roleChange) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            RoleSchema schema = this.getRoleSchema();
            PermissionIndex.alterRoleAssignments(transactionalStore, roleChange, schema::getBasicRole, (roleAssignment, role) -> roleAssignment.addBasicRole(permissionScope, objectId, (EBasicRole)role), (roleAssignment, role) -> roleAssignment.removeBasicRole(permissionScope, objectId, (EBasicRole)role));
        }), "Role assignment change for instance " + objectId + " in scope " + String.valueOf((Object)permissionScope) + ": " + String.valueOf(roleChange));
    }

    public void changeBasicRoleAssignments(EBasicPermissionScope permissionScope, String objectId, RoleChange roleChange) throws StorageException {
        this.alterBasicRoleAssignments(permissionScope, objectId, roleChange);
    }

    void makeOwner(ISubject subject, EBasicPermissionScope permissionScope, String objectId) throws StorageException {
        this.alterBasicRoleAssignments(permissionScope, objectId, new RoleChange(subject, EBasicRole.OWNER.getReadableName()));
    }

    private void alterGlobalRoleAssignments(RoleChange roleChange) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            RoleSchema schema = this.getRoleSchema();
            PermissionIndex.alterRoleAssignments(transactionalStore, roleChange, schema::getGlobalRole, SubjectRoleAssignments::addGlobalRole, (roleAssignment, role) -> roleAssignment.removeGlobalRole(role.getReadableName()));
        }), "Performing role change for global roles: " + String.valueOf(roleChange));
    }

    void changeGlobalRoleAssignments(RoleChange roleChange) throws StorageException {
        this.alterGlobalRoleAssignments(roleChange);
    }

    void makeInstanceAdmin(ISubject subject) throws StorageException {
        this.alterGlobalRoleAssignments(new RoleChange(subject, DefaultGlobalRoles.INSTANCE_ADMIN.getReadableName()));
    }

    private void alterGlobalProjectRoleAssignments(RoleChange roleChange) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            RoleSchema schema = this.getRoleSchema();
            PermissionIndex.alterRoleAssignments(transactionalStore, roleChange, schema::getProjectRole, SubjectRoleAssignments::addGlobalProjectRole, SubjectRoleAssignments::removeGlobalProjectRole);
        }), "Performing global project role change: " + String.valueOf(roleChange));
    }

    void changeGlobalProjectRoleAssignments(RoleChange roleChange) throws StorageException {
        this.alterGlobalProjectRoleAssignments(roleChange);
    }

    void assignGlobalProjectRole(ISubject subject, String roleName) throws StorageException {
        this.alterGlobalProjectRoleAssignments(new RoleChange(subject, roleName));
    }

    private void alterGlobalBasicRoleAssignments(EBasicPermissionScope permissionScope, RoleChange roleChange) throws StorageException, AssertionError {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            RoleSchema schema = this.getRoleSchema();
            PermissionIndex.alterRoleAssignments(transactionalStore, roleChange, schema::getBasicRole, (roleAssignment, role) -> roleAssignment.addGlobalBasicRole(permissionScope, (EBasicRole)role), (roleAssignment, role) -> roleAssignment.removeGlobalBasicRole(permissionScope, (EBasicRole)role));
        }), "Performing global instance role change for scope " + String.valueOf((Object)permissionScope) + ": " + String.valueOf(roleChange));
    }

    void changeGlobalBasicRoleAssignments(EBasicPermissionScope permissionScope, RoleChange roleChange) throws StorageException, AssertionError {
        this.alterGlobalBasicRoleAssignments(permissionScope, roleChange);
    }

    void assignGlobalBasicRole(ISubject subject, String roleName, EBasicPermissionScope permissionScope) throws StorageException, AssertionError {
        this.alterGlobalBasicRoleAssignments(permissionScope, new RoleChange(subject, roleName));
    }

    private void updateRoleSchema(ConvenientStore transactionalStore, ConsumerWithException<RoleSchema, StorageException> roleSchemaChanger) throws StorageException {
        RoleSchema roleSchema = this.getRoleSchema();
        Set<String> globalRoleNamesCopy = PermissionIndex.getRoleNamesFrom(roleSchema.getGlobalRoles(), "Instance Admin");
        Set<String> projectRoleNamesCopy = PermissionIndex.getRoleNamesFrom(roleSchema.getProjectRoles(), "Project Administrator");
        roleSchemaChanger.accept((Object)roleSchema);
        PermissionIndex.updateRoles(roleSchema.getGlobalRoles(), globalRoleNamesCopy, "Instance Admin", transactionalStore, PermissionIndexKeyUtils::createGlobalRoleKey);
        PermissionIndex.updateRoles(roleSchema.getProjectRoles(), projectRoleNamesCopy, "Project Administrator", transactionalStore, PermissionIndexKeyUtils::createProjectRoleKey);
    }

    private static <T extends RoleBase> Set<String> getRoleNamesFrom(Set<T> roles, String defaultRoleName) {
        return roles.stream().map(RoleBase::getReadableName).filter(roleName -> !roleName.equals(defaultRoleName)).collect(Collectors.toSet());
    }

    private static <T extends RoleBase> void updateRoles(Set<T> roles, Set<String> roleNamesCopy, String defaultRoleName, ConvenientStore transactionalStore, Function<String, String> createStorageKey) throws StorageException {
        for (RoleBase role : roles) {
            if (role.getReadableName().equals(defaultRoleName)) continue;
            transactionalStore.putWithString(createStorageKey.apply(role.getReadableName()), StorageUtils.serialize((Serializable)role));
            roleNamesCopy.remove(role.getReadableName());
        }
        for (String roleName : roleNamesCopy) {
            transactionalStore.removeWithString(createStorageKey.apply(roleName));
        }
    }

    void setGlobalRole(String oldRoleName, GlobalRole role) throws StorageException {
        this.setRoleInSchema(oldRoleName, role, (ConsumerWithException<RoleSchema, StorageException>)((ConsumerWithException)roleSchema -> roleSchema.setGlobalRole(oldRoleName, role)), roleAssignment -> roleAssignment.renameGlobalRole(oldRoleName, role), "Writing new global role: " + role.getReadableName());
    }

    void removeGlobalRole(String roleName) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            this.updateRoleSchema((ConvenientStore)transactionalStore, (ConsumerWithException<RoleSchema, StorageException>)((ConsumerWithException)roleSchema -> roleSchema.deleteGlobalRole(roleName)));
            PermissionIndex.updateAllRoleAssignments(transactionalStore, roleAssignment -> roleAssignment.removeGlobalRole(roleName));
        }), "Removing role: " + roleName);
    }

    void removeProjectRole(String roleName) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            this.updateRoleSchema((ConvenientStore)transactionalStore, (ConsumerWithException<RoleSchema, StorageException>)((ConsumerWithException)roleSchema -> roleSchema.deleteProjectRole(roleName)));
            PermissionIndex.updateAllRoleAssignments(transactionalStore, roleAssignment -> roleAssignment.deleteProjectRole(roleName));
        }), "Removing role: " + roleName);
    }

    void setGlobalRole(GlobalRole role) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> this.updateRoleSchema((ConvenientStore)transactionalStore, (ConsumerWithException<RoleSchema, StorageException>)((ConsumerWithException)roleSchema -> roleSchema.setGlobalRole(null, role)))), "Writing new global role: " + role.getReadableName());
    }

    private static void updateAllRoleAssignments(ConvenientStore transactionalStore, Consumer<SubjectRoleAssignments> assignmentChanger) throws StorageException {
        PairList currentAssignments = transactionalStore.getEntriesStartingWith(PermissionIndexKeyUtils.createAllRoleAssignmentKeyPrefix());
        PairList updatedAssignments = new PairList(currentAssignments.size());
        for (Pair keyAndSerializedAssignment : currentAssignments) {
            SubjectRoleAssignments assignment = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedAssignment.getSecond()));
            assignmentChanger.accept(assignment);
            updatedAssignments.add((Object)((byte[])keyAndSerializedAssignment.getFirst()), (Object)StorageUtils.serialize((Serializable)assignment));
        }
        transactionalStore.put(updatedAssignments);
    }

    private static boolean isRoleRename(String oldRoleName, IRole<?> role) {
        return !StringUtils.isEmpty((String)oldRoleName) && !oldRoleName.equals(role.getReadableName());
    }

    private void setRoleInSchema(String oldRoleName, IRole<?> role, ConsumerWithException<RoleSchema, StorageException> roleSchemaUpdater, Consumer<SubjectRoleAssignments> roleAssignmentUpdater, String updateMessage) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            this.updateRoleSchema((ConvenientStore)transactionalStore, roleSchemaUpdater);
            if (PermissionIndex.isRoleRename(oldRoleName, role)) {
                PermissionIndex.updateAllRoleAssignments(transactionalStore, roleAssignmentUpdater);
            }
        }), updateMessage);
    }

    void setProjectRole(String oldRoleName, ProjectRole role) throws StorageException {
        this.setRoleInSchema(oldRoleName, role, (ConsumerWithException<RoleSchema, StorageException>)((ConsumerWithException)roleSchema -> roleSchema.setProjectRole(oldRoleName, role)), roleAssignment -> roleAssignment.renameProjectRole(oldRoleName, role), "Writing new project role: " + role.getReadableName());
    }

    void setProjectRole(ProjectRole role) throws StorageException {
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> this.updateRoleSchema((ConvenientStore)transactionalStore, (ConsumerWithException<RoleSchema, StorageException>)((ConsumerWithException)roleSchema -> roleSchema.setProjectRole(null, role)))), "Writing new project role: " + role.getReadableName());
    }

    public RoleSchema getRoleSchema() throws StorageException {
        RoleSchema roleSchema = new RoleSchema();
        PairList currentGlobalRoles = this.store.getEntriesStartingWith(PermissionIndexKeyUtils.createAllGlobalRoleKeyPrefix());
        for (Pair keyAndSerializedGlobalRole : currentGlobalRoles) {
            GlobalRole globalRole = (GlobalRole)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedGlobalRole.getSecond()));
            roleSchema.setGlobalRole(globalRole.getReadableName(), globalRole);
        }
        PairList currentProjectRoles = this.store.getEntriesStartingWith(PermissionIndexKeyUtils.createAllProjectRoleKeyPrefix());
        for (Pair keyAndSerializedProjectRole : currentProjectRoles) {
            ProjectRole projectRole = (ProjectRole)StorageUtils.deserialize((byte[])((byte[])keyAndSerializedProjectRole.getSecond()));
            roleSchema.setProjectRole(projectRole.getReadableName(), projectRole);
        }
        return roleSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpdateTransaction(ConsumerWithException<ConvenientStore, StorageException> transactionalOperation, String updateMessage) throws StorageException {
        Lock lock = this.store.obtainLock(PERMISSION_INDEX_UPDATE_LOCK);
        TransactionalStore transactionalStore = new TransactionalStore((IStore)this.store);
        lock.lock();
        Class<PermissionCache> clazz = PermissionCache.class;
        synchronized (PermissionCache.class) {
            try {
                transactionalOperation.accept((Object)new ConvenientStore((IStore)transactionalStore));
                transactionalStore.commit();
                AuditLogs.permissionUpdate(updateMessage);
                this.permissionCacheAccess.invalidate(updateMessage);
            }
            finally {
                lock.unlock();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static PairList<byte[], byte[]> calculateMovedOrCopiedGroupRoleAssignments(ConvenientStore permissionStore, String sourceUserGroupName, String targetUserGroupName, boolean deleteOldPermissions) throws StorageException {
        PairList valuesToStore = new PairList();
        PairList groupRoleAssignments = permissionStore.getEntriesStartingWith(PermissionIndexKeyUtils.createRoleAssignmentKey(ESubjectType.GROUP, sourceUserGroupName));
        for (int i = 0; i < groupRoleAssignments.size(); ++i) {
            SubjectRoleAssignments subjectRoleAssignments = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])groupRoleAssignments.getSecond(i)));
            subjectRoleAssignments.setSubjectId(targetUserGroupName);
            valuesToStore.add((Object)StringUtils.stringToBytes((String)PermissionIndexKeyUtils.createRoleAssignmentKey(ESubjectType.GROUP, targetUserGroupName)), (Object)StorageUtils.serialize((Serializable)subjectRoleAssignments));
        }
        if (deleteOldPermissions) {
            permissionStore.remove(groupRoleAssignments.extractFirstList());
        }
        return valuesToStore;
    }

    private PairList<byte[], byte[]> calculateMovedOrCopiedUserRoleAssignments(String sourceUserGroupName, String targetUserGroupName, boolean deleteOldPermissions) throws StorageException {
        PairList valuesToStore = new PairList();
        PairList<byte[], byte[]> userRoleAssignments = this.getAllRoleAssignments();
        for (int i = 0; i < userRoleAssignments.size(); ++i) {
            SubjectRoleAssignments subjectRoleAssignments = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])userRoleAssignments.getSecond(i)));
            Map<String, Set<String>> groupRoles = subjectRoleAssignments.getBasicRoles(EBasicPermissionScope.GROUPS);
            Set<String> existingRoles = groupRoles.get(sourceUserGroupName);
            if (existingRoles == null) continue;
            if (deleteOldPermissions) {
                groupRoles.remove(sourceUserGroupName);
            }
            groupRoles.put(targetUserGroupName, existingRoles);
            valuesToStore.add((Object)((byte[])userRoleAssignments.getFirst(i)), (Object)StorageUtils.serialize((Serializable)subjectRoleAssignments));
        }
        return valuesToStore;
    }

    public void moveOrCopyGroupPermissions(String sourceUserGroupName, String targetUserGroupName, boolean deleteOldPermissions) throws StorageException {
        Object updateMessage = deleteOldPermissions ? "Moving" : "Copying";
        updateMessage = (String)updateMessage + " permissions from group " + sourceUserGroupName + " to " + targetUserGroupName;
        this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
            PairList<byte[], byte[]> valuesToStore = PermissionIndex.calculateMovedOrCopiedGroupRoleAssignments(transactionalStore, sourceUserGroupName, targetUserGroupName, deleteOldPermissions);
            valuesToStore.addAll(this.calculateMovedOrCopiedUserRoleAssignments(sourceUserGroupName, targetUserGroupName, deleteOldPermissions));
            transactionalStore.put(valuesToStore);
        }), (String)updateMessage);
    }

    public List<Pair<String, SubjectRoleAssignments>> getInconsistentGroupsAndRoleAssignments() throws StorageException {
        PairList groupRoleAssignments = this.store.getEntriesStartingWith(PermissionIndexKeyUtils.createGroupRoleAssignmentKey());
        ArrayList<Pair<String, SubjectRoleAssignments>> inconsistentGroupsAndRoleAssignments = new ArrayList<Pair<String, SubjectRoleAssignments>>(groupRoleAssignments.size());
        for (int i = 0; i < groupRoleAssignments.size(); ++i) {
            SubjectRoleAssignments roleAssignments;
            String key = StringUtils.bytesToString((byte[])((byte[])groupRoleAssignments.getFirst(i)));
            String group = StringUtils.stripPrefix((String)key, (String)PermissionIndexKeyUtils.createGroupRoleAssignmentKey());
            if (group.equals((roleAssignments = (SubjectRoleAssignments)StorageUtils.deserialize((byte[])((byte[])groupRoleAssignments.getSecond(i)))).getSubjectId())) continue;
            inconsistentGroupsAndRoleAssignments.add((Pair<String, SubjectRoleAssignments>)Pair.createPair((Object)group, (Object)roleAssignments));
        }
        return inconsistentGroupsAndRoleAssignments;
    }

    public String fixInconsistentGroupRoleAssignments() throws StorageException {
        StringBuilder resultMessage = new StringBuilder();
        for (Pair<String, SubjectRoleAssignments> groupAndRoleAssignments : this.getInconsistentGroupsAndRoleAssignments()) {
            PairList valuesToStore = new PairList();
            String oldGroup = ((SubjectRoleAssignments)groupAndRoleAssignments.getSecond()).getSubjectId();
            String newGroup = (String)groupAndRoleAssignments.getFirst();
            String updateMessage = "Fixing group permissions from group " + oldGroup + " to group " + newGroup;
            ((SubjectRoleAssignments)groupAndRoleAssignments.getSecond()).setSubjectId(newGroup);
            valuesToStore.add((Object)StringUtils.stringToBytes((String)PermissionIndexKeyUtils.createRoleAssignmentKey(ESubjectType.GROUP, newGroup)), (Object)StorageUtils.serialize((Serializable)((Serializable)groupAndRoleAssignments.getSecond())));
            this.performUpdateTransaction((ConsumerWithException<ConvenientStore, StorageException>)((ConsumerWithException)transactionalStore -> {
                valuesToStore.addAll(this.calculateMovedOrCopiedUserRoleAssignments(oldGroup, newGroup, true));
                transactionalStore.put(valuesToStore);
            }), updateMessage);
            resultMessage.append(updateMessage).append("\n");
        }
        return resultMessage.toString();
    }
}

