/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.performance;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.ProcessIdManager;
import com.teamscale.core.runtime.api.performance.PerformanceAggregateEntry;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.performance.GlobalPerformanceIndex;
import com.teamscale.core.runtime.impl.performance.ProjectPerformanceIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class PerformanceIndexBase
extends IndexBase {
    private static final Map<String, Object> AGGREGATE_UPDATE_LOCK = new HashMap<String, Object>();
    private static final byte[] AGGREGATE_KEY_PREFIX = new byte[]{50};
    private static final byte[] DETAIL_KEY_PREFIX = new byte[]{51};

    protected PerformanceIndexBase(IStore store) {
        super(store);
    }

    public static PerformanceIndexBase open(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance(projectId)) {
            return indexLayer.openGlobalIndex(GlobalPerformanceIndex.class);
        }
        return indexLayer.openNonHistorizedProjectIndex(ProjectPerformanceIndex.class, projectId);
    }

    public void setStateChange(EAnalysisState reachedState) throws StorageException {
        byte[] key = PerformanceIndexBase.makeStateChangeKey(reachedState);
        if (this.store.get(key) != null) {
            return;
        }
        this.store.put(key, ByteArrayUtils.longToByteArray((long)System.currentTimeMillis()));
    }

    private static byte[] makeStateChangeKey(EAnalysisState reachedState) {
        return new byte[]{(byte)reachedState.ordinal()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAggregate(PerformanceDetailEntry entry) throws StorageException {
        Object lock;
        byte[] key = PerformanceIndexBase.makeAggregateKey(entry);
        Object object = AGGREGATE_UPDATE_LOCK;
        synchronized (object) {
            lock = AGGREGATE_UPDATE_LOCK.computeIfAbsent(String.valueOf(entry.getProjectId()) + entry.getTrigger(), x -> new Object());
        }
        object = lock;
        synchronized (object) {
            PerformanceAggregateEntry aggregate = (PerformanceAggregateEntry)StorageUtils.deserialize((byte[])this.store.get(key));
            if (aggregate == null) {
                aggregate = new PerformanceAggregateEntry(entry.getState(), entry.getTrigger());
            }
            aggregate.update(entry);
            this.store.put(key, StorageUtils.serialize((Serializable)aggregate));
        }
    }

    private static byte[] makeAggregateKey(PerformanceDetailEntry entry) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{AGGREGATE_KEY_PREFIX, StringUtils.stringToBytes((String)ProcessIdManager.getProcessId()), PerformanceIndexBase.makeStateChangeKey(entry.getState()), StringUtils.stringToBytes((String)entry.getTrigger())});
    }

    public void addDetailEntry(PerformanceDetailEntry entry) throws StorageException {
        this.store.put(PerformanceIndexBase.makeDetailKey(entry), StorageUtils.serialize((Serializable)entry));
    }

    private static byte[] makeDetailKey(PerformanceDetailEntry entry) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DETAIL_KEY_PREFIX, ByteArrayUtils.longToByteArray((long)entry.getMainWorkerPerformance().startTime().toEpochMilli()), StringUtils.stringToBytes((String)entry.getMainWorkerPerformance().workerId())});
    }

    public List<PerformanceAggregateEntry> getAllAggregates() throws StorageException {
        final HashMap result = new HashMap();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                PerformanceAggregateEntry entry = (PerformanceAggregateEntry)StorageUtils.deserialize((byte[])value);
                String resultKey = entry.getTrigger() + "-" + String.valueOf((Object)entry.getState());
                result.merge(resultKey, entry, PerformanceAggregateEntry::merge);
            }
        };
        this.store.scan(AGGREGATE_KEY_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return new ArrayList<PerformanceAggregateEntry>(result.values());
    }

    public List<PerformanceDetailEntry> getAllDetails() throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(DETAIL_KEY_PREFIX, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    public Map<EAnalysisState, Long> getStateChangeTimestamps() throws StorageException {
        EnumMap<EAnalysisState, Long> result = new EnumMap<EAnalysisState, Long>(EAnalysisState.class);
        for (EAnalysisState state : EAnalysisState.values()) {
            byte[] value = this.store.get(PerformanceIndexBase.makeStateChangeKey(state));
            if (value == null) continue;
            result.put(state, ByteArrayUtils.byteArrayToLong((byte[])value));
        }
        return result;
    }
}

