/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Schema(oneOf={PlainCommit.class, ParentedCommit.class})
@IndexValueClass
public sealed interface ISchedulingCommit
extends Serializable {
    public CommitDescriptor commit();

    public static PlainCommit plain(CommitDescriptor commit) {
        return new PlainCommit(commit);
    }

    public static ParentedCommit parented(ParentedCommitDescriptor commit) {
        return new ParentedCommit(commit);
    }

    @TestOnly
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static @Nullable PlainCommit of(@Nullable CommitDescriptor commit) {
        if (commit == null) {
            return null;
        }
        return new PlainCommit(commit);
    }

    @TestOnly
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static @Nullable ParentedCommit of(@Nullable ParentedCommitDescriptor commit) {
        if (commit == null) {
            return null;
        }
        return new ParentedCommit(commit);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static @Nullable CommitDescriptor getCommit(@Nullable ISchedulingCommit schedulingCommit) {
        if (schedulingCommit == null) {
            return null;
        }
        return schedulingCommit.commit();
    }

    @IndexValueClass
    public record PlainCommit(CommitDescriptor commit) implements ISchedulingCommit
    {
        public PlainCommit {
            Objects.requireNonNull(commit, "commit");
        }
    }

    @IndexValueClass
    public record ParentedCommit(ParentedCommitDescriptor parentedCommit) implements ISchedulingCommit
    {
        public ParentedCommit {
            Objects.requireNonNull(parentedCommit, "parentedCommit");
        }

        @Override
        public CommitDescriptor commit() {
            return this.parentedCommit.getCommit();
        }
    }
}

