/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.PostStepParameterInjection;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.IPreAnnouncingAnalysisStep;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepBranchingLayerAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepDeltaSource;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepGlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepParameter;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepPostInjectionMethod;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepProjectIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.IIndexName;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class AnalysisStepInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<? extends AnalysisStepBase> analysisStepClass;
    private final Map<EIndexAccessMode, List<AnalysisStepProjectIndexAccess<?>>> indexAccesses = new EnumMap(EIndexAccessMode.class);
    private final Map<EIndexAccessMode, List<AnalysisStepGlobalIndexAccess>> globalIndexAccesses = new EnumMap<EIndexAccessMode, List<AnalysisStepGlobalIndexAccess>>(EIndexAccessMode.class);
    private final List<AnalysisStepBranchingLayerAccess> branchingLayerAccesses = new ArrayList<AnalysisStepBranchingLayerAccess>();
    private final List<AnalysisStepDeltaSource<?>> deltaSources = new ArrayList();
    private final List<AnalysisStepParameter> analysisStepParameters = new ArrayList<AnalysisStepParameter>();
    private final List<AnalysisStepPostInjectionMethod> postInjectionMethods = new ArrayList<AnalysisStepPostInjectionMethod>();

    public AnalysisStepInitializer(Class<? extends AnalysisStepBase> analysisStepClass) throws TriggerCompilationException {
        this.analysisStepClass = analysisStepClass;
        this.initializeFromFields(analysisStepClass, Collections.emptyList(), "");
        this.initializeFromMethods(analysisStepClass, Collections.emptyList());
        this.validateIndexAccesses(this.globalIndexAccesses);
        this.validateIndexAccesses(this.indexAccesses);
        this.validateDeltaSources();
        this.validateBlockParameters();
    }

    private void initializeFromFields(Class<?> fieldHolder, List<Field> fieldStack, String namePrefix) throws TriggerCompilationException {
        for (Field field : ReflectionUtils.getAllFields(fieldHolder)) {
            StepParameterObject parameterObject;
            StepParameter blockParameter;
            DeltaSource.Dynamic dynamicDeltaSource;
            DeltaSource.Named namedDeltaSource;
            DeltaSource deltaSource;
            BranchingLayerAccess.Dynamic dynamicBranchingLayerAccess;
            BranchingLayerAccess.Named namedBranchingLayerAccess;
            BranchingLayerAccess branchingLayerAccess;
            GlobalIndexAccess globalIndexAccess;
            IndexAccess.Dynamic dynamicIndexAccess;
            IndexAccess.Named namedIndexAccess;
            IndexAccess indexAccess = field.getAnnotation(IndexAccess.class);
            if (indexAccess != null) {
                this.indexAccesses.computeIfAbsent(indexAccess.value(), ignored -> new ArrayList()).add(AnalysisStepProjectIndexAccess.ofIndexAccess(field, fieldStack, indexAccess));
            }
            if ((namedIndexAccess = field.getAnnotation(IndexAccess.Named.class)) != null) {
                this.indexAccesses.computeIfAbsent(namedIndexAccess.mode(), ignored -> new ArrayList()).add(AnalysisStepProjectIndexAccess.ofNamedIndexAccess(field, fieldStack, namedIndexAccess));
            }
            if ((dynamicIndexAccess = field.getAnnotation(IndexAccess.Dynamic.class)) != null) {
                this.indexAccesses.computeIfAbsent(dynamicIndexAccess.value(), ignored -> new ArrayList()).add(AnalysisStepProjectIndexAccess.ofDynamicIndexAccess(field, fieldStack, dynamicIndexAccess));
            }
            if ((globalIndexAccess = field.getAnnotation(GlobalIndexAccess.class)) != null) {
                this.globalIndexAccesses.computeIfAbsent(globalIndexAccess.value(), ignored -> new ArrayList()).add(new AnalysisStepGlobalIndexAccess(field, fieldStack, globalIndexAccess));
            }
            if ((branchingLayerAccess = field.getAnnotation(BranchingLayerAccess.class)) != null) {
                this.branchingLayerAccesses.add(AnalysisStepBranchingLayerAccess.ofBranchingLayer(field, fieldStack, branchingLayerAccess));
            }
            if ((namedBranchingLayerAccess = field.getAnnotation(BranchingLayerAccess.Named.class)) != null) {
                this.branchingLayerAccesses.add(AnalysisStepBranchingLayerAccess.ofNamedBranchingLayer(field, fieldStack, namedBranchingLayerAccess));
            }
            if ((dynamicBranchingLayerAccess = field.getAnnotation(BranchingLayerAccess.Dynamic.class)) != null) {
                this.branchingLayerAccesses.add(AnalysisStepBranchingLayerAccess.ofDynamicBranchingLayer(field, fieldStack, dynamicBranchingLayerAccess));
            }
            if ((deltaSource = field.getAnnotation(DeltaSource.class)) != null) {
                this.deltaSources.add(AnalysisStepDeltaSource.ofDeltaSource(field, fieldStack, deltaSource));
            }
            if ((namedDeltaSource = field.getAnnotation(DeltaSource.Named.class)) != null) {
                this.deltaSources.add(AnalysisStepDeltaSource.ofNamedDeltaSource(field, fieldStack, namedDeltaSource));
            }
            if ((dynamicDeltaSource = field.getAnnotation(DeltaSource.Dynamic.class)) != null) {
                this.deltaSources.add(AnalysisStepDeltaSource.ofDynamicDeltaSource(field, fieldStack, dynamicDeltaSource));
            }
            if ((blockParameter = field.getAnnotation(StepParameter.class)) != null) {
                this.analysisStepParameters.add(new AnalysisStepParameter(field, fieldStack, namePrefix, blockParameter));
            }
            if ((parameterObject = field.getAnnotation(StepParameterObject.class)) == null) continue;
            ArrayList<Field> newFieldStack = new ArrayList<Field>(fieldStack);
            newFieldStack.add(field);
            CCSMAssert.isNotEmpty((Collection)ReflectionUtils.getAllFields(field.getType()), (String)"Types annotated with @StepParameterObject must have at least one field.");
            this.initializeFromFields(field.getType(), newFieldStack, namePrefix + parameterObject.namePrefix());
            this.initializeFromMethods(field.getType(), newFieldStack);
        }
    }

    private void initializeFromMethods(Class<?> fieldHolder, List<Field> fieldStack) throws TriggerCompilationException {
        for (Method method : fieldHolder.getDeclaredMethods()) {
            PostStepParameterInjection postInject = method.getAnnotation(PostStepParameterInjection.class);
            if (postInject == null) continue;
            this.postInjectionMethods.add(new AnalysisStepPostInjectionMethod(method, fieldStack));
        }
    }

    private void validateIndexAccesses(Map<EIndexAccessMode, ? extends List<? extends AnalysisStepIndexAccessBase<?>>> indexAccesses) throws TriggerCompilationException {
        TwoDimHashMap seenAccesses = indexAccesses.values().stream().flatMap(Collection::stream).collect(TwoDimHashMap::new, (map, access) -> map.putValue((Object)access.getIndexName(), (Object)access.getAccessMode(), access), TwoDimHashMap::putAll);
        for (IIndexName indexName : seenAccesses.getFirstKeys()) {
            AnalysisStepIndexAccessBase readAccess = (AnalysisStepIndexAccessBase)seenAccesses.getValue((Object)indexName, (Object)EIndexAccessMode.READ_ONLY);
            AnalysisStepIndexAccessBase writeAccess = (AnalysisStepIndexAccessBase)seenAccesses.getValue((Object)indexName, (Object)EIndexAccessMode.READ_WRITE);
            if (readAccess == null || writeAccess == null) continue;
            throw new TriggerCompilationException("Had read and write index access at the same time for index " + String.valueOf(indexName) + " in class " + String.valueOf(this.analysisStepClass) + ": " + String.valueOf(readAccess) + " and " + String.valueOf(writeAccess));
        }
    }

    private void validateDeltaSources() throws TriggerCompilationException {
        HashMap seenSources = new HashMap();
        for (AnalysisStepDeltaSource<?> source : this.deltaSources) {
            if (seenSources.containsKey(source.getIndexName())) {
                throw new TriggerCompilationException("Had duplicate delta source for index " + String.valueOf(source.getIndexName()) + " in class " + String.valueOf(this.analysisStepClass) + ": " + String.valueOf(seenSources.get(source.getIndexName())) + " and " + String.valueOf(source));
            }
            seenSources.put(source.getIndexName(), source);
        }
    }

    private void validateBlockParameters() throws TriggerCompilationException {
        HashMap<String, AnalysisStepParameter> seenParameters = new HashMap<String, AnalysisStepParameter>();
        for (AnalysisStepParameter parameter : this.analysisStepParameters) {
            if (seenParameters.containsKey(parameter.getName())) {
                String existingParameterType;
                String duplicateParameterMessage = "Had duplicate block parameter with name " + parameter.getName() + " in class " + String.valueOf(this.analysisStepClass) + ": " + String.valueOf(seenParameters.get(parameter.getName())) + " and " + String.valueOf(parameter);
                String currentParameterType = parameter.getField().getGenericType().getTypeName();
                if (!currentParameterType.equals(existingParameterType = ((AnalysisStepParameter)seenParameters.get(parameter.getName())).getField().getGenericType().getTypeName())) {
                    throw new TriggerCompilationException(duplicateParameterMessage);
                }
                LOGGER.info("{}. Since both parameters have the same type, the same value will be reused.", (Object)duplicateParameterMessage);
            }
            seenParameters.put(parameter.getName(), parameter);
        }
    }

    public Map<EIndexAccessMode, List<AnalysisStepProjectIndexAccess<?>>> getIndexAccesses() {
        return this.indexAccesses;
    }

    public Map<EIndexAccessMode, List<AnalysisStepGlobalIndexAccess>> getGlobalIndexAccesses() {
        return this.globalIndexAccesses;
    }

    public List<AnalysisStepBranchingLayerAccess> getBranchingLayerAccesses() {
        return this.branchingLayerAccesses;
    }

    public List<AnalysisStepDeltaSource<?>> getDeltaSources() {
        return this.deltaSources;
    }

    public List<AnalysisStepParameter> getAnalysisStepParameters() {
        return this.analysisStepParameters;
    }

    public List<AnalysisStepPostInjectionMethod> getPostInjectionMethods() {
        return this.postInjectionMethods;
    }

    public String getFullAnalysisStepClassName() {
        return this.analysisStepClass.getName();
    }

    public Optional<AnalysisStep> getSchedulingHints() {
        return Optional.ofNullable(this.analysisStepClass.getAnnotation(AnalysisStep.class));
    }

    public boolean isPreAnnouncingAnalysisStep() {
        return IPreAnnouncingAnalysisStep.class.isAssignableFrom(this.analysisStepClass);
    }
}

