/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.trigger;

import com.teamscale.core.analysis.AnalysisStep;
import org.conqat.engine.core.core.ConQATException;

public final class ConcurrentSchedulingLimit {
    private final int limit;

    private ConcurrentSchedulingLimit(int limit) {
        this.limit = limit;
    }

    public static ConcurrentSchedulingLimit of(AnalysisStep analysisStep) throws ConQATException {
        AnalysisStep.ConcurrencyLimit configuredLimit = analysisStep.concurrencyLimit();
        int limit = Integer.getInteger(configuredLimit.maxConcurrencyProperty(), configuredLimit.maxConcurrency());
        if (limit == 0) {
            throw new ConQATException("No limit configured for property %s".formatted(configuredLimit.maxConcurrencyProperty()));
        }
        return new ConcurrentSchedulingLimit(limit);
    }

    public int getLimit() {
        return this.limit;
    }
}

