/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.rollback;

import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.precommit.PreCommitUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="rollback-log", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED}, valueClasses={RollbackLogEntry.class})
public class RollbackLogIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "rollback-log";
    private static final String WRITE_LOCK_NAME = "insert-lock";

    public RollbackLogIndex(IStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEntry(RollbackLogEntry entry) throws StorageException {
        Lock lock = this.store.obtainLock(WRITE_LOCK_NAME);
        lock.lock();
        try {
            long time = System.currentTimeMillis();
            while (this.store.get(ByteArrayUtils.longToByteArray((long)time)) != null) {
                ++time;
            }
            this.store.put(ByteArrayUtils.longToByteArray((long)time), StorageUtils.serialize((Serializable)entry));
        }
        finally {
            lock.unlock();
        }
    }

    public List<RollbackLogEntry> getAllEntries() throws StorageException {
        PairList keysValues = new PairList();
        KeyValueCollectingCallback callback = new KeyValueCollectingCallback(keysValues);
        this.store.scan(new byte[0], (IKeyValueCallback)callback);
        return CollectionUtils.mapWithException((Collection)keysValues.getSecondList(), StorageUtils::deserialize);
    }

    @IndexValueClass
    public static class RollbackLogEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int affectedBranchCount;
        private final long timestamp;
        private final List<String> affectedBranches;
        private final double executionTimeSeconds;
        private final CounterSet<ECommitTreeNodeState> rolledBackStateCount;
        private final long minimalTimestamp;
        private final UUID rollbackId;

        public RollbackLogEntry(Collection<String> affectedBranches, CounterSet<ECommitTreeNodeState> rolledBackStateCount, long minimalTimestamp, double executionTimeSeconds, UUID rollbackId) {
            this.rollbackId = rollbackId;
            this.timestamp = System.currentTimeMillis();
            this.affectedBranchCount = affectedBranches.size();
            this.affectedBranches = affectedBranches.stream().limit(50L).collect(Collectors.toList());
            this.rolledBackStateCount = rolledBackStateCount;
            this.minimalTimestamp = minimalTimestamp;
            this.executionTimeSeconds = executionTimeSeconds;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getMinimalTimestamp() {
            return this.minimalTimestamp;
        }

        public double getExecutionTimeSeconds() {
            return this.executionTimeSeconds;
        }

        public int getAffectedBranchCount() {
            return this.affectedBranchCount;
        }

        public List<String> getAffectedBranches() {
            return this.affectedBranches;
        }

        public CounterSet<ECommitTreeNodeState> getRolledBackStateCount() {
            return this.rolledBackStateCount;
        }

        public UUID getRollbackId() {
            return this.rollbackId;
        }

        public boolean isPrecommitRollback() {
            return this.affectedBranchCount == 1 && PreCommitUtils.isPrecommitBranch(this.affectedBranches.get(0));
        }
    }
}

