/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import com.teamscale.core.runtime.impl.analysis.trigger.ConcurrentSchedulingLimit;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.CommitDescriptorMerger;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.PredecessorCommitFinder;
import com.teamscale.core.runtime.impl.scheduling.RateLimitingSupport;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class BestAssignableJobFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    protected static final String PENDING_WRITE_CONFLICT_ERROR_MESSAGE = "Not schedulable due to pending writes";
    @VisibleForTesting
    protected static String MAINTENANCE_CONFLICT_ERROR_MESSAGE = "Not schedulable due to maintenance concurrency conflict";
    private static final int PER_BRANCH_COMMIT_LIMIT = Integer.getInteger("com.teamscale.scheduler.per-branch-commit-limit", 10);
    private static final int OVERALL_COMMIT_LIMIT = Integer.getInteger("com.teamscale.scheduler.overall-commit-limit", 100);
    private final AssignedJobs assignedJobs;
    private final SupplierWithException<Collection<JobDescriptor>, StorageException> overallAssignedJobs;
    private final JobQueue jobQueue;
    private final TriggerCache triggerCache;
    private final RateLimitingSupport rateLimitingSupport;
    private final SetMap<CommitDescriptor, String> currentlyWrittenStores = new SetMap();
    private final SetMap<CommitDescriptor, String> currentlyWrittenIsolatedStores = new SetMap();
    private final Map<@Nullable CommitDescriptor, Set<String>> transitiveWriteSetByCommitCache = new HashMap<CommitDescriptor, Set<String>>();
    private final Map<@Nullable CommitDescriptor, Set<String>> transitiveWriteBlockingReadSetByCommitCache = new HashMap<CommitDescriptor, Set<String>>();
    private final Set<String> usedCrossCommitWriteBlockingStores = new HashSet<String>();
    private Consumer<String> traceWriter;
    private final PredecessorCommitFinder predecessorCommitFinder;

    public BestAssignableJobFinder(AssignedJobs assignedJobs, JobQueue jobQueue, TriggerCache triggerCache, @Nullable CommitDescriptorIndex commitDescriptorIndex, boolean onlyPrivileged, SupplierWithException<Collection<JobDescriptor>, StorageException> overallAssignedJobs) throws TriggerCompilationException, StorageException {
        this.assignedJobs = assignedJobs;
        this.overallAssignedJobs = overallAssignedJobs;
        this.jobQueue = onlyPrivileged ? BestAssignableJobFinder.filterToPrivileged(jobQueue) : jobQueue;
        for (ScheduledJob job : jobQueue.getAllJobs()) {
            if (triggerCache == null || !triggerCache.findTrigger(job.getJob()).isEmpty()) continue;
            LOGGER.error("Had to remove job because it was not found in the trigger cache: {}", (Object)job);
            jobQueue.removeJob(job);
        }
        this.triggerCache = triggerCache;
        this.rateLimitingSupport = jobQueue.getRateLimitingSupport();
        this.predecessorCommitFinder = new PredecessorCommitFinder(jobQueue, assignedJobs, commitDescriptorIndex);
        this.fillCurrentlyWrittenStores();
    }

    public void setTraceWriter(Consumer<String> traceWriter) {
        this.traceWriter = traceWriter;
    }

    private static JobQueue filterToPrivileged(JobQueue jobQueue) throws StorageException {
        List contained = CollectionUtils.filter(jobQueue.getAllJobs(), job -> job.getJob().getTriggerType() == ETriggerType.PRIVILEGED);
        return jobQueue.createFilteredView(contained);
    }

    private void fillCurrentlyWrittenStores() throws TriggerCompilationException {
        for (ScheduledJob job : this.assignedJobs.getAllJobs()) {
            ITrigger trigger = this.triggerCache.getTrigger(job);
            this.currentlyWrittenStores.addAll((Object)job.getSchedulingCommitDescriptor(), trigger.getWriteStores());
            if (trigger.getConcurrency() != ETriggerConcurrency.PARALLEL) {
                this.currentlyWrittenIsolatedStores.addAll((Object)job.getSchedulingCommitDescriptor(), trigger.getWriteStores());
            }
            this.usedCrossCommitWriteBlockingStores.addAll(trigger.getCrossCommitBlockingWriteStores());
        }
    }

    private Set<String> getTransitiveWriteSetByCommit(@Nullable CommitDescriptor commit) throws TriggerCompilationException {
        return this.getStoreSetCached(commit, this.transitiveWriteSetByCommitCache, ITrigger::getTransitiveWriteStores);
    }

    private Set<String> getTransitiveWriteBlockingReadSetByCommit(@Nullable CommitDescriptor commit) throws TriggerCompilationException {
        return this.getStoreSetCached(commit, this.transitiveWriteBlockingReadSetByCommitCache, ITrigger::getTransitiveWriteBlockingReadStores);
    }

    private Set<String> getStoreSetCached(CommitDescriptor commit, Map<@Nullable CommitDescriptor, Set<String>> cache, Function<ITrigger, Set<String>> triggerToStoreResolver) throws TriggerCompilationException {
        Set<String> result = cache.get(commit);
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        for (ScheduledJob job : this.jobQueue.getJobsForCommit(commit)) {
            result.addAll((Collection<String>)triggerToStoreResolver.apply(this.triggerCache.getTrigger(job)));
        }
        for (ScheduledJob job : this.assignedJobs.getJobsForCommit(commit)) {
            result.addAll((Collection<String>)triggerToStoreResolver.apply(this.triggerCache.getTrigger(job)));
        }
        cache.put(commit, result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScheduledJob findBestAssignableJob() throws TriggerCompilationException, StorageException {
        Object object;
        Object rejectionReasons;
        int n;
        IJobFinderResult iJobFinderResult;
        IJobFinderResult result;
        LOGGER.traceEntry("Try to find best assignable job", new org.apache.logging.log4j.util.Supplier[0]);
        this.writeTrace(() -> "Job queue:\n%s\n".formatted(this.jobQueue));
        this.writeTrace(() -> "Assigned jobs:\n%s\n".formatted(this.assignedJobs));
        if (this.isFullyIsolatedJobRunning()) {
            this.writeTrace("No job, as fully isolated job is running");
            return (ScheduledJob)LOGGER.traceExit("Found no job", null);
        }
        List<ScheduledJob> precommitRollbackJobs = this.listPrecommitRollbackJobs();
        if (!precommitRollbackJobs.isEmpty()) {
            this.writeTrace("Early exit, as pre-commit rollback was found");
            return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)BestAssignableJobFinder.pickEarliest(precommitRollbackJobs));
        }
        List<ScheduledJob> allFullyIsolatedJobs = this.listFullyIsolatedJobs();
        if (!allFullyIsolatedJobs.isEmpty()) {
            if (this.assignedJobs.isEmpty()) {
                this.writeTrace("Early exit, as fully isolated jobs are pending and no jobs are assigned");
                return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)BestAssignableJobFinder.pickEarliest(allFullyIsolatedJobs));
            }
            this.writeTrace("Early exit, as fully isolated pre-commit jobs are pending");
            return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)this.findFullyIsolatedPreCommitJob());
        }
        if (this.isRollbackRunningForNonPreCommitBranch()) {
            this.writeTrace("Early exit, as rollback is running for non-precommit branch is running");
            LOGGER.traceExit((Object)"Found no job");
            return null;
        }
        if (this.jobQueue.existsJobForCommit(null)) {
            this.writeTrace("Jobs without scheduling commit are pending and are preferred. No other jobs are considered.");
            IJobFinderResult iJobFinderResult2 = result = this.findBestAssignableJob(null);
            Objects.requireNonNull(iJobFinderResult2);
            iJobFinderResult = iJobFinderResult2;
            n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IJobFinderResult.Success.class, IJobFinderResult.NoJobAvailable.class}, (IJobFinderResult)iJobFinderResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    IJobFinderResult.Success success = (IJobFinderResult.Success)iJobFinderResult;
                    try {
                        ScheduledJob scheduledJob;
                        ScheduledJob job = scheduledJob = success.job();
                        return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)job);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: 
            }
            rejectionReasons = (IJobFinderResult.NoJobAvailable)iJobFinderResult;
            if (!((IJobFinderResult.NoJobAvailable)rejectionReasons).allWaitingForReschedule()) {
                LOGGER.traceExit((Object)"Found no job");
                return null;
            }
        }
        if (!this.jobQueue.existsJobForCommit(RollbackRequest.ROLLBACK_REQUESTED_COMMIT)) return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)this.findBestNormalAssignableJob());
        this.writeTrace("Jobs for ROLLBACK_REQUESTED_COMMIT are pending and are preferred. No other jobs are considered.");
        IJobFinderResult iJobFinderResult3 = result = this.findBestAssignableJob(RollbackRequest.ROLLBACK_REQUESTED_COMMIT);
        Objects.requireNonNull(iJobFinderResult3);
        iJobFinderResult = iJobFinderResult3;
        n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IJobFinderResult.Success.class, IJobFinderResult.NoJobAvailable.class}, (IJobFinderResult)iJobFinderResult, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                IJobFinderResult.Success success = (IJobFinderResult.Success)iJobFinderResult;
                {
                    Object job;
                    object = job = (rejectionReasons = success.job());
                    return (ScheduledJob)LOGGER.traceExit("Found job: {}", object);
                }
            }
            case 1: 
        }
        IJobFinderResult.NoJobAvailable ignored = (IJobFinderResult.NoJobAvailable)iJobFinderResult;
        object = null;
        return (ScheduledJob)LOGGER.traceExit("Found job: {}", object);
    }

    private ScheduledJob findFullyIsolatedPreCommitJob() throws TriggerCompilationException {
        List preCommitCommits = CollectionUtils.filter(this.jobQueue.getAllNonNullSchedulingCommits(), PreCommitUtils::isPrecommitCommit);
        for (CommitDescriptor commit : preCommitCommits) {
            for (ScheduledJob job : this.jobQueue.getJobsForCommit(commit)) {
                if (this.triggerCache.getTrigger(job).getConcurrency() != ETriggerConcurrency.PRIORITY_FULLY_ISOLATED) continue;
                return job;
            }
        }
        return null;
    }

    private static ScheduledJob pickEarliest(List<ScheduledJob> jobs) {
        return Collections.min(jobs, Comparator.comparing(ScheduledJob::getSchedulingCommitDescriptor, Comparator.nullsFirst(Comparator.naturalOrder())));
    }

    private List<ScheduledJob> listPrecommitRollbackJobs() {
        return this.queuedRollbackJobs().filter(job -> PreCommitUtils.isPrecommitJob(job.getJob())).collect(Collectors.toList());
    }

    private List<ScheduledJob> listFullyIsolatedJobs() throws TriggerCompilationException {
        ArrayList<ScheduledJob> result = new ArrayList<ScheduledJob>();
        for (ScheduledJob job : this.jobQueue.getOneJobForEachTrigger()) {
            if (this.triggerCache.getTrigger(job).getConcurrency() != ETriggerConcurrency.PRIORITY_FULLY_ISOLATED) continue;
            result.addAll(this.jobQueue.getJobsForTrigger(job.getTriggerName()));
        }
        return result;
    }

    private boolean isRollbackRunningForNonPreCommitBranch() {
        return this.runningRollbackJobs().anyMatch(scheduledJob -> !PreCommitUtils.isPrecommitJob(scheduledJob.getJob()));
    }

    private boolean isRollbackRunningOrQueuedForAnyPreCommitBranch() {
        return this.queuedAndRunningRollbackJobs().anyMatch(scheduledJob -> PreCommitUtils.isPrecommitJob(scheduledJob.getJob()));
    }

    private Stream<ScheduledJob> runningRollbackJobs() {
        return this.assignedJobs.getJobsForTrigger(RollbackTrigger.class.getName()).stream();
    }

    private Stream<ScheduledJob> queuedAndRunningRollbackJobs() {
        Stream<ScheduledJob> queued = this.queuedRollbackJobs();
        return Stream.concat(this.runningRollbackJobs(), queued);
    }

    private Stream<ScheduledJob> queuedRollbackJobs() {
        return this.jobQueue.getJobsForTrigger(RollbackTrigger.class.getName()).stream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScheduledJob findBestNormalAssignableJob() throws TriggerCompilationException, StorageException {
        LOGGER.traceEntry("Try to find best normal assignable job", new org.apache.logging.log4j.util.Supplier[0]);
        int count = 0;
        CounterSet commitsPerBranch = new CounterSet();
        HashSet<String> blockedByRollbackBranches = new HashSet<String>();
        for (CommitDescriptor commit : this.jobQueue.getOrderedCommits()) {
            this.writeTrace("Considering scheduling commit {}", commit);
            if (commit == null || commitsPerBranch.inc((Object)commit.getBranchName()) > PER_BRANCH_COMMIT_LIMIT || blockedByRollbackBranches.contains(commit.getBranchName())) {
                this.writeTrace("Done with branch, as too many commits are pending or rollbacks are pending");
                continue;
            }
            IJobFinderResult result = this.findBestAssignableJob(commit);
            if (result instanceof IJobFinderResult.Success) {
                IJobFinderResult.Success success = (IJobFinderResult.Success)result;
                try {
                    ScheduledJob scheduledJob;
                    ScheduledJob job = scheduledJob = success.job();
                    return (ScheduledJob)LOGGER.traceExit("Found job: {}", (Object)job);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            if (this.isRollbackInQueueForCommit(commit)) {
                this.writeTrace("Marking branch as blocked by rollback: {}", commit.getBranchName());
                blockedByRollbackBranches.add(commit.getBranchName());
                continue;
            }
            if (++count <= OVERALL_COMMIT_LIMIT) continue;
        }
        if ((this.traceWriter != null || LOGGER.isTraceEnabled()) && !this.jobQueue.isEmpty()) {
            this.writeTrace("Unable to find normal job to assign.\nJob Queue size: {}\nOrdered commits size: {}\n", this.jobQueue.size(), this.jobQueue.getOrderedCommits().size());
            if (this.jobQueue.getOrderedCommits().stream().map(this.jobQueue::getJobsForCommit).mapToInt(Collection::size).sum() != this.jobQueue.size()) {
                this.writeTrace("Inconsistent job queue!\nJobQueue: {}\nOrdered commits: {}\n", this.jobQueue.getAllJobs(), this.jobQueue.getOrderedCommits());
            }
        }
        LOGGER.traceExit((Object)"Found no normal job");
        return null;
    }

    private boolean isRollbackInQueueForCommit(CommitDescriptor commit) {
        return CollectionUtils.anyMatch(this.jobQueue.getJobsForCommit(commit), job -> RollbackTrigger.class.getName().equals(job.getTriggerName()));
    }

    private boolean isFullyIsolatedJobRunning() throws TriggerCompilationException {
        for (ScheduledJob job : this.assignedJobs.getAllJobs()) {
            if (this.triggerCache.getTrigger(job).getConcurrency() != ETriggerConcurrency.PRIORITY_FULLY_ISOLATED) continue;
            return true;
        }
        return false;
    }

    private IJobFinderResult findBestAssignableJob(CommitDescriptor commit) throws TriggerCompilationException, StorageException {
        LOGGER.traceEntry("Try to find best assignable job for commit: {}", new Object[]{commit});
        Set<ScheduledJob> assignableJobs = this.jobQueue.getJobsForCommit(commit);
        int maxExecutionOrder = Integer.MAX_VALUE;
        for (ScheduledJob job : this.assignedJobs.getJobsForCommit(commit)) {
            maxExecutionOrder = Math.min(maxExecutionOrder, this.triggerCache.getTrigger(job).getExecutionOrderIndex());
        }
        this.writeTrace("Only considering jobs with execution order {}", maxExecutionOrder);
        LinkedHashMap<ScheduledJob, ESchedulingEvaluationResult> rejections = new LinkedHashMap<ScheduledJob, ESchedulingEvaluationResult>();
        for (ScheduledJob job : this.getBestExecutionOrderJobs(assignableJobs, maxExecutionOrder)) {
            this.writeTrace("Considering job {}", job);
            ESchedulingEvaluationResult schedulingEvaluationResult = this.canBeScheduled(job);
            if (schedulingEvaluationResult.canBeScheduled()) {
                return (IJobFinderResult)LOGGER.traceExit("Found job {}", (Object)new IJobFinderResult.Success(job));
            }
            rejections.put(job, schedulingEvaluationResult);
        }
        LOGGER.traceExit((Object)"Found no job");
        return new IJobFinderResult.NoJobAvailable(rejections);
    }

    private Collection<ScheduledJob> getBestExecutionOrderJobs(Collection<ScheduledJob> jobs, int maxExecutionOrder) throws TriggerCompilationException {
        int bestExecutionOrderIndex = maxExecutionOrder;
        PairList jobCandidates = new PairList();
        for (ScheduledJob job : jobs) {
            ITrigger trigger = this.triggerCache.getTrigger(job);
            int executionOrderIndex = trigger.getExecutionOrderIndex();
            if (executionOrderIndex < bestExecutionOrderIndex) {
                bestExecutionOrderIndex = executionOrderIndex;
                jobCandidates.clear();
            }
            if (executionOrderIndex != bestExecutionOrderIndex) continue;
            jobCandidates.add((Object)job, (Object)trigger.getPriority());
        }
        CollectionUtils.sortBySecond((PairList)jobCandidates, Comparator.reverseOrder());
        return jobCandidates.getFirstList();
    }

    private ESchedulingEvaluationResult canBeScheduled(ScheduledJob job) throws TriggerCompilationException, StorageException {
        boolean isRegularJob;
        LOGGER.traceEntry("Trying to schedule job {}", new Object[]{job});
        if (job.getEarliestScheduleTimestamp() > DateTimeUtils.millisNow()) {
            this.writeTrace("Execution blocked by trigger until {}", job.getEarliestScheduleTimestamp());
            return ESchedulingEvaluationResult.BLOCKED_BY_EARLIEST_SCHEDULE_TIMESTAMP;
        }
        if (this.isBlockedByRateLimiting(job)) {
            this.writeTrace("Not schedulable due to rate limiting");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_RATE_LIMITING));
        }
        ITrigger trigger = this.triggerCache.getTrigger(job);
        if (this.isInRollbackConflict(job, trigger)) {
            this.writeTrace("Not schedulable due to rollback conflict");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_ROLLBACK));
        }
        if (this.isInIsolationConflict(job, trigger)) {
            this.writeTrace("Not schedulable due to isolation conflict");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_ISOLATION));
        }
        if (this.isInMaintenanceConcurrencyConflict(job, trigger)) {
            this.writeTrace(MAINTENANCE_CONFLICT_ERROR_MESSAGE);
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_MAINTENANCE_CONCURRENCY));
        }
        if (this.isBlockedByPrecommitRollbackJob(job)) {
            this.writeTrace("Not schedulable due to pending precommit rollback");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_PRECOMMIT_ROLLBACK));
        }
        if (this.isBlockedByCrossCommitWrites(trigger)) {
            this.writeTrace("Not schedulable due to cross-commit write blocks");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_CROSS_COMMIT_WRITES));
        }
        if (this.isSchedulingCommitBlocked(job)) {
            this.writeTrace("Not schedulable due to scheduling commit block");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_SCHEDULING_COMMIT));
        }
        if (this.isBlockedByMaxConcurrentExecutions(job, trigger)) {
            this.writeTrace("Not schedulable due to maximum concurrent executions");
            return ESchedulingEvaluationResult.BLOCKED_BY_MAX_CONCURRENT_EXECUTIONS;
        }
        ISchedulingCommit schedulingCommit = job.getSchedulingCommit();
        boolean bl = isRegularJob = schedulingCommit != null;
        if (isRegularJob && this.isBlockedByIsolatedStores(job, trigger)) {
            this.writeTrace("Not schedulable due to currently written isolated stores");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_ISOLATED_STORES));
        }
        if (isRegularJob && this.isBlockedByOutputIsolatedPendingWrites(job, trigger)) {
            this.writeTrace("Not schedulable due to output isolation (and other pending writes)");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_PENDING_WRITES));
        }
        if (this.isBlockedByPendingWritesOnSameCommit(trigger, schedulingCommit)) {
            this.writeTrace("Not schedulable as inputs are still potentially written to");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_PENDING_WRITES));
        }
        if (this.isBlockedByPendingWrites(trigger, schedulingCommit)) {
            this.writeTrace(PENDING_WRITE_CONFLICT_ERROR_MESSAGE);
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_PENDING_WRITES));
        }
        if (this.isBlockedByPendingTransitiveReads(trigger, schedulingCommit)) {
            this.writeTrace("Not schedulable due to pending transitive reads");
            return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.BLOCKED_BY_PENDING_TRANSITIVE_READS));
        }
        return (ESchedulingEvaluationResult)((Object)LOGGER.traceExit("Can be scheduled: {}", (Object)ESchedulingEvaluationResult.CAN_BE_SCHEDULED));
    }

    private boolean isBlockedByIsolatedStores(ScheduledJob job, ITrigger trigger) {
        if (BestAssignableJobFinder.hasWriteOverlap(this.currentlyWrittenIsolatedStores, job, trigger)) {
            this.writeTrace(() -> "Is blocked by isolated stores: %s".formatted(BestAssignableJobFinder.getWriteOverlap(this.currentlyWrittenIsolatedStores, job, trigger)));
            return true;
        }
        return false;
    }

    private boolean isBlockedByOutputIsolatedPendingWrites(ScheduledJob job, ITrigger trigger) {
        if (trigger.getConcurrency() != ETriggerConcurrency.OUTPUT_ISOLATED) {
            return false;
        }
        if (BestAssignableJobFinder.hasWriteOverlap(this.currentlyWrittenStores, job, trigger)) {
            this.writeTrace(() -> "Is blocked by output isolated stores: %s".formatted(BestAssignableJobFinder.getWriteOverlap(this.currentlyWrittenStores, job, trigger)));
            return true;
        }
        return false;
    }

    private boolean isBlockedByPendingWritesOnSameCommit(ITrigger trigger, @Nullable ISchedulingCommit commit) throws TriggerCompilationException {
        Set<String> writeSet = this.getTransitiveWriteSetByCommit(ISchedulingCommit.getCommit(commit));
        if (CollectionUtils.containsAnyBut(writeSet, trigger.getReadStores(), trigger.getWriteStores())) {
            this.writeTrace(() -> {
                HashSet overlap = new HashSet(writeSet);
                overlap.removeAll(trigger.getWriteStores());
                overlap.retainAll(trigger.getReadStores());
                return "Is blocked by pending writes on same commit into input stores: %s".formatted(overlap);
            });
            return true;
        }
        return false;
    }

    private boolean isBlockedByCrossCommitWrites(ITrigger trigger) {
        if (CollectionUtils.containsAny(this.usedCrossCommitWriteBlockingStores, trigger.getCrossCommitBlockingWriteStores())) {
            this.writeTrace(() -> "Is blocked by cross-commit blocking stores: %s".formatted(CollectionUtils.intersectionSet(this.usedCrossCommitWriteBlockingStores, (Collection[])new Collection[]{trigger.getCrossCommitBlockingWriteStores()})));
            return true;
        }
        return false;
    }

    private boolean isBlockedByMaxConcurrentExecutions(ScheduledJob job, ITrigger trigger) throws StorageException {
        if (job.getSchedulingCommit() == null) {
            return false;
        }
        int limit = trigger.getConcurrentSchedulingLimit().map(ConcurrentSchedulingLimit::getLimit).orElse(-1);
        if (limit < 0) {
            return false;
        }
        String prefixedTriggerName = TriggerBuilder.buildTriggerName("", TriggerBuilder.getSimpleTriggerName(trigger.getAnalysisStepClass()));
        Predicate<String> isSameTrigger = triggerName -> triggerName.equals(job.getTriggerName()) || triggerName.endsWith(prefixedTriggerName);
        int alreadyAssignedJobCount = (int)((Collection)this.overallAssignedJobs.get()).stream().map(JobDescriptor::getTriggerName).filter(isSameTrigger).count();
        return alreadyAssignedJobCount >= limit;
    }

    private boolean isBlockedByRateLimiting(ScheduledJob job) {
        RateLimitableResource remoteResource = job.getJob().getRemoteResource();
        if (remoteResource == null) {
            return false;
        }
        return this.rateLimitingSupport.isRateLimited(remoteResource);
    }

    private static boolean hasWriteOverlap(SetMap<CommitDescriptor, String> writtenStoresByCommit, ScheduledJob job, ITrigger trigger) {
        Set writtenStores = (Set)writtenStoresByCommit.getCollection((Object)job.getSchedulingCommitDescriptor());
        if (writtenStores == null || writtenStores.isEmpty()) {
            return false;
        }
        return CollectionUtils.containsAny((Set)writtenStores, trigger.getWriteStores());
    }

    private static Set<String> getWriteOverlap(SetMap<CommitDescriptor, String> writtenStoresByCommit, ScheduledJob job, ITrigger trigger) {
        Set writtenStores = (Set)writtenStoresByCommit.getCollection((Object)job.getSchedulingCommitDescriptor());
        if (writtenStores == null || writtenStores.isEmpty()) {
            return Collections.emptySet();
        }
        return CollectionUtils.intersectionSet((Collection)writtenStores, (Collection[])new Collection[]{trigger.getWriteStores()});
    }

    private boolean isSchedulingCommitBlocked(ScheduledJob job) throws TriggerCompilationException, StorageException {
        ISchedulingCommit schedulingCommit = job.getSchedulingCommit();
        if (schedulingCommit == null) {
            return false;
        }
        return this.isBlockedByAssignedParentCandidates(schedulingCommit) || this.isBlockedByPreAnnouncement(job);
    }

    private boolean isBlockedByAssignedParentCandidates(ISchedulingCommit schedulingCommit) throws StorageException {
        EntryMessage entryMessage = LOGGER.traceEntry("isBlockedByAssignedParentCandidates(schedulingCommit={})", new Object[]{schedulingCommit});
        for (CommitDescriptor parentCommit : this.predecessorCommitFinder.getParentedCommit(schedulingCommit).getParentCommits()) {
            for (ScheduledJob assignedJob : this.assignedJobs.getAllJobs()) {
                long offset;
                CommitDescriptor assignedCommit = assignedJob.getSchedulingCommitDescriptor();
                if (assignedCommit == null || !assignedCommit.isOnSameBranchAs(schedulingCommit.commit()) || assignedCommit.getTimestamp() < parentCommit.getTimestamp() || assignedCommit.getTimestamp() >= schedulingCommit.commit().getTimestamp() || !CommitDescriptorMerger.isInMergeWindow(offset = assignedCommit.getTimestamp() - parentCommit.getTimestamp())) continue;
                this.writeTrace(() -> "Blocked by schedulingCommit %s in merge window for parent %s".formatted(assignedCommit, parentCommit));
                return (Boolean)LOGGER.traceExit(entryMessage, (Object)true);
            }
        }
        return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
    }

    private boolean isBlockedByPrecommitRollbackJob(ScheduledJob job) {
        if (PreCommitUtils.isPrecommitChangeRetriever(job.getTriggerName())) {
            return this.isRollbackRunningOrQueuedForAnyPreCommitBranch();
        }
        return this.isBlockingRollbackRunningForSamePreCommitBranch(job);
    }

    private boolean isBlockingRollbackRunningForSamePreCommitBranch(ScheduledJob job) {
        CommitDescriptor schedulingCommit = job.getSchedulingCommitDescriptor();
        if (schedulingCommit == null || !PreCommitUtils.isPrecommitBranch(schedulingCommit.getBranchName())) {
            return false;
        }
        return this.runningRollbackJobs().anyMatch(rollbackJob -> {
            CommitDescriptor rollbackCommit = rollbackJob.getSchedulingCommitDescriptor();
            if (rollbackCommit == null) {
                LOGGER.error("Encountered unexpected rollback job with no rollback commit: {}", (Object)job);
                return false;
            }
            if (!PreCommitUtils.isPrecommitCommit(rollbackCommit)) {
                LOGGER.error("Encountered rollback job for non-precommit branch at unexpected scheduler phase: {}", (Object)job);
                return false;
            }
            if (!schedulingCommit.isOnSameBranchAs(rollbackCommit)) {
                return false;
            }
            return schedulingCommit.getTimestamp() > rollbackCommit.getTimestamp();
        });
    }

    private boolean isBlockedByPreAnnouncement(ScheduledJob job) throws TriggerCompilationException, StorageException {
        EntryMessage entryMessage = LOGGER.traceEntry("isBlockedByPreAnnouncement(job={})", new Object[]{job});
        CommitDescriptor commit = Objects.requireNonNull(job.getSchedulingCommitDescriptor());
        OptionalLong optionalFirstPreAnnouncedTimestamp = this.jobQueue.getFirstBlockingPreAnnouncement(commit);
        if (optionalFirstPreAnnouncedTimestamp.isPresent() && this.isBlockedByPreAnnouncement(job, commit, optionalFirstPreAnnouncedTimestamp.getAsLong())) {
            long timestamp = optionalFirstPreAnnouncedTimestamp.getAsLong();
            this.writeTrace(() -> "Blocked by pre-announcement %d".formatted(timestamp));
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)true);
        }
        for (CommitDescriptor parentCommit : this.predecessorCommitFinder.getParentedCommit(job.getSchedulingCommit()).getParentCommitsOnOtherBranches()) {
            long firstPreAnnouncedTimestamp;
            optionalFirstPreAnnouncedTimestamp = this.jobQueue.getFirstBlockingPreAnnouncement(parentCommit);
            if (optionalFirstPreAnnouncedTimestamp.isEmpty() || this.isBlockedByPreAnnouncement(job, parentCommit, firstPreAnnouncedTimestamp = optionalFirstPreAnnouncedTimestamp.getAsLong())) continue;
            long timestampOffset = firstPreAnnouncedTimestamp - parentCommit.getTimestamp();
            if (firstPreAnnouncedTimestamp >= commit.getTimestamp() || !CommitDescriptorMerger.isInMergeWindow(timestampOffset)) continue;
            this.writeTrace(() -> "Blocked by pre-announcement %d in merge window for parent %s".formatted(firstPreAnnouncedTimestamp, parentCommit));
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)true);
        }
        return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
    }

    private boolean isBlockedByPreAnnouncement(ScheduledJob job, CommitDescriptor commit, long firstPreAnnouncedTimestamp) throws TriggerCompilationException {
        long timestamp = commit.getTimestamp();
        if (RollbackTrigger.class.getName().equals(job.getTriggerName())) {
            return timestamp > firstPreAnnouncedTimestamp;
        }
        if (JobQueue.isPreAnnouncingTrigger(this.triggerCache, job)) {
            if (this.jobQueue.isPreAnnouncementCausedByJob(job, commit.getBranchName(), firstPreAnnouncedTimestamp)) {
                return timestamp > firstPreAnnouncedTimestamp;
            }
            return timestamp >= firstPreAnnouncedTimestamp;
        }
        return timestamp >= firstPreAnnouncedTimestamp;
    }

    private boolean isInRollbackConflict(ScheduledJob job, ITrigger trigger) {
        boolean blocked;
        if (trigger.getConcurrency() != ETriggerConcurrency.ROLLBACK_ISOLATED) {
            return false;
        }
        Set<String> preCommitCommits = BestAssignableJobFinder.getPreCommitRollbackCommits(job);
        if (!preCommitCommits.isEmpty()) {
            return this.mayRollbackPreCommitBranch(preCommitCommits);
        }
        boolean bl = blocked = !this.assignedJobs.isEmpty();
        if (blocked) {
            this.writeTrace("Is blocked by non-empty assigned jobs");
        }
        return blocked;
    }

    private static Set<String> getPreCommitRollbackCommits(ScheduledJob scheduledJob) {
        Collection<CommitDescriptor> rollbackCommits;
        CommitDescriptor schedulingCommit = scheduledJob.getSchedulingCommitDescriptor();
        if (schedulingCommit == null) {
            return Collections.emptySet();
        }
        if (RollbackRequest.ROLLBACK_REQUESTED_COMMIT.equals((Object)schedulingCommit)) {
            try {
                rollbackCommits = scheduledJob.getJob().getParameterObject(RollbackRequest.class).rollbackCommits();
            }
            catch (JsonSerializationException e) {
                throw new IllegalStateException("Rollback trigger scheduled with an incorrect parameter. Should be %s".formatted(RollbackRequest.class.getSimpleName()), e);
            }
        } else {
            rollbackCommits = List.of(schedulingCommit);
        }
        return rollbackCommits.stream().filter(PreCommitUtils::isPrecommitCommit).map(CommitDescriptor::getBranchName).collect(Collectors.toSet());
    }

    private boolean mayRollbackPreCommitBranch(Set<String> rollbackPreCommitCommits) {
        return CollectionUtils.anyMatch(this.assignedJobs.getAllJobs(), assigned -> {
            if (PreCommitUtils.isPrecommitChangeRetriever(assigned.getTriggerName())) {
                this.writeTrace(() -> "Is blocked by pre-commit change retriever");
                return true;
            }
            CommitDescriptor assignedSchedulingCommit = assigned.getSchedulingCommitDescriptor();
            if (assignedSchedulingCommit == null) {
                return false;
            }
            boolean blocked = rollbackPreCommitCommits.contains(assignedSchedulingCommit.getBranchName());
            if (blocked) {
                this.writeTrace(() -> "Is blocked by assigned pre-commit job on same branch: " + String.valueOf(assigned));
            }
            return blocked;
        });
    }

    private boolean isBlockedByPendingWrites(ITrigger trigger, @Nullable ISchedulingCommit commit) throws StorageException, TriggerCompilationException {
        for (CommitDescriptor previousCommit : this.getPotentialPredecessorCommits(commit)) {
            Set<String> previousWrittenStores = this.getTransitiveWriteSetByCommit(previousCommit);
            if (!CollectionUtils.containsAnyBut(previousWrittenStores, trigger.getWriteStores(), trigger.getWriteVirtualStores()) && !CollectionUtils.containsAny(previousWrittenStores, trigger.getReadOnlyPreviousStores()) && !CollectionUtils.containsAny(previousWrittenStores, trigger.getReadStores())) continue;
            this.writeTrace(() -> {
                HashSet writeOverlap = new HashSet(previousWrittenStores);
                writeOverlap.retainAll(trigger.getWriteStores());
                writeOverlap.removeAll(trigger.getWriteVirtualStores());
                HashSet readOverlap = new HashSet(previousWrittenStores);
                readOverlap.retainAll(trigger.getReadOnlyPreviousStores());
                return "Is blocked by pending writes in previous commit %s.\nWrite overlap: %s\nRead overlap: %s".formatted(previousCommit, writeOverlap, readOverlap);
            });
            return true;
        }
        return false;
    }

    private boolean isBlockedByPendingTransitiveReads(ITrigger trigger, @Nullable ISchedulingCommit commit) throws StorageException, TriggerCompilationException {
        for (CommitDescriptor previousCommit : this.getPotentialPredecessorCommits(commit)) {
            Set<String> previousWriteBlockingReadStores = this.getTransitiveWriteBlockingReadSetByCommit(previousCommit);
            if (!CollectionUtils.containsAnyBut(previousWriteBlockingReadStores, trigger.getWriteStores(), trigger.getWriteVirtualStores())) continue;
            this.writeTrace(() -> {
                HashSet writeOverlap = new HashSet(previousWriteBlockingReadStores);
                writeOverlap.retainAll(trigger.getWriteStores());
                writeOverlap.removeAll(trigger.getWriteVirtualStores());
                return "Is blocked by pending transitive reads in previous commit %s.\nOverlap: %s".formatted(previousCommit, writeOverlap);
            });
            return true;
        }
        return false;
    }

    private boolean isInIsolationConflict(ScheduledJob isolatedJob, ITrigger trigger) throws TriggerCompilationException {
        if (trigger.getConcurrency() != ETriggerConcurrency.ISOLATED) {
            return false;
        }
        if (isolatedJob.getSchedulingCommit() == null && isolatedJob.getJob().getTriggerType() == ETriggerType.PRIVILEGED) {
            boolean blocked;
            boolean bl = blocked = !this.assignedJobs.isEmpty();
            if (blocked) {
                this.writeTrace("Is blocked by non-empty assigned jobs");
            }
            return blocked;
        }
        for (ScheduledJob assignedJob : this.assignedJobs.getAllJobs()) {
            if (this.triggerCache.getTrigger(assignedJob).getConcurrency() != ETriggerConcurrency.ISOLATED) continue;
            this.writeTrace(() -> "Is blocked by another currently running isolated trigger: %s".formatted(assignedJob));
            return true;
        }
        return false;
    }

    private boolean isInMaintenanceConcurrencyConflict(ScheduledJob maintenanceJob, ITrigger trigger) {
        return switch (trigger.getConcurrency()) {
            case ETriggerConcurrency.MAINTENANCE -> this.assignedJobs.existsJobForTrigger(maintenanceJob.getTriggerName());
            case ETriggerConcurrency.MAINTENANCE_PARALLEL -> BestAssignableJobFinder.isParallelJobWithSchedulingConflict(maintenanceJob, this.assignedJobs, this.triggerCache.getParallelPrivilegedTriggers());
            default -> false;
        };
    }

    private static boolean isParallelJobWithSchedulingConflict(ScheduledJob maintenanceJob, AssignedJobs assignedJobs, List<ITrigger> parallelPrivilegedTriggers) {
        Set assignedParallelJobs = parallelPrivilegedTriggers.stream().map(privilegedTrigger -> assignedJobs.getJobsForTrigger(privilegedTrigger.getAnalysisStepClass().getName())).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        String currentJobParameter = maintenanceJob.getJob().getParameter();
        for (ScheduledJob assignedJob : assignedParallelJobs) {
            String parameter = assignedJob.getJob().getParameter();
            if (parameter == null || !parameter.equals(currentJobParameter)) continue;
            return true;
        }
        return false;
    }

    private List<CommitDescriptor> getPotentialPredecessorCommits(@Nullable ISchedulingCommit commit) throws StorageException {
        return this.predecessorCommitFinder.getPotentialPredecessorCommits(commit);
    }

    private void writeTrace(String text, Object ... params) {
        if (this.traceWriter != null) {
            String result = text;
            for (Object param : params) {
                String replacementString = Matcher.quoteReplacement(String.valueOf(param));
                result = result.replaceFirst("\\{}", replacementString);
            }
            this.traceWriter.accept(result);
        }
        LOGGER.trace(text, params);
    }

    private void writeTrace(String text) {
        if (this.traceWriter != null) {
            this.traceWriter.accept(text);
        }
        LOGGER.trace(text);
    }

    private void writeTrace(Supplier<String> textSupplier) {
        String text = null;
        if (this.traceWriter != null) {
            text = textSupplier.get();
            this.traceWriter.accept(text);
        }
        if (LOGGER.isTraceEnabled()) {
            if (text == null) {
                text = textSupplier.get();
            }
            LOGGER.trace(text);
        }
    }

    private static sealed interface IJobFinderResult {

        public record NoJobAvailable(Map<ScheduledJob, ESchedulingEvaluationResult> rejections) implements IJobFinderResult
        {
            public NoJobAvailable {
                CCSMAssert.isNotNull(rejections, (String)"Rejections must not be null");
            }

            public CounterSet<ESchedulingEvaluationResult> getRejectionCounts() {
                return new CounterSet(this.rejections.values());
            }

            public boolean allWaitingForReschedule() {
                CounterSet<ESchedulingEvaluationResult> rejectionCounts = this.getRejectionCounts();
                return rejectionCounts.getValue((Object)ESchedulingEvaluationResult.BLOCKED_BY_EARLIEST_SCHEDULE_TIMESTAMP) + rejectionCounts.getValue((Object)ESchedulingEvaluationResult.BLOCKED_BY_RATE_LIMITING) == rejectionCounts.getTotal();
            }
        }

        public record Success(ScheduledJob job) implements IJobFinderResult
        {
            public Success {
                CCSMAssert.isNotNull((Object)job, (String)"Job must not be null");
            }
        }
    }

    private static enum ESchedulingEvaluationResult {
        CAN_BE_SCHEDULED,
        BLOCKED_BY_EARLIEST_SCHEDULE_TIMESTAMP,
        BLOCKED_BY_RATE_LIMITING,
        BLOCKED_BY_ROLLBACK,
        BLOCKED_BY_ISOLATION,
        BLOCKED_BY_MAINTENANCE_CONCURRENCY,
        BLOCKED_BY_PRECOMMIT_ROLLBACK,
        BLOCKED_BY_CROSS_COMMIT_WRITES,
        BLOCKED_BY_SCHEDULING_COMMIT,
        BLOCKED_BY_MAX_CONCURRENT_EXECUTIONS,
        BLOCKED_BY_ISOLATED_STORES,
        BLOCKED_BY_PENDING_WRITES,
        BLOCKED_BY_PENDING_TRANSITIVE_READS;


        public boolean canBeScheduled() {
            return this == CAN_BE_SCHEDULED;
        }
    }
}

