/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.scheduling.SchedulingHelper;
import com.teamscale.core.utils.CommitDescriptorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.compare.ComparableUtils;

public class CommitDescriptorMerger {
    private static final Logger LOGGER = LogManager.getLogger();
    static final int PARENT_COMMIT_MERGE_MIN_OFFSET = 10;
    public static final int PARENT_COMMIT_MERGE_MAX_OFFSET = 500;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private final CommitChildrenIndex commitChildrenIndex;
    private final SchedulingHelper schedulingHelper;

    public CommitDescriptorMerger(CommitDescriptorIndex commitDescriptorIndex, CommitChildrenIndex commitChildrenIndex, SchedulingHelper schedulingHelper) {
        this.commitDescriptorIndex = commitDescriptorIndex;
        this.commitChildrenIndex = commitChildrenIndex;
        this.schedulingHelper = schedulingHelper;
    }

    public void storeCommit(ParentedCommitDescriptor commit, boolean commitsNeedParentAdjustmentForPreviouslyForkedCommits) throws StorageException {
        List<ParentedCommitDescriptor> existingCommits = this.commitDescriptorIndex.getCommitsForBranch(commit.getBranchName());
        int index = Collections.binarySearch(existingCommits, commit, Comparator.comparing(ParentedCommitDescriptor::getCommit));
        if (index >= 0) {
            this.handlePotentialCommitMerge(commit, existingCommits.get(index));
            return;
        }
        if ((index = -index - 1) == 0) {
            commit = CommitDescriptorMerger.adjustParents(commit, this.commitDescriptorIndex, false);
        } else {
            commit = CommitDescriptorMerger.adjustParent(commit, existingCommits.get(index - 1).getCommit(), this.commitDescriptorIndex);
            commit = CommitDescriptorMerger.adjustParents(commit, this.commitDescriptorIndex, true);
        }
        this.commitDescriptorIndex.insertCommit(commit);
        if (index < existingCommits.size()) {
            ParentedCommitDescriptor adjustedCommit = CommitDescriptorMerger.adjustParent(existingCommits.get(index), commit.getCommit(), this.commitDescriptorIndex);
            this.commitDescriptorIndex.insertCommit(adjustedCommit);
            this.commitChildrenIndex.insertAsChildForParents(adjustedCommit);
        } else {
            this.commitChildrenIndex.insertAsChildForParents(commit);
        }
        this.checkForMergeRollback(commit, this.commitDescriptorIndex);
        if (commitsNeedParentAdjustmentForPreviouslyForkedCommits) {
            this.checkForExternalUploadAdjustmentRollback(commit, this.commitDescriptorIndex);
        }
    }

    private void checkForExternalUploadAdjustmentRollback(ParentedCommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        Optional<ParentedCommitDescriptor> possibleCodeCommit = CommitDescriptorUtils.guessCorrespondingCodeCommit(commit.getCommit(), commitDescriptorIndex);
        if (possibleCodeCommit.isEmpty()) {
            return;
        }
        if (possibleCodeCommit.get().getTimestamp() < commit.getTimestamp() - 500L) {
            return;
        }
        ArrayList<ParentedCommitDescriptor> parentsThatMightNeedAdjustment = new ArrayList<ParentedCommitDescriptor>();
        LinkedList parentsToCheck = new LinkedList(commit.getParentCommits());
        while (!parentsToCheck.isEmpty()) {
            CommitDescriptor currentCommit = (CommitDescriptor)parentsToCheck.pop();
            if (possibleCodeCommit.get().getTimestamp() >= currentCommit.getTimestamp() || !currentCommit.isOnSameBranchAs(commit.getCommit())) continue;
            ParentedCommitDescriptor parentedCurrentCommit = commitDescriptorIndex.getCommit(currentCommit);
            parentsThatMightNeedAdjustment.add(parentedCurrentCommit);
            parentsToCheck.addAll(parentedCurrentCommit.getParentCommits());
        }
        ArrayList<CommitDescriptor> rollbackRequiredCommits = new ArrayList<CommitDescriptor>();
        for (ParentedCommitDescriptor parentedCommitDescriptor : parentsThatMightNeedAdjustment) {
            boolean hasAdjustableChildrenFromOtherBranches = this.commitChildrenIndex.getChildCommits(parentedCommitDescriptor.getCommit()).stream().anyMatch(Predicate.not(arg_0 -> ((CommitDescriptor)parentedCommitDescriptor.getCommit()).isOnSameBranchAs(arg_0)));
            if (!hasAdjustableChildrenFromOtherBranches) continue;
            rollbackRequiredCommits.add(parentedCommitDescriptor.getCommit());
        }
        if (!rollbackRequiredCommits.isEmpty()) {
            String rollbackReason = "Detected external upload that needs to be re-integrated into the commit tree structure " + String.valueOf(commit);
            RollbackRequest rollbackRequest = new RollbackRequest(CollectionUtils.map(rollbackRequiredCommits, CommitDescriptor::cloneWithDecrementedTimestamp), rollbackReason);
            this.schedulingHelper.scheduleRollback(rollbackRequest, null);
        }
    }

    private void handlePotentialCommitMerge(ParentedCommitDescriptor commit, ParentedCommitDescriptor existingCommit) throws StorageException {
        UnmodifiableList existingCommitParents = existingCommit.getParentCommits();
        List<CommitDescriptor> commitParents = CommitDescriptorMerger.mergeParents((List<CommitDescriptor>)existingCommitParents, (List<CommitDescriptor>)commit.getParentCommits());
        if (!commitParents.equals(existingCommitParents)) {
            ParentedCommitDescriptor parentedCommitDescriptor = new ParentedCommitDescriptor(commit.getCommit(), commitParents);
            this.commitDescriptorIndex.insertCommit(parentedCommitDescriptor);
            this.commitChildrenIndex.insertAsChildForParents(parentedCommitDescriptor);
        }
    }

    static List<CommitDescriptor> mergeParents(List<CommitDescriptor> existingCommitParents, List<CommitDescriptor> parentCommits) {
        ArrayList<CommitDescriptor> mergedCommits = new ArrayList<CommitDescriptor>(existingCommitParents);
        for (CommitDescriptor parentCommit : parentCommits) {
            boolean wasMergedWithExisting = false;
            for (int i = 0; i < existingCommitParents.size(); ++i) {
                CommitDescriptor existingCommitParent = existingCommitParents.get(i);
                if (!existingCommitParent.isOnSameBranchAs(parentCommit)) continue;
                mergedCommits.set(i, (CommitDescriptor)ComparableUtils.max((Comparable)existingCommitParent, (Comparable)parentCommit, (Comparable[])new CommitDescriptor[0]));
                wasMergedWithExisting = true;
                break;
            }
            if (wasMergedWithExisting) continue;
            mergedCommits.add(parentCommit);
        }
        return mergedCommits;
    }

    private static ParentedCommitDescriptor adjustParents(ParentedCommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex, boolean onlyMergeParents) throws StorageException, AssertionError {
        int i;
        UnmodifiableList parentCommits;
        int parentsToKeep = 0;
        if (onlyMergeParents) {
            parentsToKeep = 1;
        }
        if ((parentCommits = commit.getParentCommits()).size() <= parentsToKeep) {
            return commit;
        }
        ArrayList<CommitDescriptor> newParents = new ArrayList<CommitDescriptor>();
        for (i = 0; i < parentsToKeep; ++i) {
            newParents.add((CommitDescriptor)parentCommits.get(i));
        }
        for (i = parentsToKeep; i < parentCommits.size(); ++i) {
            newParents.add(CommitDescriptorMerger.determineAdjustedParent(commit.getCommit(), (CommitDescriptor)parentCommits.get(i), commitDescriptorIndex));
        }
        return new ParentedCommitDescriptor(commit.getCommit(), newParents);
    }

    private static CommitDescriptor determineAdjustedParent(CommitDescriptor commit, CommitDescriptor parentCommit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        long minMergeTimestamp = parentCommit.getTimestamp() + 10L;
        long maxMergeTimestamp = Math.min(commit.getTimestamp() - 1L, parentCommit.getTimestamp() + 500L);
        if (maxMergeTimestamp < minMergeTimestamp) {
            return parentCommit;
        }
        List<CommitDescriptor> potentialNewParents = commitDescriptorIndex.getAllCommitsOnBranchBetweenInclusive(new CommitDescriptor(parentCommit.getBranchName(), minMergeTimestamp), new CommitDescriptor(parentCommit.getBranchName(), maxMergeTimestamp));
        if (potentialNewParents.isEmpty()) {
            return parentCommit;
        }
        return Collections.max(potentialNewParents);
    }

    private static ParentedCommitDescriptor adjustParent(ParentedCommitDescriptor adjustee, CommitDescriptor newParent, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        ArrayList<CommitDescriptor> newParents = new ArrayList<CommitDescriptor>();
        newParents.add(newParent);
        if (adjustee.getFirstParentCommit() != null && !CommitDescriptorMerger.isTransitivelyReachable(adjustee.getFirstParentCommit(), newParent, commitDescriptorIndex)) {
            newParents.add(adjustee.getFirstParentCommit());
        }
        newParents.addAll(CollectionUtils.filter((Collection)adjustee.getOtherParentCommits(), Predicate.not(arg_0 -> ((CommitDescriptor)newParent).isOnSameBranchAs(arg_0))));
        return new ParentedCommitDescriptor(adjustee.getCommit(), newParents);
    }

    private static boolean isTransitivelyReachable(CommitDescriptor searchTarget, CommitDescriptor searchStart, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        while (searchTarget.getTimestamp() <= searchStart.getTimestamp()) {
            if (searchTarget.equals((Object)searchStart)) {
                return true;
            }
            if ((searchStart = commitDescriptorIndex.getCommit(searchStart).getFirstParentCommit()) != null) continue;
            return false;
        }
        return false;
    }

    private void checkForMergeRollback(ParentedCommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        if (commit.getFirstParentCommit() == null) {
            return;
        }
        long timestampOffset = commit.getTimestamp() - commit.getFirstParentCommit().getTimestamp();
        if (!CommitDescriptorMerger.isInMergeWindow(timestampOffset)) {
            return;
        }
        List<ParentedCommitDescriptor> rollbackParents = CommitDescriptorMerger.findOtherCommitsWithIdenticalParent(commit, commitDescriptorIndex);
        if (rollbackParents.isEmpty()) {
            return;
        }
        String rollbackReason = "Performing rollback, caused by " + String.valueOf(commit) + ", to " + String.valueOf(rollbackParents) + " in project '" + String.valueOf(this.schedulingHelper.getInternalProjectId()) + " (" + String.valueOf(this.schedulingHelper.loadPublicProjectId()) + ")'. Caused by possible merge of external uploads.";
        LOGGER.warn(rollbackReason);
        RollbackRequest rollbackRequest = new RollbackRequest(CollectionUtils.map(rollbackParents, c -> c.getCommit().cloneWithDecrementedTimestamp()), rollbackReason);
        this.schedulingHelper.scheduleRollback(rollbackRequest, null);
    }

    public static boolean isInMergeWindow(long timestampOffset) {
        return timestampOffset >= 10L && timestampOffset <= 500L;
    }

    private static List<ParentedCommitDescriptor> findOtherCommitsWithIdenticalParent(ParentedCommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        return CollectionUtils.filter(commitDescriptorIndex.getAllCommits(), descriptor -> CommitDescriptorMerger.hasIdenticalParent(commit, descriptor));
    }

    private static boolean hasIdenticalParent(ParentedCommitDescriptor commit, ParentedCommitDescriptor otherCommit) {
        return !commit.getCommit().isOnSameBranchAs(otherCommit.getCommit()) && commit.getTimestamp() < otherCommit.getTimestamp() && otherCommit.getParentCommits().contains((Object)commit.getFirstParentCommit());
    }
}

