/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.analysis.DeltaIndex;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.VirtualStoreIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.project.ReanalyzeProjectTrigger;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.core.runtime.impl.scheduling.CommitDescriptorMerger;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.PeriodicJobSupport;
import com.teamscale.core.runtime.impl.scheduling.ProjectProgressPublisher;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.SchedulingHelper;
import com.teamscale.core.runtime.impl.scheduling.UnusedIds;
import com.teamscale.core.runtime.impl.worker.JobExecutionResult;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.LocalMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.transaction.TransactionHandler;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.Nullable;

public class JobCompletionSupport {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INITIAL_RESCHEDULE_DELAY = 10;
    private static final int MAX_RESCHEDULE_DELAY = 3600;
    private final InternalProjectId projectId;
    private final DeltaIndex deltaIndex;
    private final VirtualStoreIndex virtualStoreIndex;
    private final SchedulingHelper schedulingHelper;
    private final PeriodicJobSupport periodicJobSupport;
    private final IndexLayer indexLayer;
    private final ProjectProgressPublisher projectProgressPublisher;

    public JobCompletionSupport(InternalProjectId projectId, DeltaIndex deltaIndex, VirtualStoreIndex virtualStoreIndex, PeriodicJobSupport periodicJobSupport, IndexLayer indexLayer, ProjectProgressPublisher projectProgressPublisher) {
        this.projectId = projectId;
        this.deltaIndex = deltaIndex;
        this.virtualStoreIndex = virtualStoreIndex;
        this.schedulingHelper = periodicJobSupport.getSchedulingHelper();
        this.periodicJobSupport = periodicJobSupport;
        this.indexLayer = indexLayer;
        this.projectProgressPublisher = projectProgressPublisher;
    }

    public void completeJob(JobExecutionResult executionResult, Consumer<Throwable> errorHandler) throws StorageException, TriggerCompilationException {
        try {
            this.completeJobInternal(executionResult, errorHandler);
        }
        finally {
            this.schedulingHelper.getAssignedJobs().removeJob(executionResult.getScheduledJob());
            this.removeUnusedDeltasAndVirtualStores(executionResult);
            this.projectProgressPublisher.publishProgress(executionResult.getScheduledJob());
        }
    }

    private void completeJobInternal(JobExecutionResult executionResult, Consumer<Throwable> errorHandler) throws TriggerCompilationException, StorageException {
        if (this.rescheduleIfNecessary(executionResult)) {
            return;
        }
        LOGGER.debug(() -> "Completed job: " + String.valueOf(executionResult.getScheduledJob().getJob()) + " (" + String.valueOf(executionResult.getScheduledJob().getInputDeltaStoreNames()) + " -> " + String.valueOf(executionResult.getOutputDeltas()));
        if (executionResult.getResult() == JobExecutionResult.EJobResult.COMPLETED_WITH_UNRECOVERABLE_ERROR) {
            return;
        }
        if (JobCompletionSupport.isJobWithEmptyOutputDelta(executionResult)) {
            this.completeEmptyDeltaJob(executionResult);
        } else {
            this.insertNewDeltasFromJob(executionResult);
            this.updateCommitDescriptorIndex(executionResult);
        }
        this.executePostExecutionSteps(executionResult, errorHandler);
    }

    private void removeUnusedDeltasAndVirtualStores(JobExecutionResult executionResult) throws StorageException {
        Set<Long> unusedDeltaIds = Stream.of(executionResult.getScheduledJob().getInputDeltaIds(), executionResult.getOutputDeltas().getSecondList()).flatMap(Collection::stream).filter(this.schedulingHelper::isUnusedDelta).collect(Collectors.toSet());
        Set<Long> unusedVirtualStoreIds = Stream.of(executionResult.getScheduledJob().getAllVirtualStoreIds(), executionResult.getVirtualStores()).flatMap(Collection::stream).filter(this.schedulingHelper::isUnusedVirtualStore).collect(Collectors.toSet());
        this.removeUnusedIds(new UnusedIds(unusedDeltaIds, unusedVirtualStoreIds));
    }

    private static boolean isJobWithEmptyOutputDelta(JobExecutionResult executionResult) {
        return executionResult.getScheduledJob().getSchedulingCommit() == null || executionResult.getOutputDeltas().isEmpty() || executionResult.getPostTriggerActions().contains(new IPostTriggerAction.IgnoreOutputDelta());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean rescheduleIfNecessary(JobExecutionResult executionResult) throws TriggerCompilationException {
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(executionResult.getScheduledJob());
        if (executionResult.getResult() != JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED) {
            trigger.setRescheduleDelaySeconds(0);
            return false;
        }
        for (IPostTriggerAction action : executionResult.getPostTriggerActions()) {
            if (!(action instanceof IPostTriggerAction.ApplyRateLimiting)) continue;
            IPostTriggerAction.ApplyRateLimiting applyRateLimiting = (IPostTriggerAction.ApplyRateLimiting)action;
            try {
                Serializable serializable;
                RateLimitableResource remoteResource = serializable = applyRateLimiting.remoteResource();
                Serializable earliestAllowedAccess = serializable = applyRateLimiting.earliestAllowedAccess();
                this.applyRateLimiting(remoteResource, (Instant)earliestAllowedAccess);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (executionResult.getRescheduleAfterTimestamp() > DateTimeUtils.millisNow()) {
            ScheduledJob rescheduledJob = ScheduledJob.copyWithRescheduleUpdate(executionResult.getScheduledJob(), executionResult.getRescheduleAfterTimestamp(), executionResult.getScheduledJob().getRetryCount() + 1);
            this.schedulingHelper.rescheduleJob(rescheduledJob);
            return true;
        }
        int delaySeconds = 10;
        if (trigger.getRescheduleDelaySeconds() > 0) {
            delaySeconds = Math.min(3600, 2 * trigger.getRescheduleDelaySeconds());
        }
        trigger.setRescheduleDelaySeconds(delaySeconds);
        ScheduledJob rescheduledJob = ScheduledJob.copyWithRescheduleUpdate(executionResult.getScheduledJob(), DateTimeUtils.millisNow() + (long)delaySeconds * 1000L, executionResult.getScheduledJob().getRetryCount() + 1);
        this.schedulingHelper.rescheduleJob(rescheduledJob);
        return true;
    }

    private void insertNewDeltasFromJob(JobExecutionResult executionResult) throws StorageException {
        JobCompletionSupport.assertConstraintsForCompletedJob(executionResult);
        PairList<String, Long> outputDeltas = executionResult.getOutputDeltas();
        for (Pair outputDelta : outputDeltas) {
            String store = (String)outputDelta.getFirst();
            long deltaId = (Long)outputDelta.getSecond();
            Optional<Long> virtualStoreId = executionResult.getVirtualStoreId(store);
            this.insertNewDeltaFromJob(executionResult.getScheduledJob(), store, deltaId, virtualStoreId.orElse(null));
        }
    }

    private static void assertConstraintsForCompletedJob(JobExecutionResult executionResult) {
        ScheduledJob completedJob = executionResult.getScheduledJob();
        CCSMAssert.isNotNull((Object)completedJob.getSchedulingCommit(), () -> "A job scheduled with null commit may never return deltas, but only scheduling hints: " + String.valueOf(completedJob));
        CCSMAssert.isFalse((boolean)executionResult.getPostTriggerActions().contains(new IPostTriggerAction.IgnoreOutputDelta()), () -> "Can't insert delta from job which wants to ignore its output delta: " + String.valueOf(completedJob));
    }

    private void insertNewDeltaFromJob(ScheduledJob completedJob, String store, long deltaId, @Nullable Long virtualStoreId) throws StorageException {
        for (AnalysisTrigger trigger : this.schedulingHelper.getTriggerCache().getTriggersConsumingDelta(store)) {
            LOGGER.debug(() -> "Assigning delta " + deltaId + " to trigger " + String.valueOf(trigger));
            this.assignDeltaToJob(completedJob, trigger, store, deltaId, virtualStoreId);
        }
    }

    /*
     * Loose catch block
     */
    private void updateCommitDescriptorIndex(JobExecutionResult executionResult) throws TriggerCompilationException, StorageException {
        ParentedCommitDescriptor p;
        ITrigger trigger;
        block8: {
            trigger = this.schedulingHelper.getTriggerCache().getTrigger(executionResult.getScheduledJob().getJob());
            if (!trigger.isPeriodic()) {
                return;
            }
            ISchedulingCommit iSchedulingCommit = executionResult.getScheduledJob().getSchedulingCommit();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ISchedulingCommit.ParentedCommit.class, ISchedulingCommit.PlainCommit.class}, (ISchedulingCommit)iSchedulingCommit, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case -1: {
                    throw new IllegalStateException("Cannot update CommitDescriptorIndex with null commit");
                }
                case 0: {
                    ParentedCommitDescriptor parentedCommitDescriptor;
                    ISchedulingCommit.ParentedCommit parentedCommit = (ISchedulingCommit.ParentedCommit)iSchedulingCommit;
                    p = parentedCommitDescriptor = parentedCommit.parentedCommit();
                    break;
                }
                case 1: {
                    ISchedulingCommit.PlainCommit c = (ISchedulingCommit.PlainCommit)iSchedulingCommit;
                    throw new IllegalStateException("Job (%s) was scheduled with normal/un-parented commit (%s)".formatted(executionResult.getScheduledJob(), c));
                }
            }
            break block8;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        ParentedCommitDescriptor parentedCommit = p;
        CommitDescriptorIndex commitDescriptorIndex = CommitDescriptorIndex.open(this.indexLayer, (IProjectId)this.projectId);
        CommitChildrenIndex commitChildrenIndex = CommitChildrenIndex.open(this.indexLayer, (IProjectId)this.projectId);
        new CommitDescriptorMerger(commitDescriptorIndex, commitChildrenIndex, this.schedulingHelper).storeCommit(parentedCommit, trigger.commitsNeedParentAdjustmentForPreviouslyForkedCommits());
    }

    private void assignDeltaToJob(ScheduledJob completedJob, AnalysisTrigger trigger, String store, long deltaId, @Nullable Long virtualStoreId) throws StorageException {
        if (this.schedulingHelper.getJobQueue().assignDeltaToExistingJob(trigger, store, deltaId, virtualStoreId, completedJob.getSchedulingCommitDescriptor(), this.schedulingHelper.getIdGenerator())) {
            return;
        }
        JobDescriptor newJob = JobDescriptor.forProject(this.projectId).withTrigger(trigger).withSchedulingReason("Scheduling due to delta from store " + store).withCommit((ISchedulingCommit)Optional.ofNullable(completedJob.getSchedulingCommit()).map(ISchedulingCommit::commit).map(ISchedulingCommit::plain).orElse(null)).withRollbackRelevant(completedJob.getJob().isRollbackRelevant()).withCancelable(trigger.isCancelable()).build();
        this.schedulingHelper.scheduleJobWithInputDelta(newJob, (Pair<String, Long>)Pair.createPair((Object)store, (Object)deltaId), virtualStoreId);
    }

    private void scheduleJobFromHints(ScheduledJob completedJob, List<ParentedCommitDescriptor> schedulingHints) throws TriggerCompilationException {
        CCSMAssert.isTrue((boolean)JobQueue.isPreAnnouncingTrigger(this.schedulingHelper.getTriggerCache(), completedJob), (String)"Only pre-announcing triggers may provide scheduling hints.");
        JobDescriptor job = completedJob.getJob();
        for (ParentedCommitDescriptor schedulingHint : schedulingHints) {
            if (this.schedulingHelper.existsJob(job.getTriggerName(), schedulingHint.getCommit(), true)) continue;
            this.schedulingHelper.scheduleJob(job.toBuilder().withSchedulingReason("Scheduled due to scheduling hint " + String.valueOf(schedulingHint)).withCommit(ISchedulingCommit.parented(schedulingHint)).build());
        }
    }

    private void insertPreAnnouncements(ScheduledJob completedJob, List<CommitDescriptor> schedulingPreAnnouncements) throws StorageException, TriggerCompilationException {
        CCSMAssert.isTrue((boolean)JobQueue.isPreAnnouncingTrigger(this.schedulingHelper.getTriggerCache(), completedJob), (String)"Only pre-announcing triggers may provide pre-announcements.");
        this.schedulingHelper.getJobQueue().insertPreAnnouncements(completedJob.getTriggerName(), schedulingPreAnnouncements);
    }

    private void completeEmptyDeltaJob(JobExecutionResult executionResult) throws TriggerCompilationException {
        ScheduledJob completedJob = executionResult.getScheduledJob();
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(completedJob);
        if (!trigger.isPeriodic()) {
            return;
        }
        if (executionResult.getPostTriggerActions().stream().noneMatch(IPostTriggerAction.RescheduleWith.class::isInstance) && trigger.isRunToExhaustion()) {
            this.periodicJobSupport.markTriggerAsExhausted(completedJob.getTriggerName());
        }
    }

    private void executePostExecutionSteps(JobExecutionResult executionResult, Consumer<Throwable> errorHandler) throws TriggerCompilationException, StorageException {
        ScheduledJob completedJob = executionResult.getScheduledJob();
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(completedJob);
        this.schedulingHelper.getProgress().updateProgressForCompletedJob(completedJob.getJob(), trigger, this.schedulingHelper.getJobQueue(), this.schedulingHelper.getAssignedJobs());
        if (trigger.isPeriodic() && !JobCompletionSupport.isJobWithEmptyOutputDelta(executionResult)) {
            this.schedulePostRevisionTriggers(completedJob.getSchedulingCommitDescriptor(), completedJob, errorHandler);
        }
        this.executePostTriggerActions(executionResult, trigger, errorHandler);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePostTriggerActions(JobExecutionResult executionResult, ITrigger trigger, Consumer<Throwable> errorHandler) throws StorageException, TriggerCompilationException, AssertionError {
        Iterator iterator = executionResult.getPostTriggerActions().iterator();
        block22: while (true) {
            Record record;
            IPostTriggerAction postTriggerAction;
            if (!iterator.hasNext()) {
                if (!ReanalyzeProjectTrigger.class.equals(trigger.getAnalysisStepClass())) return;
                this.completeReanalysis();
                return;
            }
            IPostTriggerAction iPostTriggerAction = postTriggerAction = (IPostTriggerAction)iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IPostTriggerAction.DiscardScheduledJobs.class, IPostTriggerAction.SchedulePeriodicJobs.class, IPostTriggerAction.RescheduleWith.class, IPostTriggerAction.ApplyRateLimiting.class, IPostTriggerAction.AddPreAnnouncements.class, IPostTriggerAction.ScheduleExternalDataTriggers.class, IPostTriggerAction.RunPostBuildCompletenessTriggers.class, IPostTriggerAction.RunPostRevisionTriggers.class, IPostTriggerAction.ScheduleChangeRetriever.class, IPostTriggerAction.RequestRollback.class, IPostTriggerAction.IgnoreOutputDelta.class}, (IPostTriggerAction)iPostTriggerAction, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case -1: {
                    LOGGER.warn("{} resulted in a null PostTriggerAction. This should never happen.", (Object)executionResult.getScheduledJob());
                    continue block22;
                }
                case 0: {
                    Map<String, Long> timestampForBranch;
                    IPostTriggerAction.DiscardScheduledJobs discardScheduledJobs = (IPostTriggerAction.DiscardScheduledJobs)iPostTriggerAction;
                    try {
                        Map<String, Long> map;
                        timestampForBranch = map = discardScheduledJobs.timestampForBranch();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    this.discardScheduledJobs(timestampForBranch);
                    continue block22;
                }
                case 1: {
                    IPostTriggerAction.SchedulePeriodicJobs ignored = (IPostTriggerAction.SchedulePeriodicJobs)iPostTriggerAction;
                    this.periodicJobSupport.schedulePeriodicJobs(0L, true);
                    continue block22;
                }
                case 2: {
                    Object schedulingHints;
                    Object object;
                    IPostTriggerAction.RescheduleWith rescheduleWith = (IPostTriggerAction.RescheduleWith)iPostTriggerAction;
                    {
                        schedulingHints = object = rescheduleWith.schedulingHints();
                    }
                    this.scheduleJobFromHints(executionResult.getScheduledJob(), (List<ParentedCommitDescriptor>)schedulingHints);
                    continue block22;
                }
                case 3: {
                    Object object2;
                    Object object = (IPostTriggerAction.ApplyRateLimiting)iPostTriggerAction;
                    {
                        object2 = ((IPostTriggerAction.ApplyRateLimiting)object).remoteResource();
                        Record remoteResource = object2;
                        Object earliestAllowedReschedule = object2 = ((IPostTriggerAction.ApplyRateLimiting)object).earliestAllowedAccess();
                        this.applyRateLimiting((RateLimitableResource)remoteResource, (Instant)earliestAllowedReschedule);
                        continue block22;
                    }
                }
                case 4: {
                    List<CommitDescriptor> preAnnouncements;
                    Object object2 = (IPostTriggerAction.AddPreAnnouncements)iPostTriggerAction;
                    {
                        List<CommitDescriptor> list;
                        preAnnouncements = list = ((IPostTriggerAction.AddPreAnnouncements)object2).preAnnouncements();
                    }
                    this.insertPreAnnouncements(executionResult.getScheduledJob(), preAnnouncements);
                    continue block22;
                }
                case 5: {
                    IPostTriggerAction.ScheduleExternalDataTriggers ignored = (IPostTriggerAction.ScheduleExternalDataTriggers)iPostTriggerAction;
                    this.scheduleExternalDataTriggers();
                    continue block22;
                }
                case 6: {
                    IPostTriggerAction.RunPostBuildCompletenessTriggers ignored = (IPostTriggerAction.RunPostBuildCompletenessTriggers)iPostTriggerAction;
                    this.schedulePostBuildCompletenessTriggers();
                    continue block22;
                }
                case 7: {
                    IPostTriggerAction.ScheduleChangeRetriever schedulingCommit;
                    IPostTriggerAction.ScheduleChangeRetriever scheduleChangeRetriever;
                    IPostTriggerAction.RunPostRevisionTriggers runPostRevisionTriggers = (IPostTriggerAction.RunPostRevisionTriggers)iPostTriggerAction;
                    {
                        schedulingCommit = scheduleChangeRetriever = runPostRevisionTriggers.schedulingCommit();
                    }
                    this.schedulePostRevisionTriggers((CommitDescriptor)schedulingCommit, executionResult.getScheduledJob(), errorHandler);
                    continue block22;
                }
                case 8: {
                    Object object;
                    IPostTriggerAction.ScheduleChangeRetriever scheduleChangeRetriever = (IPostTriggerAction.ScheduleChangeRetriever)iPostTriggerAction;
                    {
                        Object changeRetriever = object = scheduleChangeRetriever.changeRetrieverName();
                        this.rescheduleChangeRetriever(executionResult.getScheduledJob(), (String)changeRetriever);
                        continue block22;
                    }
                }
                case 9: {
                    Record request;
                    Object object = (IPostTriggerAction.RequestRollback)iPostTriggerAction;
                    {
                        request = record = ((IPostTriggerAction.RequestRollback)object).request();
                    }
                    this.performRequestedRollback(executionResult.getScheduledJob().getJob(), (RollbackRequest)request);
                    continue block22;
                }
                case 10: 
            }
            record = (IPostTriggerAction.IgnoreOutputDelta)iPostTriggerAction;
        }
    }

    private void performRequestedRollback(JobDescriptor job, RollbackRequest rollbackRequest) throws StorageException {
        LOGGER.warn("Performing rollback on request of trigger {} in project {}: {}", (Object)job.getTriggerName(), (Object)this.projectId, (Object)rollbackRequest);
        this.schedulingHelper.scheduleRollback(rollbackRequest, job);
    }

    private void scheduleExternalDataTriggers() {
        for (AnalysisTrigger trigger : this.schedulingHelper.getTriggerCache().getExternalDataTriggers()) {
            if (!trigger.isExternalDataTrigger() || this.schedulingHelper.getJobQueue().existsJobForCommit(trigger.getName(), null)) continue;
            this.schedulingHelper.scheduleJob(JobDescriptor.forProject(this.projectId).withTrigger(trigger).withSchedulingReason("Scheduled as external data trigger.").build());
        }
    }

    private void schedulePostBuildCompletenessTriggers() {
        for (AnalysisTrigger analysisTrigger : this.schedulingHelper.getTriggerCache().getPostBuildCompletenessTriggers()) {
            if (!analysisTrigger.isPostBuildCompletenessTrigger() || this.schedulingHelper.getJobQueue().existsJobForCommit(analysisTrigger.getName(), null)) continue;
            this.schedulingHelper.scheduleJob(JobDescriptor.forProject(this.projectId).withTrigger(analysisTrigger).withSchedulingReason("Scheduled as post build completeness trigger.").build());
        }
    }

    private void rescheduleChangeRetriever(ScheduledJob completedJob, String changeRetrieverToReschedule) {
        if (!this.schedulingHelper.existsJobWithoutSchedulingCommit(changeRetrieverToReschedule)) {
            this.schedulingHelper.scheduleJob(JobDescriptor.forProject(this.projectId).withTrigger(ETriggerType.BLOCK, changeRetrieverToReschedule).withSchedulingReason("Analysis step '" + String.valueOf(completedJob) + "' requested repository change retriever reschedule.").withRollbackRelevant(false).withCancelable(false).build());
        }
    }

    private void applyRateLimiting(RateLimitableResource remoteResource, Instant earliestAllowedReschedule) {
        this.schedulingHelper.signalRateLimiting(remoteResource, earliestAllowedReschedule);
    }

    private void schedulePostRevisionTriggers(CommitDescriptor commit, ScheduledJob completedJob, Consumer<Throwable> errorHandler) throws StorageException {
        if (PreCommitUtils.isPrecommitCommit(commit)) {
            return;
        }
        BranchAnalysisStateIndex index = this.indexLayer.openNonHistorizedProjectIndex(BranchAnalysisStateIndex.class, (IProjectId)this.projectId);
        AnalysisState analysisState = index.getAnalysisState(commit.getBranchName());
        if (analysisState == null) {
            errorHandler.accept((Throwable)((Object)new AssertionError((Object)("Skipping scheduling of post revision triggers due to missing analysis state for " + String.valueOf(completedJob) + ".\nindex.getAnalysisState(" + commit.getBranchName() + ") returned null, based on the commit " + String.valueOf(commit)))));
            return;
        }
        TriggerIndex triggerIndex = this.indexLayer.openNonHistorizedProjectIndex(TriggerIndex.class, (IProjectId)this.projectId);
        for (Class<? extends PostRevisionAnalysisTriggerBase> triggerClass : triggerIndex.getPostRevisionAnalysisTriggers(analysisState.getState())) {
            if (this.schedulingHelper.existsJob(triggerClass.getName(), commit, true)) continue;
            this.schedulingHelper.scheduleJob(JobDescriptor.forProject(this.projectId).withPrivilegedTrigger(triggerClass).withSchedulingReason("Post revision trigger for commit " + String.valueOf(commit)).withCommit(ISchedulingCommit.plain(commit)).build());
        }
    }

    private void discardScheduledJobs(Map<String, Long> timestampForBranch) throws StorageException {
        this.periodicJobSupport.resetExecutionCounts();
        for (Map.Entry<String, Long> entry : timestampForBranch.entrySet()) {
            this.schedulingHelper.getProgress().discardFutureProgress(entry.getKey(), entry.getValue());
        }
        UnusedIds unusedIds = this.schedulingHelper.getJobQueue().discardScheduledJobs(timestampForBranch);
        this.removeUnusedIds(unusedIds);
    }

    private void removeUnusedIds(UnusedIds unusedIds) throws StorageException {
        if (!unusedIds.deltaIds().isEmpty()) {
            LOGGER.debug("Removing unused deltas: {}", unusedIds.deltaIds());
            this.deltaIndex.removeDeltas(unusedIds.deltaIds());
        }
        if (!unusedIds.virtualStoreIds().isEmpty()) {
            LOGGER.debug("Removing unused virtual stores: {}", unusedIds.virtualStoreIds());
            this.virtualStoreIndex.discardVirtualStores(unusedIds.virtualStoreIds());
        }
    }

    private void completeReanalysis() throws StorageException, TriggerCompilationException {
        this.recreateProject();
        this.schedulingHelper.invalidateProject();
    }

    private void recreateProject() throws StorageException, TriggerCompilationException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfigurationWithoutEmbeddedProfile(this.indexLayer.openProjectStorageSystem((IProjectId)this.projectId));
        TransactionHandler transactionHandler = new TransactionHandler(this.indexLayer.getStorageCacheProvider(), InMemoryStore::new);
        LocalMessageBroker messageBroker = new LocalMessageBroker();
        StorageCacheProvider cacheProvider = StorageCacheRegistry.createCacheProvider((IMessageBroker)messageBroker);
        IndexLayer transactionalIndexLayer = new IndexLayer(transactionHandler.decorate(this.indexLayer.getRawStorageSystemProvider()), cacheProvider, (IMessageBroker)messageBroker);
        try {
            ProjectIndex projectIndex = transactionalIndexLayer.openProjectIndex();
            projectIndex.removeProject(this.projectId);
            new ProjectCreator(transactionalIndexLayer, ConfigurationInitializationContext.EInitializationReason.PROJECT_REANALYSIS).createProject(projectConfiguration, false, false, false);
            transactionHandler.commit();
        }
        catch (ProjectConfigurationException e) {
            LOGGER.error("Error re-creating project: {}", (Object)projectConfiguration.getName(), (Object)e);
            transactionHandler.rollback();
        }
    }
}

