/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.wia.WiaUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.SetMapCollector;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class PredecessorCommitFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Nullable CommitDescriptorIndex commitDescriptorIndex;
    private final JobQueue jobQueue;
    private final AssignedJobs assignedJobs;
    private final Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommitCache = new HashMap<CommitDescriptor, ParentedCommitDescriptor>();
    private final Map<CommitDescriptor, List<@Nullable CommitDescriptor>> potentialPredecessorCommitCache = new HashMap<CommitDescriptor, List<CommitDescriptor>>();
    private final Map<Pair<CommitDescriptor, CommitDescriptor>, List<CommitDescriptor>> commitsBetweenCache = new HashMap<Pair<CommitDescriptor, CommitDescriptor>, List<CommitDescriptor>>();

    public PredecessorCommitFinder(JobQueue jobQueue, AssignedJobs assignedJobs, @Nullable CommitDescriptorIndex commitDescriptorIndex) {
        this.commitDescriptorIndex = commitDescriptorIndex;
        this.jobQueue = jobQueue;
        this.assignedJobs = assignedJobs;
    }

    @TestOnly
    public List<@Nullable CommitDescriptor> getPotentialPredecessorCommits(@Nullable ParentedCommitDescriptor schedulingCommit) throws StorageException {
        return this.getPotentialPredecessorCommits(ISchedulingCommit.of(schedulingCommit));
    }

    @TestOnly
    public List<@Nullable CommitDescriptor> getPotentialPredecessorCommits(@Nullable CommitDescriptor schedulingCommit) throws StorageException {
        return this.getPotentialPredecessorCommits(ISchedulingCommit.of(schedulingCommit));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<@Nullable CommitDescriptor> getPotentialPredecessorCommits(@Nullable ISchedulingCommit schedulingCommit) throws StorageException {
        LOGGER.traceEntry("getPotentialPredecessorCommits for {}", new Object[]{schedulingCommit});
        List potentialPredecessorCommits = this.potentialPredecessorCommitCache.get(ISchedulingCommit.getCommit(schedulingCommit));
        if (potentialPredecessorCommits != null) {
            return (List)LOGGER.traceExit("getPotentialPredecessorCommits with cached value {}", potentialPredecessorCommits);
        }
        @Nullable HashSet allCommits = CollectionUtils.unionSet(this.jobQueue.getOrderedCommits(), (Collection[])new Collection[]{this.assignedJobs.getOrderedCommits()});
        SetMap allCommitsByBranchname = (SetMap)allCommits.stream().filter(Objects::nonNull).collect(SetMapCollector.groupingBy(CommitDescriptor::getBranchName));
        LOGGER.trace("Checking {} commits for potential predecessors: {}", (Object)allCommits.size(), (Object)allCommits);
        potentialPredecessorCommits = CollectionUtils.filterWithException((Collection)allCommits, previousCommit -> this.isPotentialPredecessor((CommitDescriptor)previousCommit, schedulingCommit, (SetMap<String, CommitDescriptor>)allCommitsByBranchname));
        this.potentialPredecessorCommitCache.put(ISchedulingCommit.getCommit(schedulingCommit), potentialPredecessorCommits);
        return (List)LOGGER.traceExit("getPotentialPredecessorCommits with computed value {}", (Object)potentialPredecessorCommits);
    }

    private boolean isPotentialPredecessor(@Nullable CommitDescriptor predecessorCandidate, @Nullable ISchedulingCommit successorCandidate, @NonNull SetMap<String, CommitDescriptor> allCommitsByBranchName) throws StorageException {
        LOGGER.traceEntry("isPotentialPredecessor predecessorCandidate={} successorCandidate={}", new Object[]{predecessorCandidate, successorCandidate});
        if (predecessorCandidate == null) {
            if (successorCandidate == null) {
                return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (predecessor and successor are null)", (Object)false);
            }
            if (PreCommitUtils.isPrecommitCommit(ISchedulingCommit.getCommit(successorCandidate))) {
                return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (predecessor is null, successor is pre-commit)", (Object)false);
            }
            return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (predecessor is null, successor is not null, is no precommit-commit)", (Object)true);
        }
        if (successorCandidate == null) {
            return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (successor is null)", (Object)false);
        }
        if (PredecessorCommitFinder.areIndependentWiaCommits(predecessorCandidate, successorCandidate.commit())) {
            return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (independent WIA commits)", (Object)false);
        }
        Optional<Boolean> isPotentialPreCommitPredecessor = PredecessorCommitFinder.checkForPotentialPreCommitPredecessor(predecessorCandidate, successorCandidate.commit());
        if (isPotentialPreCommitPredecessor.isPresent()) {
            return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (pre-commit short-circuit)", (Object)isPotentialPreCommitPredecessor.get());
        }
        if (PreCommitUtils.isPrecommitCommit(successorCandidate.commit())) {
            CommitDescriptor firstCommitOnBranch = this.getFirstCommitOnSameBranch(successorCandidate);
            LOGGER.trace("Jumped from {} to first pre-commit commit {}", (Object)successorCandidate, (Object)firstCommitOnBranch);
            successorCandidate = ISchedulingCommit.plain(firstCommitOnBranch);
        }
        return this.isPotentialPredecessorWithoutShortCircuit(predecessorCandidate, successorCandidate, allCommitsByBranchName);
    }

    private boolean isPotentialPredecessorWithoutShortCircuit(@NonNull CommitDescriptor predecessorCandidate, @NonNull ISchedulingCommit successorCandidate, @NonNull SetMap<String, CommitDescriptor> allCommitsByBranchName) throws StorageException {
        LinkedList<ISchedulingCommit> successorCandidates = new LinkedList<ISchedulingCommit>();
        HashSet<CommitDescriptor> seenSuccessorCommits = new HashSet<CommitDescriptor>();
        successorCandidates.add(successorCandidate);
        seenSuccessorCommits.add(successorCandidate.commit());
        while (!successorCandidates.isEmpty()) {
            successorCandidate = (ISchedulingCommit)successorCandidates.poll();
            if (successorCandidate.commit().getTimestamp() <= predecessorCandidate.getTimestamp()) continue;
            if (predecessorCandidate.isOnSameBranchAs(successorCandidate.commit())) {
                return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (same branch with lower timestamp)", (Object)true);
            }
            List<CommitDescriptor> parents = this.determineParents(successorCandidate);
            LOGGER.trace("Got {} parent commits: {}", (Object)parents.size(), parents);
            for (CommitDescriptor successorParent : parents) {
                if (successorParent.equals((Object)predecessorCandidate)) {
                    return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (parent commit is predecessor candidate)", (Object)true);
                }
                if (seenSuccessorCommits.add(successorParent)) {
                    successorCandidates.add(ISchedulingCommit.plain(successorParent));
                }
                Set<CommitDescriptor> mergeCandidates = this.getMergeCandidates(successorCandidate.commit(), successorParent, allCommitsByBranchName);
                LOGGER.trace("Got {} merge candidates for parent {}: {}", (Object)mergeCandidates.size(), (Object)successorParent, mergeCandidates);
                for (CommitDescriptor mergeCandidate : mergeCandidates) {
                    if (mergeCandidate.equals((Object)predecessorCandidate)) {
                        return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {} (merge candidate is predecessor candidate)", (Object)true);
                    }
                    if (!seenSuccessorCommits.add(mergeCandidate)) continue;
                    successorCandidates.add(ISchedulingCommit.plain(mergeCandidate));
                }
            }
        }
        LOGGER.trace("Checked {} successor candidates", (Object)seenSuccessorCommits.size());
        return (Boolean)LOGGER.traceExit("isPotentialPredecessor: {}", (Object)false);
    }

    @VisibleForTesting
    static Optional<Boolean> checkForPotentialPreCommitPredecessor(CommitDescriptor predecessorCandidate, CommitDescriptor successorCandidate) {
        if (PreCommitUtils.isPrecommitCommit(successorCandidate)) {
            if (PreCommitUtils.isPrecommitCommit(predecessorCandidate)) {
                boolean isPredecessor = successorCandidate.isOnSameBranchAs(predecessorCandidate) && predecessorCandidate.getTimestamp() < successorCandidate.getTimestamp();
                return Optional.of(isPredecessor);
            }
            return Optional.empty();
        }
        if (PreCommitUtils.isPrecommitCommit(predecessorCandidate)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private CommitDescriptor getFirstCommitOnSameBranch(ISchedulingCommit schedulingCommit) throws StorageException {
        ParentedCommitDescriptor result = this.getParentedCommit(schedulingCommit);
        while (result.isSimpleCommit()) {
            result = this.getParentedCommit(ISchedulingCommit.plain(result.getFirstParentCommit()));
        }
        return result.getCommit();
    }

    private static boolean areIndependentWiaCommits(CommitDescriptor commit1, CommitDescriptor commit2) {
        boolean successorIsWiaCommit;
        boolean predecessorIsWiaCommit = WiaUtils.isWorkItemConnectorCommit((CommitDescriptor)commit1);
        if (predecessorIsWiaCommit != (successorIsWiaCommit = WiaUtils.isWorkItemConnectorCommit((CommitDescriptor)commit2))) {
            return true;
        }
        if (predecessorIsWiaCommit) {
            return !commit1.getBranchName().equals(commit2.getBranchName());
        }
        return false;
    }

    private Set<CommitDescriptor> getMergeCandidates(CommitDescriptor successorCandidate, CommitDescriptor successorParent, SetMap<String, CommitDescriptor> allCommitsByBranchName) throws StorageException {
        long maxTimestamp;
        long minTimestamp = successorParent.getTimestamp() + 10L;
        if (minTimestamp > (maxTimestamp = Math.min(successorCandidate.getTimestamp() - 1L, successorParent.getTimestamp() + 500L))) {
            return Collections.emptySet();
        }
        HashSet<CommitDescriptor> mergeCandidates = new HashSet<CommitDescriptor>();
        String successorBranchName = successorParent.getBranchName();
        CommitDescriptor startCommit = new CommitDescriptor(successorBranchName, minTimestamp);
        CommitDescriptor endCommit = new CommitDescriptor(successorBranchName, maxTimestamp);
        if (this.commitDescriptorIndex != null) {
            Pair startEndPair = Pair.createPair((Object)startCommit, (Object)endCommit);
            if (this.commitsBetweenCache.containsKey(startEndPair)) {
                mergeCandidates.addAll((Collection<CommitDescriptor>)this.commitsBetweenCache.get(startEndPair));
            } else {
                List<CommitDescriptor> allCommitsOnBranchBetweenInclusive = this.commitDescriptorIndex.getAllCommitsOnBranchBetweenInclusive(startCommit, endCommit);
                this.commitsBetweenCache.put((Pair<CommitDescriptor, CommitDescriptor>)startEndPair, allCommitsOnBranchBetweenInclusive);
                mergeCandidates.addAll(allCommitsOnBranchBetweenInclusive);
            }
        }
        Set commitsOnSuccessorBranch = (Set)allCommitsByBranchName.getCollectionOrEmpty((Object)successorBranchName);
        mergeCandidates.addAll(CollectionUtils.filter((Collection)commitsOnSuccessorBranch, commit -> minTimestamp <= commit.getTimestamp() && commit.getTimestamp() <= maxTimestamp));
        return mergeCandidates;
    }

    private List<CommitDescriptor> determineParents(ISchedulingCommit commit) throws StorageException {
        return this.getParentedCommit(commit).getParentCommits();
    }

    public ParentedCommitDescriptor getParentedCommit(ISchedulingCommit commit) throws StorageException {
        CommitDescriptor key = ISchedulingCommit.getCommit(commit);
        ParentedCommitDescriptor parentedCommit = null;
        if (this.parentedCommitCache.containsKey(key)) {
            parentedCommit = this.parentedCommitCache.get(key);
        } else if (this.commitDescriptorIndex != null) {
            parentedCommit = this.commitDescriptorIndex.getCommit(key);
            this.parentedCommitCache.put(key, parentedCommit);
        }
        if (parentedCommit != null && !parentedCommit.getParentCommits().isEmpty()) {
            return parentedCommit;
        }
        parentedCommit = this.getParentsForNonIndexedCommit(commit);
        this.parentedCommitCache.put(key, parentedCommit);
        return parentedCommit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParentedCommitDescriptor getParentsForNonIndexedCommit(@NonNull ISchedulingCommit commit) throws StorageException {
        LinkedHashSet parents = new LinkedHashSet();
        if (commit instanceof ISchedulingCommit.ParentedCommit) {
            ParentedCommitDescriptor parentedCommit2;
            ISchedulingCommit.ParentedCommit parentedCommit = (ISchedulingCommit.ParentedCommit)commit;
            try {
                ParentedCommitDescriptor parentedCommitDescriptor;
                parentedCommit2 = parentedCommitDescriptor = parentedCommit.parentedCommit();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            parents.addAll(parentedCommit2.getParentCommits());
        }
        this.getBranchParent(commit.commit()).ifPresent(parents::addFirst);
        return new ParentedCommitDescriptor(commit.commit(), List.copyOf(parents));
    }

    private Optional<CommitDescriptor> getBranchParent(CommitDescriptor commit) throws StorageException {
        Optional<CommitDescriptor> commitParent = this.commitDescriptorIndex.getFirstActualCommitBeforeOrAt(commit.cloneWithDecrementedTimestamp(), 0L);
        if (commitParent.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.commitDescriptorIndex.getCommit(commitParent.get())).map(ParentedCommitDescriptor::getCommit);
    }
}

