/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.progress.IProjectAnalysisStateChangeListener;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

public class ProjectProgressPublisher
implements IProjectAnalysisStateChangeListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport;
    private final BranchAnalysisStateIndex branchAnalysisStateIndex;
    private final AssignedJobs assignedJobs;
    private final JobQueue jobQueue;
    private final ProjectAnalysisProgress progress;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private Set<CommitDescriptor> previousUnfinishedCommits = new HashSet<CommitDescriptor>();
    private Set<CommitDescriptor> previousFirstPreAnnouncedCommits = new HashSet<CommitDescriptor>();
    private boolean emptyJobQueuesInInitialAnalysisReached = false;

    public ProjectProgressPublisher(PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport, BranchAnalysisStateIndex branchAnalysisStateIndex, CommitDescriptorIndex commitDescriptorIndex, AssignedJobs assignedJobs, JobQueue jobQueue, ProjectAnalysisProgress progress) {
        this.completedRevisionSupport = completedRevisionSupport;
        this.branchAnalysisStateIndex = branchAnalysisStateIndex;
        this.commitDescriptorIndex = commitDescriptorIndex;
        this.assignedJobs = assignedJobs;
        this.jobQueue = jobQueue;
        this.progress = progress;
        this.progress.registerProjectAnalysisStateChangeListener(this);
    }

    public void publishProgress(ScheduledJob completedJob) throws StorageException {
        HashSet unfinishedCommits = CollectionUtils.unionSet(this.assignedJobs.getAllNonNullSchedulingCommits(), (Collection[])new Collection[]{this.jobQueue.getAllNonNullSchedulingCommits()});
        List<CommitDescriptor> finishedCommits = this.progress.updateOpenAndDoneWork(unfinishedCommits, this.completedRevisionSupport);
        Set<ParentedCommitDescriptor> unfinishedCommitsParented = this.getParentedCommits(unfinishedCommits, completedJob);
        Set<ParentedCommitDescriptor> finishedCommitsParented = this.getParentedCommits(finishedCommits, completedJob);
        this.updateProjectAnalysisState(completedJob);
        this.updateBranchAnalysisStates(finishedCommitsParented, unfinishedCommitsParented, completedJob);
    }

    /*
     * Unable to fully structure code
     */
    private Set<ParentedCommitDescriptor> getParentedCommits(Collection<CommitDescriptor> commits, ScheduledJob completedJob) throws StorageException {
        parentedCommits = HashSet.newHashSet(commits.size());
        for (Pair pair : CollectionUtils.zip(commits, this.commitDescriptorIndex.getCommits(commits))) {
            block5: {
                p = (ParentedCommitDescriptor)pair.getSecond();
                if (p != null) break block5;
                var9_10 = completedJob.getSchedulingCommit();
                if (!(var9_10 instanceof ISchedulingCommit.ParentedCommit)) ** GOTO lbl-1000
                var7_8 = (ISchedulingCommit.ParentedCommit)var9_10;
                parentedCommit = var10_11 = var7_8.parentedCommit();
                if (parentedCommit.getCommit().equals(pair.getFirst())) {
                    p = parentedCommit;
                } else lbl-1000:
                // 2 sources

                {
                    p = Stream.of(new Set[]{this.jobQueue.getJobsForCommit((CommitDescriptor)pair.getFirst()), this.assignedJobs.getJobsForCommit((CommitDescriptor)pair.getFirst())}).flatMap((Function<Set, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Set;)Ljava/util/stream/Stream;)()).map((Function<ScheduledJob, ISchedulingCommit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSchedulingCommit(), (Lcom/teamscale/core/runtime/impl/scheduling/ScheduledJob;)Lcom/teamscale/core/runtime/impl/analysis/ISchedulingCommit;)()).filter((Predicate<ISchedulingCommit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/teamscale/core/runtime/impl/analysis/ISchedulingCommit;)Z)(ISchedulingCommit.ParentedCommit.class)).map((Function<ISchedulingCommit, ISchedulingCommit.ParentedCommit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lcom/teamscale/core/runtime/impl/analysis/ISchedulingCommit;)Lcom/teamscale/core/runtime/impl/analysis/ISchedulingCommit$ParentedCommit;)(ISchedulingCommit.ParentedCommit.class)).map((Function<ISchedulingCommit.ParentedCommit, ParentedCommitDescriptor>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, parentedCommit(), (Lcom/teamscale/core/runtime/impl/analysis/ISchedulingCommit$ParentedCommit;)Lorg/conqat/engine/index/shared/ParentedCommitDescriptor;)()).findFirst().orElse(null);
                }
            }
            if (p == null) continue;
            parentedCommits.add(p);
        }
        return parentedCommits;
        catch (Throwable var4_5) {
            throw new MatchException(var4_5.toString(), var4_5);
        }
    }

    private void setAnalysisProgressLive() throws StorageException {
        this.progress.setAnalysisState(EAnalysisState.LIVE_ANALYSIS);
        this.emptyJobQueuesInInitialAnalysisReached = false;
    }

    private void updateProjectAnalysisState(ScheduledJob completedJob) throws StorageException {
        if (this.jobQueue.isEmpty() && this.assignedJobs.isEmpty()) {
            if (this.progress.getAnalysisState().isIntermediate()) {
                this.setAnalysisProgressLive();
            } else if (this.progress.getAnalysisState() == EAnalysisState.INITIAL_ANALYSIS && !SchedulingConstants.isMaintenance((IProjectId)completedJob.getJob().getInternalProjectId())) {
                if (this.emptyJobQueuesInInitialAnalysisReached) {
                    this.setAnalysisProgressLive();
                }
                this.emptyJobQueuesInInitialAnalysisReached = true;
            }
        }
    }

    private void updateBranchAnalysisStates(Set<ParentedCommitDescriptor> finishedCommits, Set<ParentedCommitDescriptor> unfinishedCommits, ScheduledJob completedJob) throws StorageException {
        Set<CommitDescriptor> firstPreAnnouncedCommits = this.jobQueue.getFirstPreAnnouncedCommits();
        Set<String> branchesToUpdateState = this.calculateChangedBranches(CollectionUtils.mapToSet(finishedCommits, ParentedCommitDescriptor::getCommit), CollectionUtils.mapToSet(unfinishedCommits, ParentedCommitDescriptor::getCommit), firstPreAnnouncedCommits);
        if (!branchesToUpdateState.isEmpty()) {
            this.branchAnalysisStateIndex.updateBranchAnalysisStates(branchesToUpdateState, finishedCommits, unfinishedCommits, firstPreAnnouncedCommits, completedJob);
        }
    }

    private Set<String> calculateChangedBranches(Collection<CommitDescriptor> finishedCommits, Set<CommitDescriptor> unfinishedCommits, Set<CommitDescriptor> firstPreAnnouncedCommits) {
        HashSet<String> branchesToUpdate = new HashSet<String>();
        branchesToUpdate.addAll(CollectionUtils.map(finishedCommits, CommitDescriptor::getBranchName));
        branchesToUpdate.addAll(ProjectProgressPublisher.getBranchesOfDifferenceSet(firstPreAnnouncedCommits, this.previousFirstPreAnnouncedCommits));
        branchesToUpdate.addAll(ProjectProgressPublisher.getBranchesOfDifferenceSet(unfinishedCommits, this.previousUnfinishedCommits));
        this.previousFirstPreAnnouncedCommits = firstPreAnnouncedCommits;
        this.previousUnfinishedCommits = unfinishedCommits;
        return branchesToUpdate;
    }

    private static List<String> getBranchesOfDifferenceSet(Collection<CommitDescriptor> currentCommits, Collection<CommitDescriptor> previousCommits) {
        return CollectionUtils.map((Collection)CollectionUtils.differenceSet(currentCommits, (Collection[])new Collection[]{previousCommits}), CommitDescriptor::getBranchName);
    }

    @Override
    public void onProjectAnalysisStateChange(EAnalysisState previousState, EAnalysisState newState) {
        if (previousState == EAnalysisState.ROLLBACK_ANALYSIS && newState.isLive()) {
            try {
                Set<String> branchesInRollback = this.branchAnalysisStateIndex.getBranchesInRollback();
                for (String branch : branchesInRollback) {
                    this.branchAnalysisStateIndex.setBranchToLive(branch);
                }
            }
            catch (StorageException e) {
                LOGGER.error("Unable to update branches still in rollback to live state", (Throwable)e);
            }
        }
    }
}

