/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.PeriodicJobSupport;
import com.teamscale.core.runtime.impl.scheduling.ProjectProgressPublisher;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import com.teamscale.core.runtime.impl.scheduling.SchedulingHelper;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ProjectSchedulingData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SchedulingHelper schedulingHelper;
    private final PeriodicJobSupport periodicJobSupport;
    private final ProjectProgressPublisher progressPublisher;
    private final AtomicInteger lockCount = new AtomicInteger();
    private boolean needsTriggerReload = false;
    private final IndexLayer indexLayer;

    ProjectSchedulingData(InternalProjectId projectId, IndexLayer indexLayer, DurableIdGenerator idGenerator, PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport, SchedulingData globalSchedulingData) throws StorageException, TriggerCompilationException {
        this.indexLayer = indexLayer;
        TriggerCache triggerCache = new TriggerCache(projectId, indexLayer);
        PerformanceIndexBase performanceIndex = PerformanceIndexBase.open(indexLayer, (IProjectId)projectId);
        AnalysisProgressIndexBase progressIndex = AnalysisProgressIndexBase.open(indexLayer, (IProjectId)projectId);
        CommitDescriptorIndex commitDescriptorIndex = CommitDescriptorIndex.open(indexLayer, (IProjectId)projectId);
        BranchAnalysisStateIndex branchAnalysisStateIndex = indexLayer.openBranchAnalysisStateIndex(projectId);
        ProjectAnalysisProgress progress = new ProjectAnalysisProgress(performanceIndex, progressIndex, projectId, indexLayer);
        AssignedJobs assignedJobs = new AssignedJobs(progressIndex);
        JobQueue jobQueue = new JobQueue(progressIndex, commitDescriptorIndex, triggerCache, assignedJobs, globalSchedulingData.getRateLimitingSupport());
        for (ScheduledJob job : assignedJobs.getAllJobs()) {
            assignedJobs.removeJob(job);
            jobQueue.insertJob(job);
        }
        this.schedulingHelper = new SchedulingHelper(projectId, indexLayer, jobQueue, assignedJobs, triggerCache, progress, idGenerator, globalSchedulingData);
        this.periodicJobSupport = new PeriodicJobSupport(projectId, progressIndex, this.schedulingHelper, indexLayer);
        this.progressPublisher = new ProjectProgressPublisher(completedRevisionSupport, branchAnalysisStateIndex, commitDescriptorIndex, assignedJobs, jobQueue, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSchedulingHelper(Consumer<SchedulingHelper> action) {
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            this.lockCount.incrementAndGet();
            this.reloadTriggersIfNeeded();
            try {
                action.accept(this.schedulingHelper);
            }
            finally {
                this.lockCount.decrementAndGet();
            }
        }
    }

    public ProjectProgressPublisher getProgressPublisher() {
        return this.progressPublisher;
    }

    public void runWithPeriodicJobSupport(Consumer<PeriodicJobSupport> action) {
        this.runWithSchedulingHelper(ignored -> {
            PeriodicJobSupport periodicJobSupport = this.periodicJobSupport;
            synchronized (periodicJobSupport) {
                action.accept(this.periodicJobSupport);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDeadConnectorCheck() throws StorageException {
        if (EFeatureToggle.DISABLE_DEAD_CONNECTOR_CHECK.isEnabled() || SchedulingConstants.isMaintenance((IProjectId)this.getInternalProjectId())) {
            return;
        }
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            if (this.schedulingHelper.isNonNullSchedulingCommitJobRunningOrReady() && !this.schedulingHelper.isSchedulingDeadlock()) {
                return;
            }
        }
        HashMap<String, Long> rollbackMap = new HashMap<String, Long>();
        HashSet<String> storesWithDeadEntries = new HashSet<String>();
        CommitTreeIndex.listCommitTrees(this.indexLayer.openProjectStorageSystem((IProjectId)this.getInternalProjectId())).forEach((storeName, commitTree) -> {
            for (ICommitTreeNode iCommitTreeNode : commitTree.getAllNodes()) {
                boolean jobShouldBeScheduled = iCommitTreeNode.getState() == ECommitTreeNodeState.SCHEDULED && iCommitTreeNode.getAdjustedTimestamp().isPresent();
                if (!jobShouldBeScheduled || this.schedulingHelper.getJobQueue().existsJobForCommit(iCommitTreeNode.getCommitDescriptorWithAdjustedTimestamp())) continue;
                rollbackMap.merge(iCommitTreeNode.getBranchName(), iCommitTreeNode.getAdjustedTimestamp().getAsLong() - 1L, Math::min);
                storesWithDeadEntries.add((String)storeName);
            }
        });
        this.updateRollbackCommitsFromPreAnnouncements(rollbackMap);
        if (rollbackMap.isEmpty()) {
            return;
        }
        this.scheduleRollbackForDeadStores(rollbackMap, storesWithDeadEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRollbackForDeadStores(Map<String, Long> rollbackMap, Set<String> storesWithDeadEntries) throws StorageException {
        String reason = ProjectSchedulingData.computeReasonForRollback(rollbackMap, storesWithDeadEntries);
        RollbackRequest rollbackRequest = new RollbackRequest(CollectionUtils.map(rollbackMap.entrySet(), entry -> new CommitDescriptor((String)entry.getKey(), ((Long)entry.getValue()).longValue())), reason);
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            this.schedulingHelper.scheduleRollback(rollbackRequest, null);
        }
    }

    private static String computeReasonForRollback(Map<String, Long> rollbackMap, Set<String> storesWithDeadEntries) {
        if (!storesWithDeadEntries.isEmpty()) {
            return "Detected dead repository connectors in " + StringUtils.concat(storesWithDeadEntries, (String)", ");
        }
        return "Scheduling deadlock detected. Pre-announcements: " + StringUtils.toString(rollbackMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRollbackCommitsFromPreAnnouncements(Map<String, Long> rollbackMap) throws StorageException {
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            if (this.schedulingHelper.isSchedulingDeadlock()) {
                for (Map.Entry<String, Long> entry : this.schedulingHelper.getJobQueue().getFirstPreAnnouncementsByBranch().entrySet()) {
                    rollbackMap.merge(entry.getKey(), entry.getValue() - 1L, Math::min);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTriggersIfNeeded() {
        if (!this.needsTriggerReload) {
            return;
        }
        this.needsTriggerReload = false;
        this.schedulingHelper.getTriggerCache().reload();
        PeriodicJobSupport periodicJobSupport = this.periodicJobSupport;
        synchronized (periodicJobSupport) {
            try {
                this.periodicJobSupport.schedulePeriodicJobs(0L, false);
            }
            catch (StorageException e) {
                LOGGER.error("Had to skip periodic job scheduling due to storage issues!", (Throwable)e);
            }
        }
    }

    public boolean isPartiallyLocked() {
        return this.lockCount.get() > 0;
    }

    public void markForTriggerReload() {
        this.needsTriggerReload = true;
    }

    public InternalProjectId getInternalProjectId() {
        return this.schedulingHelper.getInternalProjectId();
    }

    public PublicProjectId loadPublicProjectId() {
        return this.schedulingHelper.loadPublicProjectId();
    }

    public int getAssignedJobCount() {
        return this.schedulingHelper.getAssignedJobs().size();
    }

    public List<JobDescriptor> getAssignedJobs() {
        return this.schedulingHelper.getAssignedJobs().getAllJobs().stream().map(ScheduledJob::getJob).toList();
    }

    public int getJobQueueSize() {
        return this.schedulingHelper.getJobQueue().size();
    }

    public int getDelayedJobQueueSize() {
        long now = System.currentTimeMillis();
        return (int)this.schedulingHelper.getJobQueue().getAllJobs().stream().filter(scheduledJob -> scheduledJob.getEarliestScheduleTimestamp() > now).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonperiodicJobsScheduled() throws TriggerCompilationException {
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            for (ScheduledJob job : this.schedulingHelper.getJobQueue().getAllJobs()) {
                ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(job);
                if (trigger.isPeriodic()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScheduledJob> getScheduledNonperiodicJobs() throws TriggerCompilationException {
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            ArrayList<ScheduledJob> scheduledNonperiodicJobs = new ArrayList<ScheduledJob>();
            for (ScheduledJob job : this.schedulingHelper.getJobQueue().getAllJobs()) {
                ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(job);
                if (trigger.isPeriodic()) continue;
                scheduledNonperiodicJobs.add(job);
            }
            return scheduledNonperiodicJobs;
        }
    }

    public String toString() {
        return "Project scheduling data for project " + String.valueOf(this.schedulingHelper.getInternalProjectId());
    }

    public TriggerCache getTriggerCache() {
        return this.schedulingHelper.getTriggerCache();
    }

    public boolean isInvalid() {
        return this.periodicJobSupport.isInvalid();
    }

    public void markInvalid() {
        this.periodicJobSupport.markInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescheduleJobNow(String triggerName, CommitDescriptor schedulingCommit) {
        SchedulingHelper schedulingHelper = this.schedulingHelper;
        synchronized (schedulingHelper) {
            this.schedulingHelper.getJobQueue().getJobsForCommit(schedulingCommit).stream().filter(job -> Objects.equals(triggerName, job.getTriggerName())).findAny().ifPresent(scheduledJob -> {
                if (this.schedulingHelper.getJobQueue().removeJob((ScheduledJob)scheduledJob)) {
                    ScheduledJob jobToReschedule = ScheduledJob.copyWithRescheduleUpdate(scheduledJob, 0L, 0);
                    this.schedulingHelper.rescheduleJob(jobToReschedule);
                }
            });
        }
    }
}

